/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.peripherals;

import com.simibubi.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class DisplayLinkPeripheral
extends SyncedPeripheral<DisplayLinkBlockEntity> {
    public static final String TAG_KEY = "ComputerSourceList";
    private final AtomicInteger cursorX = new AtomicInteger();
    private final AtomicInteger cursorY = new AtomicInteger();

    public DisplayLinkPeripheral(DisplayLinkBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) {
        this.cursorX.set(x - 1);
        this.cursorY.set(y - 1);
    }

    @LuaFunction
    public final Object[] getCursorPos() {
        return new Object[]{this.cursorX.get() + 1, this.cursorY.get() + 1};
    }

    @LuaFunction(mainThread=true)
    public final Object[] getSize() {
        DisplayTargetStats stats = ((DisplayLinkBlockEntity)this.blockEntity).activeTarget.provideStats(new DisplayLinkContext(((DisplayLinkBlockEntity)this.blockEntity).m_58904_(), (DisplayLinkBlockEntity)this.blockEntity));
        return new Object[]{stats.maxRows(), stats.maxColumns()};
    }

    @LuaFunction
    public final boolean isColor() {
        return false;
    }

    @LuaFunction
    public final boolean isColour() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void write(String text) {
        ListTag tag = ((DisplayLinkBlockEntity)this.blockEntity).getSourceConfig().m_128437_(TAG_KEY, 8);
        int x = this.cursorX.get();
        int y = this.cursorY.get();
        for (int i = tag.size(); i <= y; ++i) {
            tag.add((Object)StringTag.m_129297_((String)""));
        }
        StringBuilder builder = new StringBuilder(tag.m_128778_(y));
        builder.append(" ".repeat(Math.max(0, x - builder.length())));
        builder.replace(x, x + text.length(), text);
        tag.set(y, (Tag)StringTag.m_129297_((String)builder.toString()));
        DisplayLinkBlockEntity displayLinkBlockEntity = (DisplayLinkBlockEntity)this.blockEntity;
        synchronized (displayLinkBlockEntity) {
            ((DisplayLinkBlockEntity)this.blockEntity).getSourceConfig().m_128365_(TAG_KEY, (Tag)tag);
        }
        this.cursorX.set(x + text.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void clearLine() {
        ListTag tag = ((DisplayLinkBlockEntity)this.blockEntity).getSourceConfig().m_128437_(TAG_KEY, 8);
        if (tag.size() > this.cursorY.get()) {
            tag.set(this.cursorY.get(), (Tag)StringTag.m_129297_((String)""));
        }
        DisplayLinkBlockEntity displayLinkBlockEntity = (DisplayLinkBlockEntity)this.blockEntity;
        synchronized (displayLinkBlockEntity) {
            ((DisplayLinkBlockEntity)this.blockEntity).getSourceConfig().m_128365_(TAG_KEY, (Tag)tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final void clear() {
        DisplayLinkBlockEntity displayLinkBlockEntity = (DisplayLinkBlockEntity)this.blockEntity;
        synchronized (displayLinkBlockEntity) {
            ((DisplayLinkBlockEntity)this.blockEntity).getSourceConfig().m_128365_(TAG_KEY, (Tag)new ListTag());
        }
    }

    @LuaFunction(mainThread=true)
    public final void update() {
        ((DisplayLinkBlockEntity)this.blockEntity).tickSource();
    }

    @NotNull
    public String getType() {
        return "Create_DisplayLink";
    }
}

