/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.foundation.data.recipe.SiftingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SiftingRecipeSerializer
implements RecipeSerializer<SiftingRecipe> {
    private final SiftingRecipeBuilder.SiftingRecipeFactory factory;

    public SiftingRecipeSerializer(SiftingRecipeBuilder.SiftingRecipeFactory factory) {
        this.factory = factory;
    }

    protected void writeToJson(JsonObject json, SiftingRecipe recipe) {
        JsonArray jsonIngredients = new JsonArray();
        JsonArray jsonOutputs = new JsonArray();
        recipe.m_7527_().forEach(i -> jsonIngredients.add(i.m_43942_()));
        recipe.results.forEach(o -> jsonOutputs.add(o.serialize()));
        json.add("ingredients", (JsonElement)jsonIngredients);
        json.add("results", (JsonElement)jsonOutputs);
        int processingDuration = recipe.getProcessingDuration();
        if (processingDuration > 0) {
            json.addProperty("processingTime", (Number)processingDuration);
        }
        recipe.writeAdditional(json);
    }

    protected SiftingRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder(this.factory, recipeId);
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
            ingredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        for (JsonElement je : GsonHelper.m_13933_((JsonObject)json, (String)"results")) {
            JsonObject jsonObject = je.getAsJsonObject();
            results.add((Object)ProcessingOutput.deserialize((JsonElement)je));
        }
        builder.withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"processingTime")) {
            builder.duration(GsonHelper.m_13927_((JsonObject)json, (String)"processingTime"));
        }
        SiftingRecipe recipe = builder.build();
        recipe.readAdditional(json);
        return recipe;
    }

    protected void writeToBuffer(FriendlyByteBuf buffer, SiftingRecipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        NonNullList<ProcessingOutput> outputs = recipe.results;
        buffer.m_130130_(ingredients.size());
        ingredients.forEach(i -> i.m_43923_(buffer));
        buffer.m_130130_(outputs.size());
        outputs.forEach(o -> o.write(buffer));
        buffer.m_130130_(recipe.getProcessingDuration());
        recipe.writeAdditional(buffer);
    }

    protected SiftingRecipe readFromBuffer(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int i;
        NonNullList ingredients = NonNullList.m_122779_();
        NonNullList results = NonNullList.m_122779_();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ingredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            results.add((Object)ProcessingOutput.read((FriendlyByteBuf)buffer));
        }
        SiftingRecipe recipe = new SiftingRecipeBuilder(this.factory, recipeId).withItemIngredients((NonNullList<Ingredient>)ingredients).withItemOutputs((NonNullList<ProcessingOutput>)results).duration(buffer.m_130242_()).build();
        recipe.readAdditional(buffer);
        return recipe;
    }

    public final void write(JsonObject json, SiftingRecipe recipe) {
        this.writeToJson(json, recipe);
    }

    public final SiftingRecipe fromJson(ResourceLocation id, JsonObject json) {
        return this.readFromJson(id, json);
    }

    public final void toNetwork(FriendlyByteBuf buffer, SiftingRecipe recipe) {
        this.writeToBuffer(buffer, recipe);
    }

    public final SiftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        return this.readFromBuffer(id, buffer);
    }

    public SiftingRecipeBuilder.SiftingRecipeFactory getFactory() {
        return this.factory;
    }
}

