/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.crafttweaker;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.createtweaker.CreateTweaker;
import com.oierbravo.createsifter.compat.crafttweaker.RecipeComponents;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.foundation.data.recipe.SiftingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=SiftingRecipe.class)
public class SiftingRecipeHandler
implements IRecipeHandler<SiftingRecipe> {
    public String dumpToCommandString(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe recipe) {
        return manager.getCommandString() + recipe.toString() + recipe.getRollableResults() + "[" + recipe.m_7527_() + "]";
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe firstRecipe, U secondRecipe) {
        if (!this.isGoodRecipe(secondRecipe)) {
            return false;
        }
        SiftingRecipe second = (SiftingRecipe)secondRecipe;
        if (firstRecipe.m_7527_().size() == second.m_7527_().size()) {
            return IngredientUtil.doIngredientsConflict((List)firstRecipe.m_7527_(), (List)second.m_7527_());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super SiftingRecipe> manager, SiftingRecipe recipe) {
        return Optional.of(IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, recipe.m_7527_().stream().map(IIngredient::fromIngredient).toList()).with(BuiltinRecipeComponents.Output.CHANCED_ITEMS_SINGLE, recipe.getRollableResults().stream().map(CreateTweaker::mapProcessingResult).toList()).with(BuiltinRecipeComponents.Processing.TIME, (Object)recipe.getProcessingDuration()).with(RecipeComponents.Input.BOOLEAN, (Object)recipe.isWaterlogged()).with(RecipeComponents.Input.FLOAT, (Object)Float.valueOf(recipe.getMinimumSpeed())).build());
    }

    public Optional<SiftingRecipe> recompose(IRecipeManager<? super SiftingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder(this.factory(), name);
        builder.withItemIngredients((NonNullList<Ingredient>)recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS).stream().map(IIngredient::asVanillaIngredient).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.withItemOutputs((NonNullList<ProcessingOutput>)recipe.getOrThrow(BuiltinRecipeComponents.Output.CHANCED_ITEMS_SINGLE).stream().map(CreateTweaker::mapPercentagedToProcessingOutput).collect(Collectors.toCollection(NonNullList::m_122779_)));
        builder.duration((Integer)recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME));
        builder.waterlogged((Boolean)recipe.getOrThrowSingle(RecipeComponents.Input.BOOLEAN));
        builder.minimumSpeed(((Float)recipe.getOrThrowSingle(RecipeComponents.Input.FLOAT)).floatValue());
        return Optional.of(builder.build());
    }

    public SiftingRecipeBuilder.SiftingRecipeFactory factory() {
        return SiftingRecipe::new;
    }

    public boolean isGoodRecipe(Recipe<?> recipe) {
        return recipe instanceof SiftingRecipe;
    }
}

