/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WTooltip;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class WButton
extends WTooltip {
    protected int xPos;
    protected int yPos;
    protected int xSize;
    protected int ySize;
    protected IWidget.ListenerAction<? super WButton> listener;
    protected boolean disabled;
    protected Map<Integer, Boolean> keys = new HashMap<Integer, Boolean>();

    public WButton(int xPos, int yPos, int xSize, int ySize, @Nullable String name) {
        super(name);
        this.xPos = xPos;
        this.yPos = yPos;
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public WButton setListener(IWidget.ListenerAction<? super WButton> r) {
        this.listener = r;
        return this;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        super.onDraw(gui, xMouse, yMouse);
        boolean hovered = this.hovered(xMouse, yMouse);
        Resource res = this.disabled ? Resource.WGT_BUTTON_D : (this.hovered(xMouse, yMouse) ? Resource.WGT_BUTTON_F : Resource.WGT_BUTTON_N);
        gui.drawResourceContinuous(res, this.xPos, this.yPos, this.xSize, this.ySize, 5, 5, 5, 5);
        return hovered;
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (this.mouseIn(xMouse, yMouse) && !this.disabled && button == 0 && this.listener != null) {
            this.trigger();
            return true;
        }
        return false;
    }

    protected boolean hovered(int xMouse, int yMouse) {
        return this.mouseIn(xMouse, yMouse) || this.keys.entrySet().stream().anyMatch(Map.Entry::getValue);
    }

    private void trigger() {
        this.listener.invoke(this);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    public boolean onKeyPressed(JecaGui gui, int key, int modifier) {
        if (this.keys.containsKey(key)) {
            this.keys.put(key, true);
            this.trigger();
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyReleased(JecaGui gui, int key, int modifier) {
        if (this.keys.containsKey(key)) {
            this.keys.put(key, false);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.xPos, this.yPos, this.xSize - 2, this.ySize - 2, xMouse, yMouse);
    }

    public WButton setDisabled(boolean b) {
        this.disabled = b;
        return this;
    }

    @Override
    protected List<String> getSuffix() {
        return this.disabled ? Arrays.asList("disabled", "enabled", "") : Arrays.asList("enabled", "");
    }

    public WButton setKeyBind(int ... keys) {
        this.keys.clear();
        for (int key : keys) {
            this.keys.put(key, false);
        }
        return this;
    }
}

