/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.RecordCraft;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WCross;
import me.towdium.jecalculation.gui.widgets.WDrag;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WText;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class GuiCraftMini
extends WContainer {
    public final int WINDOW_WIDTH = 108;
    public final int WINDOW_HEIGHT = 113;
    protected int slot = 0;
    protected ItemStack itemStack;
    protected CostList.Calculator calculator = null;
    public RecordCraft record;
    protected IWidget.ListenerAction<? super GuiCraftMini> windowFocusListener = null;
    protected IWidget.ListenerAction<? super GuiCraftMini> windowCloseListener = null;
    WDrag drag = new WDrag(4, 4, 95, 5);
    WButton close = new WCross(99, 4).setListener(widget -> {
        this.record.overlayOpen = false;
        Controller.setRCraft(this.record, this.itemStack, this.slot);
        if (this.windowCloseListener != null) {
            this.windowCloseListener.invoke(this);
        }
    });
    WLabel label = new WLabel(5, 10, 20, 20, false);
    WTextField amount = new WTextField(34, 10, 69).setListener(i -> {
        this.record.amount = i.getText();
        Controller.setRCraft(this.record, this.itemStack, this.slot);
        this.refreshCalculator();
    });
    WButton invE = new WButtonIcon(83, 32, 20, 20, Resource.BTN_INV_E, "craft.inventory_enabled");
    WButton invD = new WButtonIcon(83, 32, 20, 20, Resource.BTN_INV_D, "craft.inventory_disabled");
    WButton input = new WButtonIcon(5, 32, 20, 20, Resource.BTN_IN, "common.input").setListener(i -> this.setMode(RecordCraft.Mode.INPUT));
    WButton output = new WButtonIcon(24, 32, 20, 20, Resource.BTN_OUT, "craft.output").setListener(i -> this.setMode(RecordCraft.Mode.OUTPUT));
    WButton catalyst = new WButtonIcon(42, 32, 20, 20, Resource.BTN_CAT, "common.catalyst").setListener(i -> this.setMode(RecordCraft.Mode.CATALYST));
    WButton steps = new WButtonIcon(61, 32, 20, 20, Resource.BTN_LIST, "craft.step").setListener(i -> this.setMode(RecordCraft.Mode.STEPS));
    WLabelScroll result = new WLabelScroll(5, 54, 5, 3, false, 0, 8).setLsnrClick((i, v) -> Utilities.showRecipe(i.get((int)v).getLabel())).setFmtAmount(i -> i.getAmountString(true)).setFmtTooltip((i, j) -> i.getToolTip((List<String>)j, true));

    public GuiCraftMini(@Nullable ItemStack is, int slot) {
        this.itemStack = is;
        this.record = Controller.getRCraft(is);
        this.slot = slot;
        this.offsetX = this.record.overlayPositionX;
        this.offsetY = this.record.overlayPositionY;
        this.amount.setText(this.record.amount);
        this.add(new WPanel(0, 0, 108, 113));
        this.add(new WText(27, 16, JecaGui.FontType.RAW, "x"));
        this.add(this.drag, this.close, this.label, this.input, this.output, this.catalyst, this.steps, this.result, this.amount, this.record.inventory ? this.invE : this.invD);
        this.drag.setDragStartListener(widget -> widget.setConsumerOffset(this.offsetX, this.offsetY)).setDragMoveListener((widget, value) -> {
            this.offsetX = value.getNewX();
            this.offsetY = value.getNewY();
        }).setDragStopListener(widget -> {
            this.record.overlayPositionX = this.offsetX;
            this.record.overlayPositionY = this.offsetY;
            Controller.setRCraft(this.record, this.itemStack, slot);
        });
        this.invE.setListener(i -> {
            this.record.inventory = false;
            Controller.setRCraft(this.record, this.itemStack, slot);
            this.remove(this.invE);
            this.add(this.invD);
            this.refreshCalculator();
        });
        this.invD.setListener(i -> {
            this.record.inventory = true;
            Controller.setRCraft(this.record, this.itemStack, slot);
            this.remove(this.invD);
            this.add(this.invE);
            this.refreshCalculator();
        });
        this.refreshRecent();
        this.setMode(this.record.mode);
    }

    void setMode(RecordCraft.Mode mode) {
        this.record.mode = mode;
        Controller.setRCraft(this.record, this.itemStack, this.slot);
        this.input.setDisabled(mode == RecordCraft.Mode.INPUT);
        this.output.setDisabled(mode == RecordCraft.Mode.OUTPUT);
        this.catalyst.setDisabled(mode == RecordCraft.Mode.CATALYST);
        this.steps.setDisabled(mode == RecordCraft.Mode.STEPS);
        this.refreshResult();
    }

    void refreshRecent() {
        this.label.setLabel(this.record.getLatest());
    }

    public void refreshCalculator() {
        try {
            String s = this.amount.getText();
            long i = s.isEmpty() ? 1L : Long.parseLong(this.amount.getText());
            this.amount.setColor(0xFFFFFF);
            List<ILabel> dest = Collections.singletonList(this.label.getLabel().copy().setAmount(i));
            CostList list = this.record.inventory ? new CostList(this.getInventory(), dest) : new CostList(dest);
            this.calculator = list.calculate();
        }
        catch (ArithmeticException | NumberFormatException e) {
            this.amount.setColor(0xFF0000);
            this.calculator = null;
        }
        this.refreshResult();
    }

    List<ILabel> getInventory() {
        Inventory inv = Utilities.getPlayer().m_150109_();
        ArrayList<ILabel> labels = new ArrayList<ILabel>();
        Consumer<List> add = i -> i.stream().filter(j -> !j.m_41619_()).forEach(j -> labels.add(ILabel.Converter.from(j)));
        add.accept((List)inv.f_35975_);
        add.accept((List)inv.f_35974_);
        add.accept((List)inv.f_35976_);
        return labels;
    }

    void refreshResult() {
        if (this.calculator == null) {
            this.result.setLabels(new ArrayList<ILabel>());
        } else {
            switch (this.record.mode) {
                case INPUT: {
                    this.result.setLabels(this.calculator.getInputs());
                    break;
                }
                case OUTPUT: {
                    this.result.setLabels(this.calculator.getOutputs(this.getInventory()));
                    break;
                }
                case CATALYST: {
                    this.result.setLabels(this.calculator.getCatalysts());
                    break;
                }
                case STEPS: {
                    this.result.setLabels(this.calculator.getSteps());
                }
            }
        }
    }

    private void refreshLabel(ILabel l) {
        this.record.push(l, false);
        Controller.setRCraft(this.record, this.itemStack, this.slot);
        this.refreshCalculator();
    }

    @Override
    public boolean onMouseClicked(JecaGui gui, int xMouse, int yMouse, int button) {
        if (!this.mouseIn(xMouse, yMouse)) {
            return false;
        }
        if (this.windowFocusListener != null) {
            this.windowFocusListener.invoke(this);
        }
        super.onMouseClicked(gui, xMouse, yMouse, button);
        return true;
    }

    protected boolean mouseIn(int xMouse, int yMouse) {
        return JecaGui.mouseIn(this.offsetX, this.offsetY, 108, 113, xMouse, yMouse);
    }

    public GuiCraftMini setOnFocusListener(IWidget.ListenerAction<? super GuiCraftMini> windowFocusListener) {
        this.windowFocusListener = windowFocusListener;
        return this;
    }

    public GuiCraftMini setWindowCloseListener(IWidget.ListenerAction<? super GuiCraftMini> windowCloseListener) {
        this.windowCloseListener = windowCloseListener;
        return this;
    }

    public void setDepth(int depth, boolean save) {
        if (this.record.overlayDepth != depth) {
            this.record.overlayDepth = depth;
            if (save) {
                Controller.setRCraft(this.record, this.itemStack, this.slot);
            }
        }
    }

    public void setDepth(int depth) {
        this.setDepth(depth, false);
    }

    public int getDepth() {
        return this.record.overlayDepth;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return this.WINDOW_WIDTH;
    }

    public int getHeight() {
        return this.WINDOW_HEIGHT;
    }
}

