/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.towdium.jecalculation.JecaItem;
import me.towdium.jecalculation.utils.Utilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class InventorySummary {
    protected List<ItemAmount> amounts = new ArrayList<ItemAmount>();

    public InventorySummary(Inventory inventory) {
        inventory.f_35975_.forEach(this::addItemStack);
        inventory.f_35974_.forEach(this::addItemStack);
        inventory.f_35976_.forEach(this::addItemStack);
    }

    protected void addItemStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        Optional<ItemAmount> existingAmount = this.amounts.stream().filter(item -> this.isStackTypeEqual(item.stack, stack)).findFirst();
        if (existingAmount.isPresent()) {
            existingAmount.get().amount += stack.m_41613_();
        } else {
            this.amounts.add(new ItemAmount(stack, stack.m_41613_()));
        }
    }

    protected boolean isStackTypeEqual(ItemStack first, ItemStack second) {
        if (first.m_41720_() != second.m_41720_()) {
            return false;
        }
        if (first.m_41720_() instanceof JecaItem && second.m_41720_() instanceof JecaItem) {
            return first.m_41720_() == second.m_41720_();
        }
        return Utilities.areCapsCompatible(first, second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventorySummary that = (InventorySummary)o;
        if (this.amounts.size() != that.amounts.size()) {
            return false;
        }
        return that.amounts.stream().allMatch(test -> {
            Optional<ItemAmount> thisAmount = this.amounts.stream().filter(item -> this.isStackTypeEqual(item.stack, test.stack)).findFirst();
            return thisAmount.isPresent() && test.amount == thisAmount.get().amount;
        });
    }

    public int hashCode() {
        return Objects.hash(this.amounts);
    }

    private static class ItemAmount {
        ItemStack stack;
        int amount;

        ItemAmount(ItemStack stack, int amount) {
            this.stack = stack;
            this.amount = amount;
        }
    }
}

