/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import dev.architectury.fluid.FluidStack;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LFluidTag;
import me.towdium.jecalculation.data.label.labels.LItemStack;
import me.towdium.jecalculation.data.label.labels.LItemTag;
import me.towdium.jecalculation.data.label.labels.LStack;
import me.towdium.jecalculation.data.label.labels.LTag;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public interface Context<T> {
    public static final Context<Item> ITEM = new Context<Item>(){

        @Override
        public LStack<Item> create(Item item) {
            return new LItemStack(new ItemStack((ItemLike)item));
        }

        @Override
        public Registry<Item> registry() {
            return Registry.f_122827_;
        }

        @Override
        public Stream<Pair<TagKey<Item>, Stream<Item>>> tags() {
            return Utilities.getTags(this.registry());
        }

        @Override
        public LTag<Item> create(TagKey<Item> rl) {
            return new LItemTag(rl);
        }

        @Override
        public LTag<Item> create(TagKey<Item> rl, long amount) {
            return new LItemTag(rl, amount);
        }
    };
    public static final Context<Fluid> FLUID = new Context<Fluid>(){

        @Override
        public LStack<Fluid> create(Fluid fluid) {
            return new LFluidStack(FluidStack.create((Fluid)fluid, (long)1000L));
        }

        @Override
        public Registry<Fluid> registry() {
            return Registry.f_122822_;
        }

        @Override
        public Stream<Pair<TagKey<Fluid>, Stream<Fluid>>> tags() {
            return Utilities.getTags(this.registry());
        }

        @Override
        public LTag<Fluid> create(TagKey<Fluid> rl) {
            return new LFluidTag(rl);
        }

        @Override
        public LTag<Fluid> create(TagKey<Fluid> rl, long amount) {
            return new LFluidTag(rl, amount);
        }
    };

    public LStack<T> create(T var1);

    public Stream<Pair<TagKey<T>, Stream<T>>> tags();

    public Registry<T> registry();

    public LTag<T> create(TagKey<T> var1);

    public LTag<T> create(TagKey<T> var1, long var2);

    default public Collection<TagKey<T>> discover(LStack<T> s) {
        return this.tags().filter(pair -> ((Stream)pair.getTwo()).anyMatch(t -> Objects.equals(t, s.get()))).map(Pair::getOne).toList();
    }

    default public Stream<LStack<T>> discover(TagKey<T> tag) {
        return this.tags().filter(pair -> Utilities.equals((TagKey)pair.getOne(), tag)).flatMap(Pair::getTwo).map(this::create);
    }

    default public boolean matches(TagKey<?> tag, LStack<?> s) {
        if (s.getContext() != this) {
            return false;
        }
        Optional tagEntry = this.registry().m_203431_(tag);
        if (tagEntry.isEmpty()) {
            return false;
        }
        return ((HolderSet.Named)tagEntry.get()).m_203614_().map(Holder::m_203334_).anyMatch(t -> t.equals(s.get()));
    }
}

