/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public final class TeleportHelper {
    public static boolean teleport(EntityMaid maid) {
        if (!maid.f_19853_.m_5776_() && maid.m_6084_()) {
            double x = maid.m_20185_() + (maid.m_217043_().m_188500_() - 0.5) * 16.0;
            double y = maid.m_20186_() + (double)maid.m_217043_().m_188503_(16) - 8.0;
            double z = maid.m_20189_() + (maid.m_217043_().m_188500_() - 0.5) * 16.0;
            return TeleportHelper.teleport(maid, x, y, z);
        }
        return false;
    }

    public static boolean teleportToRestrictCenter(EntityMaid maid) {
        BlockPos blockPos = maid.m_21534_();
        if (!maid.f_19853_.m_5776_() && maid.m_6084_()) {
            int x = blockPos.m_123341_() + TeleportHelper.randomIntInclusive(maid.m_217043_(), -3, 3);
            int y = blockPos.m_123342_() + TeleportHelper.randomIntInclusive(maid.m_217043_(), 0, 3);
            int z = blockPos.m_123343_() + TeleportHelper.randomIntInclusive(maid.m_217043_(), -3, 3);
            return TeleportHelper.teleport(maid, x, y, z);
        }
        return false;
    }

    private static boolean teleport(EntityMaid maid, double x, double y, double z) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockPos.m_123342_() > maid.f_19853_.m_141937_() && !maid.f_19853_.m_8055_((BlockPos)blockPos).m_60767_().m_76334_()) {
            blockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = maid.f_19853_.m_8055_((BlockPos)blockPos);
        boolean isMotion = blockState.m_60767_().m_76334_();
        boolean isWater = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (isMotion && !isWater) {
            boolean teleportIsSuccess = maid.m_20984_(x, y, z, true);
            if (teleportIsSuccess && !maid.m_20067_()) {
                maid.f_19853_.m_6263_(null, maid.f_19854_, maid.f_19855_, maid.f_19856_, SoundEvents.f_11852_, maid.m_5720_(), 1.0f, 1.0f);
                maid.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return teleportIsSuccess;
        }
        return false;
    }

    private static int randomIntInclusive(RandomSource random, int min, int max) {
        return random.m_188503_(max - min + 1) + min;
    }
}

