/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RenderHelper {
    public static void renderFloatingText(PoseStack poseStack, String text, Vec3 vec, int color, float scale, float yOffset) {
        RenderHelper.renderFloatingText(poseStack, text, vec.f_82479_ + 0.5, vec.f_82480_ + 1.5, vec.f_82481_ + 0.5, color, scale, true, yOffset, true);
    }

    public static void renderFloatingText(PoseStack poseStack, String text, double x, double y, double z, int color, float scale, boolean center, float yOffset, boolean seeThrough) {
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = minecraft.m_91269_().m_110104_();
        Camera camera = minecraft.f_91063_.m_109153_();
        if (camera.m_90593_()) {
            Font font = minecraft.f_91062_;
            double viewX = camera.m_90583_().f_82479_;
            double viewY = camera.m_90583_().f_82480_;
            double viewZ = camera.m_90583_().f_82481_;
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)(x - viewX)), (double)((float)(y - viewY) + 0.07f), (double)((float)(z - viewZ)));
            poseStack.m_166854_(new Matrix4f(camera.m_90591_()));
            poseStack.m_85841_(-scale, -scale, scale);
            float fontX = center ? (float)(-font.m_92895_(text)) / 2.0f : 0.0f;
            font.m_92811_(text, fontX, yOffset, color, false, poseStack.m_85850_().m_85861_(), (MultiBufferSource)buffer, seeThrough, 0, 0xF000F0);
            poseStack.m_85849_();
            buffer.m_109911_();
        }
    }

    public static void renderLine(PoseStack poseStack, VertexConsumer consumer, Vec3 start, Vec3 end, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        consumer.m_85982_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_85982_(matrix4f, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_85982_(matrix4f, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    public static void renderCylinder(PoseStack poseStack, VertexConsumer consumer, Vec3 centerPos, double radius, int precision, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        double precisionAngle = Math.PI * 2 / (double)precision;
        for (int i = precision; i >= 0; --i) {
            double x1 = centerPos.f_82479_ + radius * Math.cos((double)i * precisionAngle);
            double x2 = centerPos.f_82479_ + radius * Math.cos((double)(i - 1) * precisionAngle);
            double y = centerPos.f_82480_;
            double z1 = centerPos.f_82481_ + radius * Math.sin((double)i * precisionAngle);
            double z2 = centerPos.f_82481_ + radius * Math.sin((double)(i - 1) * precisionAngle);
            consumer.m_85982_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_85982_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 1.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_85982_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_85982_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_85982_(matrix4f, (float)x1, (float)y, (float)z1).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
            consumer.m_85982_(matrix4f, (float)x2, (float)y, (float)z2).m_85950_(red, green, blue, 1.0f).m_85977_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        }
    }

    public static void addChainedFilledBoxVertices(PoseStack matrixStack, AABB aabb, float pRed, float pGreen, float pBlue, float pAlpha) {
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        float pMinX = (float)aabb.f_82288_;
        float pMinY = (float)aabb.f_82289_;
        float pMinZ = (float)aabb.f_82290_;
        float pMaxX = (float)aabb.f_82291_;
        float pMaxY = (float)aabb.f_82292_;
        float pMaxZ = (float)aabb.f_82293_;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        builder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMinY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMinX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMinZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        builder.m_85982_(matrix4f, pMaxX, pMaxY, pMaxZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69493_();
    }

    public static void renderEntityInInventory(PoseStack poseStack, int pX, int pY, int blitOffset, int scale, Quaternion pose, @Nullable Quaternion cameraOrientation, LivingEntity entity) {
        poseStack.m_85836_();
        poseStack.m_85837_((double)pX, (double)pY, (double)(blitOffset + 50));
        poseStack.m_166854_(Matrix4f.m_27632_((float)scale, (float)scale, (float)(-scale)));
        poseStack.m_85845_(pose);
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.m_91087_().m_91290_();
        if (cameraOrientation != null) {
            cameraOrientation.m_80157_();
            entityrenderdispatcher.m_114412_(cameraOrientation);
        }
        entityrenderdispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityrenderdispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        RenderSystem.m_69465_();
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        entityrenderdispatcher.m_114468_(true);
        poseStack.m_85849_();
        Lighting.m_84931_();
    }
}

