/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class ItemBreakMessage {
    private final int id;
    private final ItemStack item;

    public ItemBreakMessage(int id, ItemStack item) {
        this.id = id;
        this.item = item;
    }

    public static void encode(ItemBreakMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.id);
        buf.m_130055_(message.item);
    }

    public static ItemBreakMessage decode(FriendlyByteBuf buf) {
        return new ItemBreakMessage(buf.readInt(), buf.m_130267_());
    }

    public static void handle(ItemBreakMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ItemBreakMessage.handleBreakItem(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleBreakItem(ItemBreakMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        Entity e = mc.f_91073_.m_6815_(message.id);
        if (e instanceof LivingEntity && e.m_6084_()) {
            ((LivingEntity)e).m_21278_(message.item);
        }
    }
}

