/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import com.github.tartaricacid.touhoulittlemaid.util.BytesBooleansConvert;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class WirelessIOBauble
implements IMaidBauble {
    private static final int SLOT_NUM = 38;

    @Nonnull
    public static ItemStack insertItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        int i;
        if (stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return WirelessIOBauble.insertItem(inventory, stack, simulate, slotConfig);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; i < sizeInventory; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            if ((slotConfig == null || i >= slotConfig.length || !slotConfig[i]) && WirelessIOBauble.canItemStacksStackRelaxed(slot, stack) && (stack = inventory.insertItem(i, stack, simulate)).m_41619_()) break;
        }
        if (!stack.m_41619_()) {
            for (i = 0; i < sizeInventory && (slotConfig != null && i < slotConfig.length && slotConfig[i] || !inventory.getStackInSlot(i).m_41619_() || !(stack = inventory.insertItem(i, stack, simulate)).m_41619_()); ++i) {
            }
        }
        return stack;
    }

    public static ItemStack insertItem(IItemHandler dest, @Nonnull ItemStack stack, boolean simulate, @Nullable boolean[] slotConfig) {
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < dest.getSlots(); ++i) {
            if (slotConfig != null && i < slotConfig.length && slotConfig[i] || !(stack = dest.insertItem(i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || b.m_41619_() || a.m_41720_() != b.m_41720_()) {
            return false;
        }
        if (!a.m_41753_()) {
            return false;
        }
        if (a.m_41782_() != b.m_41782_()) {
            return false;
        }
        return (!a.m_41782_() || Objects.equals(a.m_41783_(), Objects.requireNonNull(b.m_41783_()))) && a.areCapsCompatible((CapabilityProvider)b);
    }

    @Override
    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.f_19797_ % 100 == 0 && !maid.guiOpening) {
            BlockPos bindingPos = ItemWirelessIO.getBindingPos(baubleItem);
            if (bindingPos == null) {
                return;
            }
            float maxDistance = maid.m_21535_();
            if (maid.m_20275_(bindingPos.m_123341_(), bindingPos.m_123342_(), bindingPos.m_123343_()) > (double)(maxDistance * maxDistance)) {
                return;
            }
            BlockEntity te = maid.f_19853_.m_7702_(bindingPos);
            if (te == null) {
                return;
            }
            for (IChestType type : ChestManager.getAllChestTypes()) {
                if (!type.isChest(te)) continue;
                int openCount = type.getOpenCount((BlockGetter)maid.f_19853_, bindingPos, te);
                if (openCount > 0) {
                    return;
                }
                te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(chestInv -> {
                    CombinedInvWrapper maidInv = maid.getAvailableInv(false);
                    boolean isMaidToChest = ItemWirelessIO.isMaidToChest(baubleItem);
                    boolean isBlacklist = ItemWirelessIO.isBlacklist(baubleItem);
                    byte[] slotConfig = ItemWirelessIO.getSlotConfig(baubleItem);
                    byte[] slotConfigTmp = null;
                    if (slotConfig != null) {
                        slotConfigTmp = Arrays.copyOf(slotConfig, slotConfig.length);
                        slotConfigTmp[maidInv.getSlots() - 2] = slotConfigTmp[36];
                        slotConfigTmp[maidInv.getSlots() - 1] = slotConfigTmp[37];
                    }
                    boolean[] slotConfigData = BytesBooleansConvert.bytes2Booleans(slotConfigTmp, 38);
                    ItemStackHandler filterList = ItemWirelessIO.getFilterList(baubleItem);
                    if (isMaidToChest) {
                        this.maidToChest((IItemHandler)maidInv, (IItemHandler)chestInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                    } else {
                        this.chestToMaid((IItemHandler)chestInv, (IItemHandler)maidInv, isBlacklist, (IItemHandler)filterList, slotConfigData);
                    }
                });
                return;
            }
        }
    }

    private void maidToChest(IItemHandler maid, IItemHandler chest, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < maid.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            if (i < slotConfig.length && slotConfig[i]) continue;
            ItemStack maidInvItem = maid.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = maidInvItem.m_41726_(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = maidInvItem.m_41613_()) == (afterCount = (after = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)maidInvItem.m_41777_(), (boolean)false)).m_41613_())) continue;
            maid.extractItem(i, beforeCount - afterCount, false);
        }
    }

    private void chestToMaid(IItemHandler chest, IItemHandler maid, boolean isBlacklist, IItemHandler filterList, boolean[] slotConfig) {
        for (int i = 0; i < chest.getSlots(); ++i) {
            ItemStack after;
            int afterCount;
            int beforeCount;
            ItemStack chestInvStack = chest.getStackInSlot(i);
            boolean allowMove = isBlacklist;
            for (int j = 0; j < filterList.getSlots(); ++j) {
                ItemStack filterItem = filterList.getStackInSlot(j);
                boolean isEqual = chestInvStack.m_41726_(filterItem);
                if (!isEqual) continue;
                allowMove = !isBlacklist;
                break;
            }
            if (!allowMove || (beforeCount = chestInvStack.m_41613_()) == (afterCount = (after = WirelessIOBauble.insertItemStacked(maid, chestInvStack.m_41777_(), false, slotConfig)).m_41613_())) continue;
            chest.extractItem(i, beforeCount - afterCount, false);
        }
    }
}

