/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IChestType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.chest.ChestManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.WirelessIOContainer;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class ItemWirelessIO
extends Item
implements MenuProvider {
    private static final int FILTER_LIST_SIZE = 9;
    private static final String FILTER_LIST_TAG = "ItemFilterList";
    private static final String FILTER_MODE_TAG = "ItemFilterMode";
    private static final String IO_MODE_TAG = "ItemIOMode";
    private static final String BINDING_POS = "BindingPos";
    private static final String SLOT_CONFIG_TAG = "SlotConfigData";
    private static final String TOOLTIPS_PREFIX = "\u00a7a\u258d \u00a77";

    public ItemWirelessIO() {
        super(new Item.Properties().m_41491_(MaidGroup.MAIN_TAB).m_41487_(1));
    }

    public static void setMode(ItemStack stack, boolean maidToChest) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get()) {
            stack.m_41784_().m_128379_(IO_MODE_TAG, maidToChest);
        }
    }

    public static boolean isMaidToChest(ItemStack stack) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get() && stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            return Objects.requireNonNull(nbt).m_128471_(IO_MODE_TAG);
        }
        return false;
    }

    public static void setFilterMode(ItemStack stack, boolean isBlacklist) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get()) {
            stack.m_41784_().m_128379_(FILTER_MODE_TAG, isBlacklist);
        }
    }

    public static boolean isBlacklist(ItemStack stack) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get() && stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            return Objects.requireNonNull(nbt).m_128471_(FILTER_MODE_TAG);
        }
        return false;
    }

    public static ItemStackHandler getFilterList(ItemStack stack) {
        CompoundTag tag;
        WirelessIOHandler handler = new WirelessIOHandler(9);
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get() && (tag = stack.m_41783_()) != null && tag.m_128425_(FILTER_LIST_TAG, 10)) {
            handler.deserializeNBT(tag.m_128469_(FILTER_LIST_TAG));
        }
        return handler;
    }

    public static void setFilterList(ItemStack stack, ItemStackHandler itemStackHandler) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get()) {
            stack.m_41784_().m_128365_(FILTER_LIST_TAG, (Tag)itemStackHandler.serializeNBT());
        }
    }

    @Nullable
    public static BlockPos getBindingPos(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get() && (tag = stack.m_41783_()) != null && tag.m_128425_(BINDING_POS, 10)) {
            return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(BINDING_POS));
        }
        return null;
    }

    public static void setBindingPos(ItemStack stack, BlockPos pos) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get()) {
            stack.m_41784_().m_128365_(BINDING_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
    }

    public static void setSlotConfig(ItemStack stack, byte[] config) {
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get()) {
            stack.m_41784_().m_128365_(SLOT_CONFIG_TAG, (Tag)new ByteArrayTag(config));
        }
    }

    @Nullable
    public static byte[] getSlotConfig(ItemStack stack) {
        CompoundTag tag;
        if (stack.m_41720_() == InitItems.WIRELESS_IO.get() && (tag = stack.m_41783_()) != null && tag.m_128425_(SLOT_CONFIG_TAG, 7)) {
            return tag.m_128463_(SLOT_CONFIG_TAG);
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockEntity te = worldIn.m_7702_(pos);
        if (hand != InteractionHand.MAIN_HAND) {
            return super.m_6225_(context);
        }
        if (player == null) {
            return super.m_6225_(context);
        }
        for (IChestType type : ChestManager.getAllChestTypes()) {
            if (!type.isChest(te) || !type.canOpenByPlayer(te, player)) continue;
            ItemStack stack = player.m_21205_();
            ItemWirelessIO.setBindingPos(stack, pos);
            return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND && playerIn instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this, buffer -> buffer.m_130055_(playerIn.m_21205_()));
            return InteractionResultHolder.m_19090_((Object)playerIn.m_21205_());
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        boolean maidToChest = ItemWirelessIO.isMaidToChest(stack);
        boolean isBlacklist = ItemWirelessIO.isBlacklist(stack);
        BlockPos pos = ItemWirelessIO.getBindingPos(stack);
        String ioModeText = maidToChest ? I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.io_mode.input", (Object[])new Object[0]) : I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.io_mode.output", (Object[])new Object[0]);
        String filterModeText = isBlacklist ? I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.blacklist", (Object[])new Object[0]) : I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.filter_mode.whitelist", (Object[])new Object[0]);
        String hasPos = pos != null ? I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.has", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}) : I18n.m_118938_((String)"tooltips.touhou_little_maid.wireless_io.binding_pos.none", (Object[])new Object[0]);
        tooltip.add((Component)Component.m_237113_((String)(TOOLTIPS_PREFIX + ioModeText)));
        tooltip.add((Component)Component.m_237113_((String)(TOOLTIPS_PREFIX + filterModeText)));
        tooltip.add((Component)Component.m_237113_((String)(TOOLTIPS_PREFIX + hasPos)));
        tooltip.add((Component)Component.m_237113_((String)" "));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.wireless_io.usage.1").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.wireless_io.usage.2").m_130940_(ChatFormatting.GRAY));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"item.touhou_little_maid.wireless_io");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new WirelessIOContainer(id, inventory, player.m_21205_());
    }

    private static class WirelessIOHandler
    extends ItemStackHandler {
        private WirelessIOHandler(int size) {
            super(size);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

