/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.block.BlockStatue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemPhoto;
import com.github.tartaricacid.touhoulittlemaid.item.MaidGroup;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemChisel
extends Item {
    public ItemChisel() {
        super(new Item.Properties().m_41491_(MaidGroup.MAIN_TAB).m_41487_(1).m_41503_(64));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level worldIn = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (context.m_43724_() == InteractionHand.MAIN_HAND && player != null) {
            if (worldIn.m_8055_(pos).m_60734_() != Blocks.f_50129_) {
                if (!worldIn.f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.chisel.hit_block_error"));
                }
                return InteractionResult.PASS;
            }
            if (player.m_21206_().m_41720_() != InitItems.PHOTO.get()) {
                if (!worldIn.f_46443_) {
                    player.m_213846_((Component)Component.m_237115_((String)"message.touhou_little_maid.chisel.offhand_not_photo"));
                }
                return InteractionResult.PASS;
            }
            this.genStatueBlocks(player, worldIn, pos, context.m_43719_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    private void genStatueBlocks(@Nonnull Player player, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Direction facing) {
        CompoundTag data = ItemPhoto.getMaidData(player.m_21206_());
        TileEntityStatue.Size[] sizes = TileEntityStatue.Size.values();
        for (int i = sizes.length - 1; i >= 0; --i) {
            TileEntityStatue.Size size = sizes[i];
            Vec3i dimension = size.getDimension();
            Object[] posList = this.checkBlocks(worldIn, pos, dimension, facing);
            if (posList == null) continue;
            boolean isTiny = false;
            if (posList.length == 1) {
                isTiny = true;
            }
            for (BlockPos blockPos : posList) {
                worldIn.m_7731_(blockPos, (BlockState)((Block)InitBlocks.STATUE.get()).m_49966_().m_61124_((Property)BlockStatue.IS_TINY, (Comparable)Boolean.valueOf(isTiny)), 3);
                BlockEntity te = worldIn.m_7702_(blockPos);
                if (!(te instanceof TileEntityStatue)) continue;
                TileEntityStatue statue = (TileEntityStatue)te;
                if (blockPos.equals((Object)pos)) {
                    statue.setForgeData(size, true, pos, facing, Lists.newArrayList((Object[])posList), data);
                    continue;
                }
                statue.setForgeData(size, false, pos, facing, Lists.newArrayList((Object[])posList), null);
            }
            player.m_21205_().m_41622_(size.ordinal() + 1, (LivingEntity)player, e -> e.m_21190_(InteractionHand.MAIN_HAND));
            player.m_5496_(SoundEvents.f_11668_, 0.5f, 1.5f);
            return;
        }
    }

    @Nullable
    private BlockPos[] checkBlocks(@Nonnull Level worldIn, BlockPos origin, Vec3i dimension, Direction facing) {
        BlockPos[] posList = new BlockPos[dimension.m_123341_() * dimension.m_123342_() * dimension.m_123343_()];
        int index = 0;
        for (int x = 0; x < dimension.m_123341_(); ++x) {
            for (int y = 0; y < dimension.m_123342_(); ++y) {
                for (int z = 0; z < dimension.m_123343_(); ++z) {
                    BlockPos pos = switch (facing) {
                        case Direction.WEST -> origin.m_121955_(new Vec3i(x, y, z));
                        case Direction.SOUTH -> origin.m_121955_(new Vec3i(x, y, -z));
                        default -> origin.m_121955_(new Vec3i(-x, y, z));
                        case Direction.EAST -> origin.m_121955_(new Vec3i(-x, y, -z));
                    };
                    posList[index] = pos;
                    ++index;
                    if (worldIn.m_8055_(pos).m_60734_() == Blocks.f_50129_) continue;
                    return null;
                }
            }
        }
        return posList;
    }
}

