/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.util;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoCube;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;

public final class RenderUtils {
    public static void translateMatrixToBone(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(-bone.getPositionX() / 16.0f), (double)(bone.getPositionY() / 16.0f), (double)(bone.getPositionZ() / 16.0f));
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, GeoBone bone) {
        if (bone.getRotationZ() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(bone.getRotationZ()));
        }
        if (bone.getRotationY() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(bone.getRotationY()));
        }
        if (bone.getRotationX() != 0.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(bone.getRotationX()));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vector3f rotation = cube.rotation;
        poseStack.m_85845_(new Quaternion(0.0f, 0.0f, rotation.m_122269_(), false));
        poseStack.m_85845_(new Quaternion(0.0f, rotation.m_122260_(), 0.0f, false));
        poseStack.m_85845_(new Quaternion(rotation.m_122239_(), 0.0f, 0.0f, false));
    }

    public static void scaleMatrixForBone(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85841_(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vector3f pivot = cube.pivot;
        poseStack.m_85837_((double)(pivot.m_122239_() / 16.0f), (double)(pivot.m_122260_() / 16.0f), (double)(pivot.m_122269_() / 16.0f));
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(bone.rotationPointX / 16.0f), (double)(bone.rotationPointY / 16.0f), (double)(bone.rotationPointZ / 16.0f));
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vector3f pivot = cube.pivot;
        poseStack.m_85837_((double)(-pivot.m_122239_() / 16.0f), (double)(-pivot.m_122260_() / 16.0f), (double)(-pivot.m_122269_() / 16.0f));
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoBone bone) {
        poseStack.m_85837_((double)(-bone.rotationPointX / 16.0f), (double)(-bone.rotationPointY / 16.0f), (double)(-bone.rotationPointZ / 16.0f));
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, GeoBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = inputMatrix.m_27658_();
        inputMatrix.m_27657_();
        inputMatrix.m_27644_(baseMatrix);
        return inputMatrix;
    }
}

