/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.easing;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.easing.EasingFunctionArgs;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.easing.EasingType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Memoizer;
import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.List;
import java.util.function.Function;

public class EasingManager {
    private static final Function<EasingFunctionArgs, Double2DoubleFunction> GET_EASING_FUNCTION = Memoizer.memoize(EasingManager::getEasingFuncImpl);

    public static double ease(double number, EasingType easingType, List<Double> easingArgs) {
        Double firstArg = easingArgs == null || easingArgs.size() < 1 ? null : easingArgs.get(0);
        return (Double)GET_EASING_FUNCTION.apply(new EasingFunctionArgs(easingType, firstArg)).apply((Object)number);
    }

    private static Double2DoubleFunction getEasingFuncImpl(EasingFunctionArgs args) {
        return switch (args.easingType()) {
            default -> EasingManager.in(EasingManager::linear);
            case EasingType.STEP -> EasingManager.in(EasingManager.step(args.arg0()));
        };
    }

    private static Double2DoubleFunction in(Double2DoubleFunction easing) {
        return easing;
    }

    private static double linear(double t) {
        return t;
    }

    private static Double2DoubleFunction step(Double stepArg) {
        int steps = stepArg != null ? stepArg.intValue() : 2;
        double[] intervals = EasingManager.stepRange(steps);
        return t -> intervals[EasingManager.findIntervalBorderIndex(t, intervals, false)];
    }

    private static int findIntervalBorderIndex(double point, double[] intervals, boolean useRightBorder) {
        if (point < intervals[0]) {
            return 0;
        }
        if (point > intervals[intervals.length - 1]) {
            return intervals.length - 1;
        }
        int indexOfNumberToCompare = 0;
        int leftBorderIndex = 0;
        int rightBorderIndex = intervals.length - 1;
        while (rightBorderIndex - leftBorderIndex != 1) {
            indexOfNumberToCompare = leftBorderIndex + (rightBorderIndex - leftBorderIndex) / 2;
            if (point >= intervals[indexOfNumberToCompare]) {
                leftBorderIndex = indexOfNumberToCompare;
                continue;
            }
            rightBorderIndex = indexOfNumberToCompare;
        }
        return useRightBorder ? rightBorderIndex : leftBorderIndex;
    }

    private static double[] stepRange(int steps) {
        double stop = 1.0;
        if (steps < 2) {
            throw new IllegalArgumentException("steps must be > 2, got:" + steps);
        }
        double stepLength = 1.0 / (double)steps;
        double[] stepArray = new double[steps];
        for (int i = 0; i < steps; ++i) {
            stepArray[i] = (double)i * stepLength;
        }
        return stepArray;
    }
}

