/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public final class EntityHurtEvent {
    @SubscribeEvent
    public static void onArrowImpact(ProjectileImpactEvent event) {
        Entity attacker = event.getProjectile().m_37282_();
        HitResult ray = event.getRayTraceResult();
        if (attacker instanceof TamableAnimal && ray instanceof EntityHitResult) {
            ResourceLocation registryName;
            TamableAnimal tameable;
            TamableAnimal thrower = (TamableAnimal)attacker;
            Entity victim = ((EntityHitResult)ray).m_82443_();
            if (victim instanceof TamableAnimal && (tameable = (TamableAnimal)victim).m_21805_() != null && tameable.m_21805_().equals(thrower.m_21805_())) {
                event.setCanceled(true);
            }
            if (victim instanceof LivingEntity && thrower.m_21830_((LivingEntity)victim)) {
                event.setCanceled(true);
            }
            if ((registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)victim.m_6095_())) != null && ((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                event.setCanceled(true);
            }
        }
    }
}

