/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class TaskSugarCane
implements IFarmTask {
    private static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "sugar_cane");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.f_41909_.m_7968_();
    }

    @Override
    public boolean isSeed(ItemStack stack) {
        return stack.m_41720_() == Items.f_41909_;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        BlockState blockDownState = maid.f_19853_.m_8055_(cropPos.m_7495_());
        BlockState blockDown2State = maid.f_19853_.m_8055_(cropPos.m_6625_(2));
        return cropState.m_60713_(Blocks.f_50130_) && blockDownState.m_60713_(Blocks.f_50130_) && this.canSustainSugarCane(blockDown2State);
    }

    @Override
    public void harvest(EntityMaid maid, BlockPos cropPos, BlockState cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        Level world = maid.f_19853_;
        BlockPos cropPos = basePos.m_7494_();
        if (!world.m_8055_(cropPos).m_60767_().m_76336_() || world.m_8055_(cropPos).m_60767_().m_76332_()) {
            return false;
        }
        return this.canSustainSugarCane(baseState) && this.hasWaterSourceBlock(maid.f_19853_, basePos);
    }

    @Override
    public ItemStack plant(EntityMaid maid, BlockPos basePos, BlockState baseState, ItemStack seed) {
        if (seed.m_41720_() == Items.f_41909_) {
            maid.placeItemBlock(basePos.m_7494_(), seed);
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.0;
    }

    private boolean canSustainSugarCane(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_);
    }

    private boolean hasWaterSourceBlock(Level world, BlockPos basePos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState offsetState = world.m_8055_(basePos.m_121945_(direction));
            FluidState fluidState = world.m_6425_(basePos.m_121945_(direction));
            if (!fluidState.m_205070_(FluidTags.f_13131_) && !offsetState.m_60713_(Blocks.f_50449_)) continue;
            return true;
        }
        return false;
    }
}

