/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAttackEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDeathEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidHurtEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidPlaySoundEvent;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidTickEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.capability.MaidNumCapabilityProvider;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockPart;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.domesticationinnovation.PetBedDrop;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidBrain;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BigBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.EmptyBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.MiddleBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.SmallBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidChatBubbles;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.MaidScriptBookManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.DefaultMaidSoundPack;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskIdle;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidBackpackHandler;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.MaidHandsInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.mixin.MixinArrowEntity;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.ItemBreakMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.PlayMaidSoundMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.TeleportHelper;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.ObjectUtils;

public class EntityMaid
extends TamableAnimal
implements CrossbowAttackMob,
IMaid {
    public static final EntityType<EntityMaid> TYPE = EntityType.Builder.m_20704_(EntityMaid::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.5f).m_20702_(10).m_20712_("maid");
    public static final String MODEL_ID_TAG = "ModelId";
    public static final String SOUND_PACK_ID_TAG = "SoundPackId";
    public static final String MAID_BACKPACK_TYPE = "MaidBackpackType";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    public static final String MAID_BAUBLE_INVENTORY_TAG = "MaidBaubleInventory";
    public static final String EXPERIENCE_TAG = "MaidExperience";
    private static final EntityDataAccessor<String> DATA_MODEL_ID = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DATA_TASK = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Boolean> DATA_BEGGING = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_PICKUP = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HOME_MODE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_RIDEABLE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_INVULNERABLE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_HUNGER = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_FAVORABILITY = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_EXPERIENCE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_STRUCK_BY_LIGHTNING = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ARM_RISE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<MaidSchedule> SCHEDULE_MODE = SynchedEntityData.m_135353_(EntityMaid.class, MaidSchedule.DATA);
    private static final EntityDataAccessor<BlockPos> RESTRICT_CENTER = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Float> RESTRICT_RADIUS = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<MaidChatBubbles> CHAT_BUBBLE = SynchedEntityData.m_135353_(EntityMaid.class, MaidChatBubbles.DATA);
    private static final EntityDataAccessor<String> BACKPACK_TYPE = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<ItemStack> BACKPACK_ITEM_SHOW = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<String> BACKPACK_FLUID = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<CompoundTag> GAME_SKILL = SynchedEntityData.m_135353_(EntityMaid.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final String TASK_TAG = "MaidTask";
    private static final String PICKUP_TAG = "MaidIsPickup";
    private static final String HOME_TAG = "MaidIsHome";
    private static final String RIDEABLE_TAG = "MaidIsRideable";
    private static final String STRUCK_BY_LIGHTNING_TAG = "StruckByLightning";
    private static final String INVULNERABLE_TAG = "Invulnerable";
    private static final String HUNGER_TAG = "MaidHunger";
    private static final String FAVORABILITY_TAG = "MaidFavorability";
    private static final String SCHEDULE_MODE_TAG = "MaidScheduleMode";
    private static final String BACKPACK_DATA_TAG = "MaidBackpackData";
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    @Deprecated
    private static final String BACKPACK_LEVEL_TAG = "MaidBackpackLevel";
    @Deprecated
    private static final String RESTRICT_CENTER_TAG = "MaidRestrictCenter";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private final EntityArmorInvWrapper armorInvWrapper = new EntityArmorInvWrapper((LivingEntity)this);
    private final EntityHandsInvWrapper handsInvWrapper = new MaidHandsInvWrapper((LivingEntity)this);
    private final ItemStackHandler maidInv = new MaidBackpackHandler(36, this);
    private final BaubleItemHandler maidBauble = new BaubleItemHandler(9);
    private final FavorabilityManager favorabilityManager;
    private final MaidScriptBookManager scriptBookManager;
    private final SchedulePos schedulePos;
    public final ItemStack[] handItemsForAnimation = new ItemStack[]{ItemStack.f_41583_, ItemStack.f_41583_};
    public boolean guiOpening = false;
    private List<SendEffectMessage.EffectData> effects = Lists.newArrayList();
    private IMaidTask task = TaskManager.getIdleTask();
    private IMaidBackpack backpack = BackpackManager.getEmptyBackpack();
    private int playerHurtSoundCount = 120;
    private int pickupSoundCount = 5;
    private int backpackDelay = 0;
    private IBackpackData backpackData = null;

    protected EntityMaid(EntityType<EntityMaid> type, Level world) {
        super(type, world);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.favorabilityManager = new FavorabilityManager(this);
        this.scriptBookManager = new MaidScriptBookManager();
        this.schedulePos = new SchedulePos(BlockPos.f_121853_, world.m_46472_().m_135782_());
    }

    public EntityMaid(Level worldIn) {
        this(TYPE, worldIn);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 64.0).m_22266_(Attributes.f_22282_).m_22266_(Attributes.f_22281_);
    }

    public static boolean canInsertItem(ItemStack stack) {
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key != null && ((List)MaidConfig.MAID_BACKPACK_BLACKLIST.get()).contains(key.toString())) {
            return false;
        }
        return stack.m_41720_().m_142095_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MODEL_ID, (Object)DEFAULT_MODEL_ID);
        this.f_19804_.m_135372_(DATA_SOUND_PACK_ID, (Object)DefaultMaidSoundPack.getInitSoundPackId());
        this.f_19804_.m_135372_(DATA_TASK, (Object)TaskIdle.UID.toString());
        this.f_19804_.m_135372_(DATA_BEGGING, (Object)false);
        this.f_19804_.m_135372_(DATA_PICKUP, (Object)true);
        this.f_19804_.m_135372_(DATA_HOME_MODE, (Object)false);
        this.f_19804_.m_135372_(DATA_RIDEABLE, (Object)true);
        this.f_19804_.m_135372_(DATA_INVULNERABLE, (Object)false);
        this.f_19804_.m_135372_(DATA_HUNGER, (Object)0);
        this.f_19804_.m_135372_(DATA_FAVORABILITY, (Object)0);
        this.f_19804_.m_135372_(DATA_EXPERIENCE, (Object)0);
        this.f_19804_.m_135372_(DATA_STRUCK_BY_LIGHTNING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.f_19804_.m_135372_(DATA_ARM_RISE, (Object)false);
        this.f_19804_.m_135372_(SCHEDULE_MODE, (Object)MaidSchedule.DAY);
        this.f_19804_.m_135372_(RESTRICT_CENTER, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(RESTRICT_RADIUS, (Object)Float.valueOf(((Integer)MaidConfig.MAID_NON_HOME_RANGE.get()).floatValue()));
        this.f_19804_.m_135372_(CHAT_BUBBLE, (Object)MaidChatBubbles.DEFAULT);
        this.f_19804_.m_135372_(BACKPACK_TYPE, (Object)EmptyBackpack.ID.toString());
        this.f_19804_.m_135372_(BACKPACK_ITEM_SHOW, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(BACKPACK_FLUID, (Object)"");
        this.f_19804_.m_135372_(GAME_SKILL, (Object)new CompoundTag());
    }

    public Brain<EntityMaid> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<EntityMaid> m_5490_() {
        return Brain.m_21923_(MaidBrain.getMemoryTypes(), MaidBrain.getSensorTypes());
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamicIn) {
        Brain brain = this.m_5490_().m_22073_(dynamicIn);
        MaidBrain.registerBrainGoals((Brain<EntityMaid>)brain, this);
        return brain;
    }

    public void refreshBrain(ServerLevel serverWorldIn) {
        Brain<EntityMaid> brain = this.m_6274_();
        brain.m_21933_(serverWorldIn, (LivingEntity)this);
        this.f_20939_ = brain.m_21973_();
        MaidBrain.registerBrainGoals(this.m_6274_(), this);
    }

    protected void m_8024_() {
        this.f_19853_.m_46473_().m_6180_("maidBrain");
        if (!this.guiOpening) {
            this.m_6274_().m_21865_((ServerLevel)this.f_19853_, (LivingEntity)this);
        }
        this.f_19853_.m_46473_().m_7238_();
        super.m_8024_();
    }

    public void m_8119_() {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MaidTickEvent(this))) {
            super.m_8119_();
            this.maidBauble.fireEvent((b, s) -> {
                b.onTick(this, (ItemStack)s);
                return false;
            });
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.m_20202_() != null) {
            Entity vehicle = this.m_20202_();
            this.m_5616_(vehicle.m_146908_());
            this.m_5618_(vehicle.m_146908_());
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.backpackDelay > 0) {
            --this.backpackDelay;
        }
        if (this.playerHurtSoundCount > 0) {
            --this.playerHurtSoundCount;
        }
        this.spawnPortalParticle();
        this.randomRestoreHealth();
        this.onMaidSleep();
    }

    private void onMaidSleep() {
        if (this.m_5803_()) {
            this.m_21257_().ifPresent(pos -> this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5));
            this.m_20256_(Vec3.f_82478_);
            if (!this.m_20067_()) {
                this.m_20225_(true);
            }
        } else if (this.m_20067_()) {
            this.m_20225_(false);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (!this.f_19853_.f_46443_) {
            ChatBubbleManger.tick(this);
            if (this.backpackData != null) {
                this.f_19853_.m_46473_().m_6180_("maidBackpackData");
                this.backpackData.serverTick(this);
                this.f_19853_.m_46473_().m_7238_();
            }
            this.f_19853_.m_46473_().m_6180_("maidFavorability");
            this.favorabilityManager.tick();
            this.f_19853_.m_46473_().m_7238_();
            this.f_19853_.m_46473_().m_6180_("maidSchedulePos");
            this.schedulePos.tick(this);
            this.f_19853_.m_46473_().m_7238_();
        }
    }

    public InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND && this.m_21830_((LivingEntity)playerIn)) {
            ItemStack stack = playerIn.m_21205_();
            InteractMaidEvent event = new InteractMaidEvent(playerIn, this, stack);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || stack.m_41647_(playerIn, (LivingEntity)this, hand).m_19077_() || this.openMaidGui(playerIn)) {
                return InteractionResult.SUCCESS;
            }
        } else {
            return this.tameMaid(playerIn.m_21120_(hand), playerIn);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult tameMaid(ItemStack stack, Player player) {
        return player.getCapability(MaidNumCapabilityProvider.MAID_NUM_CAP).map(cap -> {
            if (cap.canAdd() || player.m_7500_()) {
                boolean isNormal = !this.m_21824_() && this.getTamedItem().test(stack);
                boolean isNtr = EntityMaid.getNtrItem().test(stack);
                if (isNormal || isNtr) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        cap.add();
                    }
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.f_20939_.m_21936_(MemoryModuleType.f_26372_);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                    this.m_5496_((SoundEvent)InitSounds.MAID_TAMED.get(), 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (player instanceof ServerPlayer) {
                MutableComponent msg = Component.m_237110_((String)"message.touhou_little_maid.owner_maid_num.can_not_add", (Object[])new Object[]{cap.get(), cap.getMaxNum()});
                player.m_213846_((Component)msg);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    protected void m_6138_() {
        List entityList;
        super.m_6138_();
        if (this.isPickup() && this.m_21824_() && !(entityList = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_(0.5, 0.0, 0.5), this::canPickup)).isEmpty() && this.m_6084_()) {
            for (Entity entityPickup : entityList) {
                if (entityPickup instanceof ItemEntity) {
                    this.pickupItem((ItemEntity)entityPickup, false);
                }
                if (entityPickup instanceof ExperienceOrb) {
                    this.pickupXPOrb((ExperienceOrb)entityPickup);
                }
                if (entityPickup instanceof EntityPowerPoint) {
                    this.pickupPowerPoint((EntityPowerPoint)entityPickup);
                }
                if (!(entityPickup instanceof AbstractArrow)) continue;
                this.pickupArrow((AbstractArrow)entityPickup, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.f_19853_.f_46443_ && entityItem.m_6084_() && !entityItem.m_32063_()) {
            ItemStack itemstack = entityItem.m_32055_();
            if (!EntityMaid.canInsertItem(itemstack)) {
                return false;
            }
            int count = itemstack.m_41613_();
            if (count == (itemstack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)itemstack, (boolean)simulate)).m_41613_()) {
                return false;
            }
            if (!simulate) {
                this.m_7938_((Entity)entityItem, count - itemstack.m_41613_());
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.m_5496_((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                if (itemstack.m_41619_()) {
                    entityItem.m_146870_();
                } else {
                    entityItem.m_32045_(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public void pickupXPOrb(ExperienceOrb entityXPOrb) {
        if (!this.f_19853_.f_46443_ && entityXPOrb.m_6084_() && entityXPOrb.f_19797_ > 2) {
            ItemStack itemstack;
            Map.Entry entry;
            this.m_7938_((Entity)entityXPOrb, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.m_5496_((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            if ((entry = EnchantmentHelper.m_44839_((Enchantment)Enchantments.f_44962_, (LivingEntity)this, ItemStack::m_41768_)) != null && !(itemstack = (ItemStack)entry.getValue()).m_41619_() && itemstack.m_41768_()) {
                int i = Math.min((int)((float)entityXPOrb.f_20770_ * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                entityXPOrb.f_20770_ -= i / 2;
                itemstack.m_41721_(itemstack.m_41773_() - i);
            }
            if (entityXPOrb.f_20770_ > 0) {
                this.setExperience(this.getExperience() + entityXPOrb.f_20770_);
            }
            entityXPOrb.m_146870_();
        }
    }

    public void pickupPowerPoint(EntityPowerPoint powerPoint) {
        if (!this.f_19853_.f_46443_ && powerPoint.m_6084_() && powerPoint.throwTime == 0) {
            powerPoint.take((Entity)this, 1);
            if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.m_5496_((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
            }
            ItemStack itemstack = this.getRandomItemWithMendingEnchantments();
            int xpValue = EntityPowerPoint.transPowerValueToXpValue(powerPoint.getValue());
            if (!itemstack.m_41619_() && !itemstack.m_41619_() && itemstack.m_41768_()) {
                int i = Math.min((int)((float)xpValue * itemstack.getXpRepairRatio()), itemstack.m_41773_());
                xpValue -= i / 2;
                itemstack.m_41721_(itemstack.m_41773_() - i);
            }
            if (xpValue > 0) {
                this.setExperience(this.getExperience() + xpValue);
            }
            powerPoint.m_146870_();
        }
    }

    private ItemStack getRandomItemWithMendingEnchantments() {
        ArrayList stacks = Lists.newArrayList();
        this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack itemstack = cap.getStackInSlot(i);
                if (itemstack.m_41619_() || itemstack.getEnchantmentLevel(Enchantments.f_44962_) <= 0 || !itemstack.m_41768_()) continue;
                stacks.add(itemstack);
            }
        });
        return stacks.isEmpty() ? ItemStack.f_41583_ : (ItemStack)stacks.get(this.m_217043_().m_188503_(stacks.size()));
    }

    public boolean pickupArrow(AbstractArrow arrow, boolean simulate) {
        if (!this.f_19853_.f_46443_ && arrow.m_6084_() && arrow.f_36706_ <= 0) {
            if (arrow.f_36705_ != AbstractArrow.Pickup.ALLOWED) {
                return false;
            }
            ItemStack stack = this.getArrowFromEntity(arrow);
            if (stack.m_41619_()) {
                return false;
            }
            if (!ItemHandlerHelper.insertItemStacked((IItemHandler)this.getAvailableInv(false), (ItemStack)stack, (boolean)simulate).m_41619_()) {
                return false;
            }
            if (!simulate) {
                this.m_7938_((Entity)arrow, 1);
                if (!MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
                    --this.pickupSoundCount;
                    if (this.pickupSoundCount == 0) {
                        this.m_5496_((SoundEvent)InitSounds.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                        this.pickupSoundCount = 5;
                    }
                }
                arrow.m_146870_();
            }
            return true;
        }
        return false;
    }

    private ItemStack getArrowFromEntity(AbstractArrow entity) {
        MixinArrowEntity mixinArrow;
        if (entity instanceof MixinArrowEntity && ((mixinArrow = (MixinArrowEntity)entity).tlmInGround() || entity.m_36797_())) {
            return mixinArrow.getTlmPickupItem();
        }
        return ItemStack.f_41583_;
    }

    public double m_142593_(LivingEntity entity) {
        int attackDistance = this.favorabilityManager.getAttackDistanceByPoint(this.getFavorability());
        return attackDistance * attackDistance;
    }

    public boolean m_7327_(Entity target) {
        IAttackTask attackTask;
        boolean result = super.m_7327_(target);
        if (result) {
            this.doSweepHurt(target);
        }
        this.m_21205_().m_41622_(1, (LivingEntity)this, maid -> maid.m_21190_(InteractionHand.MAIN_HAND));
        IMaidTask iMaidTask = this.getTask();
        if (iMaidTask instanceof IAttackTask && (attackTask = (IAttackTask)iMaidTask).hasExtraAttack(this, target)) {
            boolean extraResult = attackTask.doExtraAttack(this, target);
            return result && extraResult;
        }
        return result;
    }

    private void doSweepHurt(Entity target) {
        ItemStack mainhandItem = this.m_21120_(InteractionHand.MAIN_HAND);
        boolean canSweep = mainhandItem.canPerformAction(ToolActions.SWORD_SWEEP);
        float sweepingDamageRatio = EnchantmentHelper.m_44821_((LivingEntity)this);
        if (canSweep && sweepingDamageRatio > 0.0f) {
            float baseDamage = (float)this.m_21133_(Attributes.f_22281_);
            float sweepDamage = 1.0f + sweepingDamageRatio * baseDamage;
            AABB sweepRange = this.getFavorabilityManager().getSweepRange(target, this.getFavorability());
            List hurtEntities = this.f_19853_.m_45976_(LivingEntity.class, sweepRange);
            for (LivingEntity entity : hurtEntities) {
                if (entity == this || entity == target || this.m_7307_((Entity)entity) || !this.m_6779_(entity) || !this.m_6549_(entity.m_6095_())) continue;
                float posX = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float posY = -Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                entity.m_147240_(0.4, (double)posX, (double)posY);
                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), sweepDamage);
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, this.m_5720_(), 1.0f, 1.0f);
            this.spawnSweepAttackParticle();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidAttackEvent(this, source, amount))) {
            return false;
        }
        if (source.m_7639_() instanceof Player && this.m_21830_((LivingEntity)((Player)source.m_7639_()))) {
            amount = Mth.m_14036_((float)(amount / 5.0f), (float)0.0f, (float)2.0f);
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        if (!this.m_6673_(damageSrc)) {
            MaidHurtEvent maidHurtEvent = new MaidHurtEvent(this, damageSrc, damageAmount);
            damageAmount = MinecraftForge.EVENT_BUS.post((Event)maidHurtEvent) ? 0.0f : maidHurtEvent.getAmount();
            if ((damageAmount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)damageSrc, (float)damageAmount)) > 0.0f) {
                MaidDamageEvent maidDamageEvent;
                damageAmount = this.m_21161_(damageSrc, damageAmount);
                damageAmount = this.m_6515_(damageSrc, damageAmount);
                float damageAfterAbsorption = Math.max(damageAmount - this.m_6103_(), 0.0f);
                this.m_7911_(this.m_6103_() - (damageAmount - damageAfterAbsorption));
                float damageDealtAbsorbed = damageAmount - damageAfterAbsorption;
                if (0.0f < damageDealtAbsorbed && damageDealtAbsorbed < 3.4028235E37f && damageSrc.m_7639_() instanceof ServerPlayer) {
                    ((ServerPlayer)damageSrc.m_7639_()).m_36222_(Stats.f_12929_, Math.round(damageDealtAbsorbed * 10.0f));
                }
                damageAfterAbsorption = MinecraftForge.EVENT_BUS.post((Event)(maidDamageEvent = new MaidDamageEvent(this, damageSrc, damageAfterAbsorption))) ? 0.0f : maidDamageEvent.getAmount();
                if ((damageAfterAbsorption = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)damageSrc, (float)damageAfterAbsorption)) != 0.0f) {
                    float health = this.m_21223_();
                    this.m_21231_().m_19289_(damageSrc, health, damageAfterAbsorption);
                    this.m_21153_(health - damageAfterAbsorption);
                    this.m_7911_(this.m_6103_() - damageAfterAbsorption);
                }
            }
        }
    }

    @Nullable
    public Entity changeDimension(ServerLevel serverLevel, ITeleporter teleporter) {
        if (this.f_19853_ instanceof ServerLevel && !this.m_213877_()) {
            int MAX_RETRY = 16;
            for (int i = 0; i < 16; ++i) {
                if (!TeleportHelper.teleport(this)) continue;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 1, true, false));
            }
        }
        return null;
    }

    public void onAddedToWorld() {
        MaidWorldData data;
        super.onAddedToWorld();
        if (this.m_21805_() != null && (data = MaidWorldData.get(this.f_19853_)) != null) {
            data.removeInfo(this);
        }
    }

    public void onRemovedFromWorld() {
        MaidWorldData data;
        super.onRemovedFromWorld();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_21805_() != null && (data = MaidWorldData.get(this.f_19853_)) != null) {
            data.addInfo(this);
        }
    }

    public void m_6667_(DamageSource cause) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MaidDeathEvent(this, cause))) {
            super.m_6667_(cause);
        }
    }

    public boolean canPickup(Entity pickupEntity, boolean checkInWater) {
        if (this.isPickup()) {
            if (checkInWater && pickupEntity.m_20069_()) {
                return false;
            }
            if (pickupEntity instanceof ItemEntity) {
                return this.pickupItem((ItemEntity)pickupEntity, true);
            }
            if (pickupEntity instanceof AbstractArrow) {
                return this.pickupArrow((AbstractArrow)pickupEntity, true);
            }
            if (pickupEntity instanceof ExperienceOrb) {
                return true;
            }
            return pickupEntity instanceof EntityPowerPoint;
        }
        return false;
    }

    public boolean canPickup(Entity pickupEntity) {
        return this.canPickup(pickupEntity, false);
    }

    public void m_6136_(boolean isCharging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING_CROSSBOW, (Object)isCharging);
    }

    public void m_5811_(LivingEntity target, ItemStack crossbow, Projectile projectileEntity, float projectileAngle) {
        if (projectileEntity instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectileEntity;
            AttributeInstance attackDamage = this.m_21051_(Attributes.f_22281_);
            double attackValue = 2.0;
            if (attackDamage != null) {
                attackValue = attackDamage.m_22115_();
            }
            float multiplier = (float)(attackValue / 2.0);
            arrow.m_36781_(arrow.m_36789_() * (double)multiplier);
        }
        this.m_32322_((LivingEntity)this, target, projectileEntity, projectileAngle, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public ItemStack m_6298_(ItemStack weaponStack) {
        if (this.m_21206_().m_41720_() instanceof FireworkRocketItem) {
            return this.m_21206_();
        }
        CombinedInvWrapper handler = this.getAvailableInv(true);
        int slot = ItemsUtil.findStackSlot((IItemHandler)handler, ((CrossbowItem)this.m_21205_().m_41720_()).m_6437_());
        if (slot < 0) {
            return ItemStack.f_41583_;
        }
        return handler.getStackInSlot(slot);
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
        super.m_8038_(world, lightning);
        if (!this.isStruckByLightning()) {
            double beforeMaxHealth = this.m_21172_(Attributes.f_22276_);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(beforeMaxHealth + 20.0);
            this.setStruckByLightning(true);
        }
    }

    protected void m_6472_(DamageSource damageSource, float damage) {
        if (damage <= 0.0f) {
            return;
        }
        if ((damage /= 4.0f) < 1.0f) {
            damage = 1.0f;
        }
        for (int i = 0; i < this.armorInvWrapper.getSlots(); ++i) {
            boolean fireResistant;
            ItemStack stack = this.armorInvWrapper.getStackInSlot(i);
            boolean bl = fireResistant = damageSource.m_19384_() && stack.m_41720_().m_41475_();
            if (fireResistant || !(stack.m_41720_() instanceof ArmorItem)) continue;
            int index = i;
            stack.m_41622_((int)damage, (LivingEntity)this, maid -> maid.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index)));
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        IMaidTask maidTask = this.getTask();
        if (maidTask instanceof IRangedAttackTask) {
            ((IRangedAttackTask)maidTask).performRangedAttack(this, target, distanceFactor);
        }
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return typeIn != EntityType.f_20529_ && super.m_6549_(typeIn);
    }

    public boolean m_6779_(LivingEntity target) {
        IMaidTask iMaidTask = this.getTask();
        if (iMaidTask instanceof IAttackTask) {
            IAttackTask attackTask = (IAttackTask)iMaidTask;
            return attackTask.canAttack(this, target);
        }
        return super.m_6779_(target);
    }

    public void sendItemBreakMessage(ItemStack stack) {
        if (!this.f_19853_.f_46443_) {
            NetworkHandler.sendToNearby((Entity)this, new ItemBreakMessage(this.m_19879_(), stack));
        }
    }

    private void randomRestoreHealth() {
        if (this.m_21223_() < this.m_21233_() && (double)this.f_19796_.m_188501_() < 0.0025) {
            this.m_5634_(1.0f);
            this.spawnRestoreHealthParticle(this.f_19796_.m_188503_(3) + 7);
        }
    }

    private void spawnPortalParticle() {
        if (this.f_19853_.f_46443_ && this.getIsInvulnerable() && this.m_21826_() != null) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_() - 0.25, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
        }
    }

    public void spawnRestoreHealthParticle(int particleCount) {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < particleCount; ++i) {
                double xRandom = this.f_19796_.m_188583_() * 0.02;
                double yRandom = this.f_19796_.m_188583_() * 0.02;
                double zRandom = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_() - xRandom * 10.0, this.m_20186_() + (double)(this.f_19796_.m_188501_() * this.m_20206_()) - yRandom * 10.0, this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_() - zRandom * 10.0, 0.9, 0.1, 0.1);
            }
        }
    }

    public void spawnExplosionParticle() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                float mx = (this.f_19796_.m_188501_() - 0.5f) * 0.02f;
                float my = (this.f_19796_.m_188501_() - 0.5f) * 0.02f;
                float mz = (this.f_19796_.m_188501_() - 0.5f) * 0.02f;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, (double)mx, (double)my, (double)mz);
            }
        }
    }

    public void spawnBubbleParticle() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = 2.0 * this.f_19796_.m_188500_() - 1.0;
                double offsetY = this.f_19796_.m_188500_() / 2.0;
                double offsetZ = 2.0 * this.f_19796_.m_188500_() - 1.0;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.1, 0.0);
            }
        }
    }

    public void spawnHeartParticle() {
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = this.f_19796_.m_188583_() * 0.02;
                double offsetY = this.f_19796_.m_188583_() * 0.02;
                double offsetZ = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), offsetX, offsetY, offsetZ);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnRankUpParticle() {
        if (this.f_19853_.f_46443_) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecraft.f_91061_.m_107332_((Entity)this, (ParticleOptions)ParticleTypes.f_123767_, 30);
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11699_, this.m_5720_(), 1.0f, 1.0f, false);
            minecraft.f_91065_.m_168714_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.rank_up.title"));
            minecraft.f_91065_.m_168711_((Component)Component.m_237115_((String)"message.touhou_little_maid.gomoku.rank_up.subtitle"));
        }
    }

    private void spawnSweepAttackParticle() {
        double xOffset = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        double zOffset = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_() + xOffset, this.m_20227_(0.5), this.m_20189_() + zOffset, 0, xOffset, 0.0, zOffset, 0.0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_(MODEL_ID_TAG, this.getModelId());
        compound.m_128359_(SOUND_PACK_ID_TAG, this.getSoundPackId());
        compound.m_128359_(TASK_TAG, this.getTask().getUid().toString());
        compound.m_128379_(PICKUP_TAG, this.isPickup());
        compound.m_128379_(HOME_TAG, this.isHomeModeEnable());
        compound.m_128379_(RIDEABLE_TAG, this.isRideable());
        compound.m_128365_(MAID_INVENTORY_TAG, (Tag)this.maidInv.serializeNBT());
        compound.m_128365_(MAID_BAUBLE_INVENTORY_TAG, (Tag)this.maidBauble.serializeNBT());
        compound.m_128379_(STRUCK_BY_LIGHTNING_TAG, this.isStruckByLightning());
        compound.m_128379_(INVULNERABLE_TAG, this.getIsInvulnerable());
        compound.m_128405_(HUNGER_TAG, this.getHunger());
        compound.m_128405_(FAVORABILITY_TAG, this.getFavorability());
        compound.m_128405_(EXPERIENCE_TAG, this.getExperience());
        compound.m_128359_(SCHEDULE_MODE_TAG, this.getSchedule().name());
        compound.m_128359_(MAID_BACKPACK_TYPE, this.getMaidBackpackType().getId().toString());
        compound.m_128365_(GAME_SKILL_TAG, (Tag)this.getGameSkill());
        this.favorabilityManager.addAdditionalSaveData(compound);
        this.scriptBookManager.addAdditionalSaveData(compound);
        this.schedulePos.save(compound);
        if (this.backpackData != null) {
            CompoundTag tag = new CompoundTag();
            this.backpackData.save(tag, this);
            compound.m_128365_(BACKPACK_DATA_TAG, (Tag)tag);
        } else {
            compound.m_128365_(BACKPACK_DATA_TAG, (Tag)new CompoundTag());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_(MODEL_ID_TAG, 8)) {
            this.setModelId(compound.m_128461_(MODEL_ID_TAG));
        }
        if (compound.m_128425_(SOUND_PACK_ID_TAG, 8)) {
            this.setSoundPackId(compound.m_128461_(SOUND_PACK_ID_TAG));
        }
        if (compound.m_128425_(SCHEDULE_MODE_TAG, 8)) {
            this.setSchedule(MaidSchedule.valueOf(compound.m_128461_(SCHEDULE_MODE_TAG)));
        }
        if (compound.m_128425_(TASK_TAG, 8)) {
            ResourceLocation uid = new ResourceLocation(compound.m_128461_(TASK_TAG));
            IMaidTask task = TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
            this.setTask(task);
        }
        if (compound.m_128425_(PICKUP_TAG, 1)) {
            this.setPickup(compound.m_128471_(PICKUP_TAG));
        }
        if (compound.m_128425_(HOME_TAG, 1)) {
            this.setHomeModeEnable(compound.m_128471_(HOME_TAG));
        }
        if (compound.m_128425_(RIDEABLE_TAG, 1)) {
            this.setRideable(compound.m_128471_(RIDEABLE_TAG));
        }
        if (compound.m_128425_(BACKPACK_LEVEL_TAG, 3)) {
            int backpackLevel = compound.m_128451_(BACKPACK_LEVEL_TAG);
            if (backpackLevel == 1) {
                BackpackManager.findBackpack(SmallBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 2) {
                BackpackManager.findBackpack(MiddleBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            if (backpackLevel == 3) {
                BackpackManager.findBackpack(BigBackpack.ID).ifPresent(this::setMaidBackpackType);
            }
            compound.m_128473_(BACKPACK_LEVEL_TAG);
        }
        if (compound.m_128425_(MAID_INVENTORY_TAG, 10)) {
            this.maidInv.deserializeNBT(compound.m_128469_(MAID_INVENTORY_TAG));
        }
        if (compound.m_128425_(MAID_BAUBLE_INVENTORY_TAG, 10)) {
            this.maidBauble.deserializeNBT(compound.m_128469_(MAID_BAUBLE_INVENTORY_TAG));
        }
        if (compound.m_128425_(STRUCK_BY_LIGHTNING_TAG, 1)) {
            this.setStruckByLightning(compound.m_128471_(STRUCK_BY_LIGHTNING_TAG));
        }
        if (compound.m_128425_(INVULNERABLE_TAG, 1)) {
            this.setEntityInvulnerable(compound.m_128471_(INVULNERABLE_TAG));
        }
        if (compound.m_128425_(HUNGER_TAG, 3)) {
            this.setHunger(compound.m_128451_(HUNGER_TAG));
        }
        if (compound.m_128425_(FAVORABILITY_TAG, 3)) {
            this.setFavorability(compound.m_128451_(FAVORABILITY_TAG));
        }
        if (compound.m_128425_(EXPERIENCE_TAG, 3)) {
            this.setExperience(compound.m_128451_(EXPERIENCE_TAG));
        }
        if (compound.m_128425_(GAME_SKILL_TAG, 10)) {
            this.setGameSkill(compound.m_128469_(GAME_SKILL_TAG));
        }
        if (compound.m_128425_(RESTRICT_CENTER_TAG, 10)) {
            BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_(RESTRICT_CENTER_TAG));
            this.schedulePos.setHomeModeEnable(this, blockPos);
            compound.m_128473_(RESTRICT_CENTER_TAG);
        }
        if (compound.m_128425_(MAID_BACKPACK_TYPE, 8)) {
            ResourceLocation id = new ResourceLocation(compound.m_128461_(MAID_BACKPACK_TYPE));
            IMaidBackpack backpack = BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
            this.setMaidBackpackType(backpack);
            if (this.backpackData != null && compound.m_128425_(BACKPACK_DATA_TAG, 10)) {
                this.backpackData.load(compound.m_128469_(BACKPACK_DATA_TAG), this);
            }
        }
        this.favorabilityManager.readAdditionalSaveData(compound);
        this.scriptBookManager.readAdditionalSaveData(compound);
        this.schedulePos.load(compound, this);
        this.setBackpackShowItem(this.maidInv.getStackInSlot(5));
    }

    public boolean openMaidGui(Player player) {
        return this.openMaidGui(player, 0);
    }

    public boolean openMaidGui(Player player, int tabIndex) {
        if (player instanceof ServerPlayer && !this.m_5803_()) {
            this.f_21344_.m_26573_();
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getGuiProvider(tabIndex), buffer -> buffer.writeInt(this.m_19879_()));
        }
        return true;
    }

    private MenuProvider getGuiProvider(int tabIndex) {
        switch (tabIndex) {
            case 5: {
                return MaidConfigContainer.create(this.m_19879_());
            }
        }
        return this.getMaidBackpackType().getGuiProvider(this.m_19879_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == null) {
                return LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.maidInv, this.maidBauble})).cast();
            }
            if (facing.m_122434_().m_122478_()) {
                return LazyOptional.of(() -> this.handsInvWrapper).cast();
            }
            if (facing.m_122434_().m_122479_()) {
                return LazyOptional.of(() -> this.armorInvWrapper).cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    protected void m_5907_() {
        if (this.m_21805_() != null && !this.f_19853_.f_46443_ && !PetBedDrop.hasPetBedPos(this)) {
            Vec3 position = Vec3.m_82539_((Vec3i)this.m_20183_());
            if (this.m_20186_() < (double)(this.f_19853_.m_141937_() + 5)) {
                position = new Vec3(position.f_82479_, (double)(this.f_19853_.m_141937_() + 5), position.f_82481_);
            }
            if (this.m_20186_() > (double)this.f_19853_.m_151558_()) {
                position = new Vec3(position.f_82479_, (double)this.f_19853_.m_151558_(), position.f_82481_);
            }
            EntityTombstone tombstone = new EntityTombstone(this.f_19853_, this.m_21805_(), position);
            tombstone.setMaidName(this.m_5446_());
            CombinedInvWrapper invWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.armorInvWrapper, this.handsInvWrapper, this.maidInv, this.maidBauble});
            for (int i = 0; i < invWrapper.getSlots(); ++i) {
                int size = invWrapper.getSlotLimit(i);
                tombstone.insertItem(invWrapper.extractItem(i, size, false));
            }
            IMaidBackpack maidBackpack = this.getMaidBackpackType();
            tombstone.insertItem(maidBackpack.getTakeOffItemStack(ItemStack.f_41583_, null, this));
            maidBackpack.onSpawnTombstone(this, tombstone);
            ItemStack filmItem = ItemFilm.maidToFilm(this);
            tombstone.insertItem(filmItem);
            MaidWorldData maidWorldData = MaidWorldData.get(this.f_19853_);
            if (maidWorldData != null) {
                maidWorldData.addTombstones(this, tombstone);
            }
            this.f_19853_.m_7967_((Entity)tombstone);
        }
    }

    public ItemStack m_5584_(Level level, ItemStack food) {
        ItemStack foodAfterEat = super.m_5584_(level, food);
        MinecraftForge.EVENT_BUS.post((Event)new MaidAfterEatEvent(this, foodAfterEat));
        return foodAfterEat;
    }

    protected boolean m_6124_() {
        return true;
    }

    public int m_213860_() {
        return this.getExperience();
    }

    protected Component m_5677_() {
        Optional<MaidModelInfo> info = ServerCustomPackLoader.SERVER_MAID_MODELS.getInfo(this.getModelId());
        return (Component)info.map(maidModelInfo -> ParseI18n.parse(maidModelInfo.getName())).orElseGet(() -> Component.m_237113_((String)this.m_6095_().m_20675_()));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int modelSize = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelSize();
        if (modelSize > 0) {
            int skipRandom = this.f_19796_.m_188503_(modelSize);
            Optional modelId = ServerCustomPackLoader.SERVER_MAID_MODELS.getModelIdSet().stream().skip(skipRandom).findFirst();
            return modelId.map(id -> {
                this.setModelId((String)id);
                return spawnDataIn;
            }).orElse(spawnDataIn);
        }
        return spawnDataIn;
    }

    public void m_5496_(SoundEvent soundEvent, float volume, float pitch) {
        if (soundEvent.m_11660_().m_135815_().startsWith("maid") && !this.f_19853_.f_46443_) {
            NetworkHandler.sendToNearby((Entity)this, new PlayMaidSoundMessage(soundEvent.m_11660_(), this.getSoundPackId(), this.m_19879_()), 16);
        } else {
            super.m_5496_(soundEvent, volume, pitch);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return this.task.getAmbientSound(this);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        if (damageSourceIn.m_19384_()) {
            return (SoundEvent)InitSounds.MAID_HURT_FIRE.get();
        }
        if (damageSourceIn.m_7639_() instanceof Player) {
            if (this.playerHurtSoundCount == 0) {
                this.playerHurtSoundCount = 120;
                return (SoundEvent)InitSounds.MAID_PLAYER.get();
            }
            return null;
        }
        return (SoundEvent)InitSounds.MAID_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (MinecraftForge.EVENT_BUS.post((Event)new MaidPlaySoundEvent(this))) {
            return null;
        }
        return (SoundEvent)InitSounds.MAID_DEATH.get();
    }

    public float m_6100_() {
        return 1.0f + this.f_19796_.m_188501_() * 0.1f;
    }

    public float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * (this.m_21825_() ? 0.65f : 0.85f);
    }

    public boolean m_6162_() {
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return this.m_21830_((LivingEntity)player) && super.m_6573_(player);
    }

    public boolean canPathReach(BlockPos pos) {
        Path path = this.m_21573_().m_7864_(pos, 0);
        return path != null && path.m_77403_();
    }

    public boolean canPathReach(Entity entity) {
        Path path = this.m_21573_().m_6570_(entity, 0);
        return path != null && path.m_77403_();
    }

    public boolean m_5886_(ProjectileWeaponItem shootableItem) {
        return this.getTask() instanceof IRangedAttackTask;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB m_6921_() {
        BedrockModel model = CustomPackLoader.MAID_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.m_6921_();
        }
        return model.getRenderBoundingBox().m_82383_(this.m_20182_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 m_7939_() {
        Optional<BedrockModel<Mob>> modelOptional = CustomPackLoader.MAID_MODELS.getModel(this.getModelId());
        Optional<MaidModelInfo> infoOptional = CustomPackLoader.MAID_MODELS.getInfo(this.getModelId());
        if (modelOptional.isPresent() && infoOptional.isPresent()) {
            BedrockModel<Mob> model = modelOptional.get();
            float renderEntityScale = infoOptional.get().getRenderEntityScale();
            if (model.hasHead()) {
                BedrockPart head = model.getHead();
                return new Vec3((double)(head.x * renderEntityScale), (1.5 - (double)(head.y / 16.0f)) * (double)renderEntityScale, (double)(head.z * renderEntityScale));
            }
        }
        return super.m_7939_();
    }

    public void m_6674_(InteractionHand pHand) {
        SlashBladeCompat.swingSlashBlade(this, this.m_21120_(pHand));
        super.m_6674_(pHand);
    }

    public boolean m_6783_(double distance) {
        double range = 64.0 * EntityMaid.m_20150_();
        return distance < range * range;
    }

    public void m_5802_(BlockPos pPos) {
        super.m_5802_(pPos);
        this.m_21153_(this.m_21233_());
        this.favorabilityManager.apply(Type.SLEEP);
    }

    public void setBackpackDelay() {
        this.backpackDelay = 20;
    }

    public boolean backpackHasDelay() {
        return this.backpackDelay > 0;
    }

    @Override
    public String getModelId() {
        return (String)this.f_19804_.m_135370_(DATA_MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.f_19804_.m_135381_(DATA_MODEL_ID, (Object)modelId);
    }

    public String getSoundPackId() {
        return (String)this.f_19804_.m_135370_(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.f_19804_.m_135381_(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    public boolean isBegging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.f_19804_.m_135381_(DATA_BEGGING, (Object)begging);
    }

    public boolean isHomeModeEnable() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HOME_MODE);
    }

    public void setHomeModeEnable(boolean enable) {
        this.f_19804_.m_135381_(DATA_HOME_MODE, (Object)enable);
    }

    public boolean m_21533_() {
        return this.m_21444_(this.m_20183_());
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.m_21536_()) {
            return this.m_21534_().m_123331_((Vec3i)pos) < (double)(this.m_21535_() * this.m_21535_());
        }
        return true;
    }

    public void m_21446_(BlockPos pos, int distance) {
        this.f_19804_.m_135381_(RESTRICT_CENTER, (Object)pos);
        this.f_19804_.m_135381_(RESTRICT_RADIUS, (Object)Float.valueOf(distance));
    }

    public BlockPos m_21534_() {
        return (BlockPos)this.f_19804_.m_135370_(RESTRICT_CENTER);
    }

    public float m_21535_() {
        return ((Float)this.f_19804_.m_135370_(RESTRICT_RADIUS)).floatValue();
    }

    public void m_147271_() {
        this.schedulePos.clear(this);
    }

    public boolean m_21536_() {
        return this.isHomeModeEnable();
    }

    public BlockPos getBrainSearchPos() {
        if (this.m_21536_()) {
            return this.m_21534_();
        }
        return this.m_20183_();
    }

    public boolean canBrainMoving() {
        return !this.m_21825_() && !this.m_20159_() && !this.m_5803_() && !this.m_21523_();
    }

    public MaidChatBubbles getChatBubble() {
        return (MaidChatBubbles)this.f_19804_.m_135370_(CHAT_BUBBLE);
    }

    public void setChatBubble(MaidChatBubbles bubbles) {
        this.f_19804_.m_135381_(CHAT_BUBBLE, (Object)bubbles);
    }

    public void addChatBubble(long endTime, ChatText text) {
        ChatBubbleManger.addChatBubble(endTime, text, this);
    }

    public int getChatBubbleCount() {
        return ChatBubbleManger.getChatBubbleCount(this);
    }

    public MaidScriptBookManager getScriptBookManager() {
        return this.scriptBookManager;
    }

    public boolean isPickup() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PICKUP);
    }

    public void setPickup(boolean isPickup) {
        this.f_19804_.m_135381_(DATA_PICKUP, (Object)isPickup);
    }

    public boolean isRideable() {
        return (Boolean)this.f_19804_.m_135370_(DATA_RIDEABLE);
    }

    public void setRideable(boolean rideable) {
        this.f_19804_.m_135381_(DATA_RIDEABLE, (Object)rideable);
    }

    public boolean hasBackpack() {
        return this.getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(DATA_HUNGER);
    }

    public void setHunger(int hunger) {
        this.f_19804_.m_135381_(DATA_HUNGER, (Object)hunger);
    }

    public int getFavorability() {
        return (Integer)this.f_19804_.m_135370_(DATA_FAVORABILITY);
    }

    public void setFavorability(int favorability) {
        this.f_19804_.m_135381_(DATA_FAVORABILITY, (Object)favorability);
    }

    public int getExperience() {
        return (Integer)this.f_19804_.m_135370_(DATA_EXPERIENCE);
    }

    public void setExperience(int experience) {
        this.f_19804_.m_135381_(DATA_EXPERIENCE, (Object)experience);
    }

    public boolean isStruckByLightning() {
        return (Boolean)this.f_19804_.m_135370_(DATA_STRUCK_BY_LIGHTNING);
    }

    public void setStruckByLightning(boolean isStruck) {
        this.f_19804_.m_135381_(DATA_STRUCK_BY_LIGHTNING, (Object)isStruck);
    }

    public boolean isSwingingArms() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ARM_RISE);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.f_19804_.m_135381_(DATA_ARM_RISE, (Object)swingingArms);
    }

    public String getBackpackFluid() {
        return (String)this.f_19804_.m_135370_(BACKPACK_FLUID);
    }

    public void setBackpackFluid(String fluidName) {
        this.f_19804_.m_135381_(BACKPACK_FLUID, (Object)fluidName);
    }

    public MaidSchedule getSchedule() {
        return (MaidSchedule)((Object)this.f_19804_.m_135370_(SCHEDULE_MODE));
    }

    public Activity getScheduleDetail() {
        MaidSchedule schedule = this.getSchedule();
        int time = (int)(this.f_19853_.m_46468_() % 24000L);
        switch (schedule) {
            case ALL: {
                return Activity.f_37980_;
            }
            case NIGHT: {
                return ((Schedule)InitEntities.MAID_NIGHT_SHIFT_SCHEDULES.get()).m_38019_(time);
            }
        }
        return ((Schedule)InitEntities.MAID_DAY_SHIFT_SCHEDULES.get()).m_38019_(time);
    }

    public SchedulePos getSchedulePos() {
        return this.schedulePos;
    }

    public void setBackpackShowItem(ItemStack stack) {
        this.f_19804_.m_135381_(BACKPACK_ITEM_SHOW, (Object)stack);
    }

    @Override
    public ItemStack getBackpackShowItem() {
        return (ItemStack)this.f_19804_.m_135370_(BACKPACK_ITEM_SHOW);
    }

    public void setMaidBackpackType(IMaidBackpack backpack) {
        if (backpack == this.backpack) {
            return;
        }
        this.backpack = backpack;
        this.backpackData = this.backpack.hasBackpackData() ? this.backpack.getBackpackData(this) : null;
        this.f_19804_.m_135381_(BACKPACK_TYPE, (Object)backpack.getId().toString());
    }

    @Override
    public IMaidBackpack getMaidBackpackType() {
        ResourceLocation id = new ResourceLocation((String)this.f_19804_.m_135370_(BACKPACK_TYPE));
        return BackpackManager.findBackpack(id).orElse(BackpackManager.getEmptyBackpack());
    }

    public IBackpackData getBackpackData() {
        return this.backpackData;
    }

    public void setSchedule(MaidSchedule schedule) {
        this.f_19804_.m_135381_(SCHEDULE_MODE, (Object)schedule);
        if (this.f_19853_ instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.f_19853_);
        }
    }

    public ItemStackHandler getMaidInv() {
        return this.maidInv;
    }

    public CombinedInvWrapper getAvailableInv(boolean handsFirst) {
        RangedWrapper combinedInvWrapper = this.getAvailableBackpackInv();
        return handsFirst ? new CombinedInvWrapper(new IItemHandlerModifiable[]{this.handsInvWrapper, combinedInvWrapper}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{combinedInvWrapper, this.handsInvWrapper});
    }

    public RangedWrapper getAvailableBackpackInv() {
        return new RangedWrapper((IItemHandlerModifiable)this.maidInv, 0, this.getMaidBackpackType().getAvailableMaxContainerIndex());
    }

    public EntityHandsInvWrapper getHandsInvWrapper() {
        return this.handsInvWrapper;
    }

    public BaubleItemHandler getMaidBauble() {
        return this.maidBauble;
    }

    public boolean getIsInvulnerable() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INVULNERABLE);
    }

    public void setEntityInvulnerable(boolean isInvulnerable) {
        super.m_20331_(isInvulnerable);
        this.f_19804_.m_135381_(DATA_INVULNERABLE, (Object)isInvulnerable);
    }

    public IMaidTask getTask() {
        ResourceLocation uid = new ResourceLocation((String)this.f_19804_.m_135370_(DATA_TASK));
        return TaskManager.findTask(uid).orElse(TaskManager.getIdleTask());
    }

    public void setTask(IMaidTask task) {
        if (task == this.task) {
            return;
        }
        this.task = task;
        this.f_19804_.m_135381_(DATA_TASK, (Object)task.getUid().toString());
        if (this.f_19853_ instanceof ServerLevel) {
            this.refreshBrain((ServerLevel)this.f_19853_);
        }
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        this.m_21839_(inSittingPose);
    }

    public CompoundTag getGameSkill() {
        return (CompoundTag)this.f_19804_.m_135370_(GAME_SKILL);
    }

    public void setGameSkill(CompoundTag gameSkill) {
        this.forceSyncData(GAME_SKILL, gameSkill, true);
    }

    public <T> void forceSyncData(EntityDataAccessor<T> key, T value, boolean force) {
        SynchedEntityData.DataItem dataItem = this.f_19804_.m_135379_(key);
        if (force || ObjectUtils.notEqual(value, (Object)dataItem.m_135403_())) {
            dataItem.m_135397_(value);
            this.f_19804_.f_135344_.m_7350_(key);
            dataItem.m_135401_(true);
            this.f_19804_.f_135348_ = true;
        }
    }

    public boolean hasHelmet() {
        return !this.m_6844_(EquipmentSlot.HEAD).m_41619_();
    }

    public boolean hasChestPlate() {
        return !this.m_6844_(EquipmentSlot.CHEST).m_41619_();
    }

    public boolean hasLeggings() {
        return !this.m_6844_(EquipmentSlot.LEGS).m_41619_();
    }

    public boolean hasBoots() {
        return !this.m_6844_(EquipmentSlot.FEET).m_41619_();
    }

    public boolean onHurt() {
        return this.f_20916_ > 0;
    }

    @Deprecated
    public boolean hasSasimono() {
        return false;
    }

    public List<SendEffectMessage.EffectData> getEffects() {
        return this.effects;
    }

    public void setEffects(List<SendEffectMessage.EffectData> effects) {
        this.effects = effects;
    }

    public boolean canDestroyBlock(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        return state.m_60734_().canEntityDestroy(state, (BlockGetter)this.f_19853_, pos, (Entity)this) && ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)pos, (BlockState)state);
    }

    public boolean canPlaceBlock(BlockPos pos) {
        BlockState oldState = this.f_19853_.m_8055_(pos);
        return oldState.m_60767_().m_76336_();
    }

    public boolean destroyBlock(BlockPos pos) {
        return this.destroyBlock(pos, true);
    }

    public boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        return this.canDestroyBlock(pos) && this.destroyBlock(this.f_19853_, pos, dropBlock, (Entity)this);
    }

    public boolean destroyBlock(Level level, BlockPos blockPos, boolean dropBlock, @Nullable Entity entity) {
        boolean setResult;
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        FluidState fluidState = level.m_6425_(blockPos);
        if (!(blockState.m_60734_() instanceof BaseFireBlock)) {
            level.m_46796_(2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        if (dropBlock) {
            BlockEntity blockEntity = blockState.m_155947_() ? level.m_7702_(blockPos) : null;
            this.dropResourcesToMaidInv(blockState, level, blockPos, blockEntity, this, ItemStack.f_41583_);
        }
        if (setResult = level.m_7731_(blockPos, fluidState.m_76188_(), 3)) {
            level.m_220407_(GameEvent.f_157794_, blockPos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)blockState));
        }
        return setResult;
    }

    public void dropResourcesToMaidInv(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, EntityMaid maid, ItemStack tool) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CombinedInvWrapper availableInv = this.getAvailableInv(false);
            Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)maid, (ItemStack)tool).forEach(stack -> {
                ItemStack remindItemStack = ItemHandlerHelper.insertItemStacked((IItemHandler)availableInv, (ItemStack)stack, (boolean)false);
                if (!remindItemStack.m_41619_()) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)remindItemStack);
                }
            });
            state.m_222967_(serverLevel, pos, tool, true);
        }
    }

    public boolean placeItemBlock(InteractionHand hand, BlockPos placePos, Direction direction, ItemStack stack) {
        if (stack.m_41720_() instanceof BlockItem) {
            return ((BlockItem)stack.m_41720_()).m_40576_(new BlockPlaceContext(this.f_19853_, null, hand, stack, this.getBlockRayTraceResult(placePos, direction))).m_19077_();
        }
        return false;
    }

    public boolean placeItemBlock(BlockPos placePos, Direction direction, ItemStack stack) {
        return this.placeItemBlock(InteractionHand.MAIN_HAND, placePos, direction, stack);
    }

    public boolean placeItemBlock(BlockPos placePos, ItemStack stack) {
        return this.placeItemBlock(placePos, Direction.UP, stack);
    }

    private BlockHitResult getBlockRayTraceResult(BlockPos pos, Direction direction) {
        return new BlockHitResult(new Vec3((double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)direction.m_122430_() * 0.5, (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.5), direction, pos, false);
    }

    @Deprecated
    public String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome((Entity)this).m_47554_();
        if ((double)temp < 0.15) {
            return "COLD";
        }
        if ((double)temp < 0.55) {
            return "OCEAN";
        }
        if ((double)temp < 0.95) {
            return "MEDIUM";
        }
        return "WARM";
    }

    @Deprecated
    public boolean isSitInJoyBlock() {
        return false;
    }

    public FavorabilityManager getFavorabilityManager() {
        return this.favorabilityManager;
    }

    @Override
    public EntityMaid asStrictMaid() {
        return this;
    }

    @Override
    public Mob asEntity() {
        return this;
    }

    @Deprecated
    public int getDim() {
        ResourceKey dim = this.f_19853_.m_46472_();
        if (dim.equals((Object)Level.f_46428_)) {
            return 0;
        }
        if (dim.equals((Object)Level.f_46429_)) {
            return -1;
        }
        if (dim.equals((Object)Level.f_46430_)) {
            return 1;
        }
        return 0;
    }

    public Ingredient getTamedItem() {
        return EntityMaid.getConfigIngredient((String)MaidConfig.MAID_TAMED_ITEM.get(), Items.f_42502_);
    }

    public Ingredient getTemptationItem() {
        return EntityMaid.getConfigIngredient((String)MaidConfig.MAID_TEMPTATION_ITEM.get(), Items.f_42502_);
    }

    public static Ingredient getNtrItem() {
        return EntityMaid.getConfigIngredient((String)MaidConfig.MAID_NTR_ITEM.get(), Items.f_42263_);
    }

    private static Ingredient getConfigIngredient(String config, Item defaultItem) {
        if (config.startsWith("#")) {
            ITagManager tags = ForgeRegistries.ITEMS.tags();
            if (tags != null) {
                ResourceLocation key = new ResourceLocation(config.substring(1));
                TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)key);
                if (tags.isKnownTagName(tagKey)) {
                    return Ingredient.m_204132_((TagKey)tagKey);
                }
            }
        } else {
            ResourceLocation key = new ResourceLocation(config);
            if (ForgeRegistries.ITEMS.containsKey(key)) {
                return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(key)});
            }
        }
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{defaultItem});
    }
}

