/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskBoardGames;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.StringUtils;

public class EntitySit
extends Entity {
    public static final EntityType<EntitySit> TYPE = EntityType.Builder.m_20704_(EntitySit::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.1f).m_20702_(10).m_20712_("sit");
    private static final EntityDataAccessor<String> SIT_TYPE = SynchedEntityData.m_135353_(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int passengerTick = 0;
    private BlockPos associatedBlockPos = BlockPos.f_121853_;

    public EntitySit(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySit(Level worldIn, Vec3 pos, String joyType, BlockPos associatedBlockPos) {
        this(TYPE, worldIn);
        this.m_146884_(pos);
        this.setJoyType(joyType);
        this.associatedBlockPos = associatedBlockPos;
    }

    public double m_6048_() {
        return -0.25;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SIT_TYPE, (Object)"");
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("SitJoyType", 8)) {
            this.setJoyType(tag.m_128461_("SitJoyType"));
        }
        if (tag.m_128425_("AssociatedBlockPos", 10)) {
            this.associatedBlockPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("AssociatedBlockPos"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (StringUtils.isNotBlank((CharSequence)this.getJoyType())) {
            tag.m_128359_("SitJoyType", this.getJoyType());
        }
        tag.m_128365_("AssociatedBlockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.associatedBlockPos));
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            this.m_146871_();
            this.checkPassengers();
            Entity entity = this.m_146895_();
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                this.tickMaid(maid);
            }
        }
    }

    private void tickMaid(EntityMaid maid) {
        maid.m_146922_(this.m_146908_());
        maid.m_5616_(this.m_146908_());
        if (this.f_19797_ % 20 == 0) {
            FavorabilityManager manager = maid.getFavorabilityManager();
            manager.apply(this.getJoyType());
            if (!this.isIdleSchedule(maid) && !this.isGomokuTask(maid)) {
                maid.m_8127_();
            }
        }
    }

    private void checkPassengers() {
        this.passengerTick = this.m_20197_().isEmpty() ? ++this.passengerTick : 0;
        if (this.passengerTick > 10) {
            this.m_146870_();
        }
    }

    private boolean isGomokuTask(EntityMaid maid) {
        return Type.GOMOKU.getTypeName().equals(this.getJoyType()) && maid.getTask().getUid().equals((Object)TaskBoardGames.UID) && this.isWorkSchedule(maid);
    }

    private boolean isIdleSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.f_37979_;
    }

    private boolean isWorkSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.f_37980_;
    }

    public BlockPos getAssociatedBlockPos() {
        return this.associatedBlockPos;
    }

    public boolean m_7313_(Entity pEntity) {
        return true;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
    }

    public void m_7334_(Entity entity) {
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public void m_6210_() {
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public String getJoyType() {
        return (String)this.f_19804_.m_135370_(SIT_TYPE);
    }

    public void setJoyType(String type) {
        this.f_19804_.m_135381_(SIT_TYPE, (Object)type);
    }
}

