/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityBroom
extends AbstractEntityFromItem
implements OwnableEntity {
    public static final EntityType<EntityBroom> TYPE = EntityType.Builder.m_20704_(EntityBroom::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("broom");
    private static final EntityDataAccessor<Optional<UUID>> OWNER_ID = SynchedEntityData.m_135353_(EntityBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final String OWNER_UUID_TAG = "OwnerUUID";
    private boolean keyForward = false;
    private boolean keyBack = false;
    private boolean keyLeft = false;
    private boolean keyRight = false;

    public EntityBroom(EntityType<EntityBroom> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_20242_(true);
    }

    public EntityBroom(Level worldIn) {
        this(TYPE, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyForward() {
        return Minecraft.m_91087_().f_91066_.f_92085_.m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyBack() {
        return Minecraft.m_91087_().f_91066_.f_92087_.m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyLeft() {
        return Minecraft.m_91087_().f_91066_.f_92086_.m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean keyRight() {
        return Minecraft.m_91087_().f_91066_.f_92088_.m_90857_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_ID, Optional.empty());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_(OWNER_UUID_TAG)) {
            this.setOwnerUUID(NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_(OWNER_UUID_TAG))));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ((Optional)this.f_19804_.m_135370_(OWNER_ID)).ifPresent(uuid -> compound.m_128362_(OWNER_UUID_TAG, uuid));
    }

    public void m_7023_(Vec3 vec3) {
        LivingEntity entity = this.getControllingPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.m_20160_() && this.m_146862_(e -> e instanceof EntityMaid)) {
                float vertical;
                if (this.f_19853_.f_46443_) {
                    this.keyForward = EntityBroom.keyForward();
                    this.keyBack = EntityBroom.keyBack();
                    this.keyLeft = EntityBroom.keyLeft();
                    this.keyRight = EntityBroom.keyRight();
                }
                float strafe = this.keyLeft ? 0.5f : (this.keyRight ? -0.5f : 0.0f);
                float f = vertical = this.keyForward ? -(player.m_146909_() - 10.0f) / 22.5f : 0.0f;
                float forward = this.keyForward ? 3.0f : (this.keyBack ? -0.5f : 0.0f);
                this.m_19920_(0.02f, new Vec3((double)strafe, (double)vertical, (double)forward));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                return;
            }
        }
        if (!this.m_20096_()) {
            super.m_7023_(new Vec3(0.0, (double)-0.3f, 0.0));
            return;
        }
        super.m_7023_(vec3);
    }

    protected void m_6138_() {
        if (this.m_20197_().size() >= 2) {
            return;
        }
        if (!this.m_20197_().isEmpty() && !(this.getControllingPassenger() instanceof Player)) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            List list = this.f_19853_.m_6443_(EntityMaid.class, this.m_20191_().m_82363_(0.5, 0.1, 0.5), this::canMaidRide);
            list.stream().findFirst().ifPresent(entity -> entity.m_20329_((Entity)this));
        }
    }

    private boolean canMaidRide(EntityMaid maid) {
        if (maid.canBrainMoving() && !maid.m_20160_() && EntitySelector.m_20421_((Entity)this).test(maid)) {
            UUID maidOwnerUUID = maid.m_21805_();
            UUID broomOwnerUUID = this.m_21805_();
            if (maidOwnerUUID == null || broomOwnerUUID == null) {
                return false;
            }
            return maidOwnerUUID.equals(broomOwnerUUID);
        }
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        LivingEntity passenger = this.getControllingPassenger();
        if (passenger instanceof Player) {
            Player player = (Player)passenger;
            if (this.m_6084_()) {
                this.tickRidden(player);
            }
        }
    }

    protected void tickRidden(Player player) {
        this.f_19789_ = 0.0f;
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.m_19915_(player.m_146908_(), player.m_146909_());
    }

    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(passenger)) {
            double yOffset;
            double xOffset = passenger instanceof EntityMaid ? -0.5 : 0.0;
            double d = yOffset = this.m_213877_() ? 0.01 : this.m_6048_() + passenger.m_6049_();
            if (this.m_20197_().size() > 1) {
                int passengerIndex = this.m_20197_().indexOf(passenger);
                xOffset = passengerIndex == 0 ? 0.35 : -0.35;
            }
            Vec3 offset = new Vec3(xOffset, yOffset, 0.0).m_82524_((float)((double)(-this.m_146908_()) * Math.PI / 180.0 - 1.5707963267948966));
            moveFunction.m_20372_(passenger, this.m_20185_() + offset.f_82479_, this.m_20186_() + offset.f_82480_, this.m_20189_() + offset.f_82481_);
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!(player.m_20163_() || this.m_20159_() || this.getControllingPassenger() instanceof Player)) {
            if (this.m_20197_().size() > 1) {
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.f_19853_.f_46443_) {
                player.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() < 2;
    }

    public double m_6048_() {
        return 0.0;
    }

    @Override
    protected boolean canKillEntity(Player player) {
        return true;
    }

    @Override
    protected SoundEvent getHitSound() {
        return SoundEvents.f_12639_;
    }

    @Override
    protected Item getWithItem() {
        return (Item)InitItems.BROOM.get();
    }

    @Override
    protected ItemStack getKilledStack() {
        return new ItemStack((ItemLike)this.getWithItem());
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        this.m_183634_();
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_ID)).orElse(null);
    }

    @Nullable
    public Entity m_21826_() {
        UUID uuid = this.m_21805_();
        return uuid == null ? null : this.f_19853_.m_46003_(uuid);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_ID, Optional.ofNullable(uuid));
    }
}

