/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatText;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;

public class MaidScriptBookManager {
    private static final Gson GSON = new Gson();
    private static final String STORE_TAG = "MaidScriptBook";
    private static final String PAGES_TAG = "pages";
    private static final String SEPARATOR = "\n\n";
    private final Map<String, List<ChatText>> scripts = Maps.newHashMap();
    private ListTag scriptsTags = new ListTag();

    public boolean installScript(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(PAGES_TAG, 9)) {
            return false;
        }
        ListTag pagesTag = tag.m_128437_(PAGES_TAG, 8);
        if (pagesTag.isEmpty()) {
            return false;
        }
        if (stack.m_41720_() == Items.f_42615_) {
            ListTag list = pagesTag.m_6426_();
            this.scriptsTags = new ListTag();
            for (int i = 0; i < list.size(); ++i) {
                BookText bookText = (BookText)GSON.fromJson(list.m_128778_(i), BookText.class);
                this.scriptsTags.add((Object)StringTag.m_129297_((String)bookText.text));
            }
        } else {
            this.scriptsTags = pagesTag.m_6426_();
        }
        this.loadFromTag(this.scriptsTags);
        return true;
    }

    public void removeScript() {
        this.scripts.clear();
        this.scriptsTags = new ListTag();
    }

    public boolean copyScript(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_(PAGES_TAG, 9) || tag.m_128437_(PAGES_TAG, 8).isEmpty()) {
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_(PAGES_TAG, (Tag)this.scriptsTags.m_6426_());
            return true;
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.m_128365_(STORE_TAG, (Tag)this.scriptsTags);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128425_(STORE_TAG, 9)) {
            this.scriptsTags = compound.m_128437_(STORE_TAG, 8);
            this.loadFromTag(this.scriptsTags);
        }
    }

    private void loadFromTag(ListTag pages) {
        this.scripts.clear();
        for (int i = 0; i < pages.size(); ++i) {
            String type;
            String pageText = pages.m_128778_(i);
            String[] split = StringUtils.split((String)pageText, (String)SEPARATOR);
            if (split.length < 2 || StringUtils.isBlank((CharSequence)(type = StringUtils.strip((String)split[0]).toLowerCase(Locale.US)))) continue;
            List scriptList = this.scripts.computeIfAbsent(type, k -> Lists.newArrayList());
            for (int j = 1; j < split.length; ++j) {
                String script = StringUtils.strip((String)split[j]);
                if (!StringUtils.isNotBlank((CharSequence)script)) continue;
                ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, script);
                scriptList.add(chatText);
            }
        }
    }

    public List<ChatText> getScripts(String type) {
        return this.scripts.getOrDefault(type, Lists.newArrayList());
    }

    private static class BookText {
        @SerializedName(value="text")
        private String text;

        private BookText() {
        }
    }
}

