/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatTextType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.commons.lang3.StringUtils;

public final class ChatText {
    public static final ResourceLocation EMPTY_ICON_PATH = new ResourceLocation("touhou_little_maid", "empty");
    public static final ChatText EMPTY_CHAT_TEXT = new ChatText(ChatTextType.EMPTY, EMPTY_ICON_PATH, "");
    private static final String ICON_IDENTIFIER_CHAR = "%";
    private final ChatTextType type;
    private final ResourceLocation iconPath;
    private final String text;

    public ChatText(ChatTextType type, ResourceLocation iconPath, String text) {
        this.type = type;
        this.iconPath = iconPath;
        this.text = text;
    }

    public static void toBuff(ChatText chatText, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)chatText.type);
        buf.m_130085_(chatText.iconPath);
        buf.m_130070_(chatText.text);
    }

    public static ChatText fromBuff(FriendlyByteBuf buf) {
        ChatTextType type = (ChatTextType)buf.m_130066_(ChatTextType.class);
        ResourceLocation iconPath = buf.m_130281_();
        String text = buf.m_130277_();
        return new ChatText(type, iconPath, text);
    }

    public boolean isText() {
        return this.type == ChatTextType.TEXT;
    }

    public boolean isIcon() {
        return this.type == ChatTextType.ICON;
    }

    public ResourceLocation getIconPath() {
        return this.iconPath;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChatText)) {
            return false;
        }
        ChatText chatText = (ChatText)obj;
        return this.type.equals((Object)chatText.type) && this.iconPath.equals((Object)chatText.iconPath) && this.text.equals(chatText.text);
    }

    public static class Serializer
    implements JsonDeserializer<ChatText> {
        public ChatText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = GsonHelper.m_13805_((JsonElement)json, (String)"chat_text");
            if (StringUtils.isEmpty((CharSequence)text)) {
                return EMPTY_CHAT_TEXT;
            }
            if (text.startsWith(ChatText.ICON_IDENTIFIER_CHAR) && text.endsWith(ChatText.ICON_IDENTIFIER_CHAR)) {
                String substring = text.substring(1, text.length() - 1);
                if (ResourceLocation.m_135830_((String)substring)) {
                    return new ChatText(ChatTextType.ICON, new ResourceLocation(substring), "");
                }
                return EMPTY_CHAT_TEXT;
            }
            return new ChatText(ChatTextType.TEXT, EMPTY_ICON_PATH, text);
        }
    }
}

