/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class MaidInteractWithDoor
extends Behavior<LivingEntity> {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 3;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 8.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;
    @Nullable
    private Node lastCheckedNode;
    private int remainingCooldown;

    public MaidInteractWithDoor() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26379_, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean m_6114_(ServerLevel serverWorld, LivingEntity entity) {
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (!path.m_77387_() && !path.m_77392_()) {
            if (!Objects.equals(this.lastCheckedNode, path.m_77401_())) {
                this.remainingCooldown = 3;
                return true;
            }
            if (this.remainingCooldown > 0) {
                --this.remainingCooldown;
            }
            return this.remainingCooldown == 0;
        }
        return false;
    }

    protected void m_6735_(ServerLevel serverWorld, LivingEntity entity, long gameTime) {
        DoorBlock doorBlock;
        BlockPos blockPos;
        BlockState blockState;
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        this.lastCheckedNode = path.m_77401_();
        Node previousNode = path.m_77402_();
        Node nextNode = path.m_77401_();
        BlockPos blockpos = previousNode.m_77288_();
        BlockState blockstate = serverWorld.m_8055_(blockpos);
        if (blockstate.m_204336_(BlockTags.f_13095_)) {
            DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
            if (!doorblock.m_52815_(blockstate)) {
                doorblock.m_153165_((Entity)entity, (Level)serverWorld, blockstate, blockpos, true);
            }
            this.rememberDoorToClose(serverWorld, entity, blockpos);
        }
        if ((blockState = serverWorld.m_8055_(blockPos = nextNode.m_77288_())).m_204336_(BlockTags.f_13095_) && !(doorBlock = (DoorBlock)blockState.m_60734_()).m_52815_(blockState)) {
            doorBlock.m_153165_((Entity)entity, (Level)serverWorld, blockState, blockPos, true);
            this.rememberDoorToClose(serverWorld, entity, blockPos);
        }
        MaidInteractWithDoor.closeDoorsThatIHaveOpenedOrPassedThrough(serverWorld, entity, previousNode, nextNode);
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(ServerLevel serverWorld, LivingEntity entity, @Nullable Node pathPoint, @Nullable Node pathPoint1) {
        Brain brain = entity.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26379_)) {
            Iterator iterator = ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).iterator();
            while (iterator.hasNext()) {
                GlobalPos globalpos = (GlobalPos)iterator.next();
                BlockPos blockpos = globalpos.m_122646_();
                if (pathPoint != null && pathPoint.m_77288_().equals((Object)blockpos) && (pathPoint1 == null || !entity.m_20183_().equals((Object)pathPoint1.m_77288_())) || pathPoint1 != null && pathPoint1.m_77288_().equals((Object)blockpos)) continue;
                if (MaidInteractWithDoor.isDoorTooFarAway(serverWorld, entity, globalpos)) {
                    iterator.remove();
                    continue;
                }
                BlockState blockstate = serverWorld.m_8055_(blockpos);
                if (!blockstate.m_204336_(BlockTags.f_13095_)) {
                    iterator.remove();
                    continue;
                }
                DoorBlock doorblock = (DoorBlock)blockstate.m_60734_();
                if (!doorblock.m_52815_(blockstate)) {
                    iterator.remove();
                    continue;
                }
                if (MaidInteractWithDoor.areOtherMobsComingThroughDoor(serverWorld, entity, blockpos)) {
                    iterator.remove();
                    continue;
                }
                doorblock.m_153165_((Entity)entity, (Level)serverWorld, blockstate, blockpos, false);
                iterator.remove();
            }
        }
    }

    private static boolean areOtherMobsComingThroughDoor(ServerLevel serverWorld, LivingEntity entity, BlockPos blockPos) {
        Brain brain = entity.m_6274_();
        return brain.m_21874_(MemoryModuleType.f_148204_) && ((List)brain.m_21952_(MemoryModuleType.f_148204_).get()).stream().filter(livingEntity -> livingEntity.m_6095_() == entity.m_6095_()).filter(livingEntity -> blockPos.m_203195_((Position)livingEntity.m_20182_(), 2.0)).anyMatch(livingEntity -> MaidInteractWithDoor.isMobComingThroughDoor(serverWorld, livingEntity, blockPos));
    }

    private static boolean isMobComingThroughDoor(ServerLevel serverWorld, LivingEntity entity, BlockPos blockPos) {
        if (!entity.m_6274_().m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node pathpoint = path.m_77402_();
        if (pathpoint == null) {
            return false;
        }
        Node nextNode = path.m_77401_();
        return blockPos.equals((Object)pathpoint.m_77288_()) || blockPos.equals((Object)nextNode.m_77288_());
    }

    private static boolean isDoorTooFarAway(ServerLevel serverWorld, LivingEntity entity, GlobalPos globalPos) {
        return globalPos.m_122640_() != serverWorld.m_46472_() || !globalPos.m_122646_().m_203195_((Position)entity.m_20182_(), 8.0);
    }

    private void rememberDoorToClose(ServerLevel serverWorld, LivingEntity entity, BlockPos blockPos) {
        Brain brain = entity.m_6274_();
        GlobalPos globalpos = GlobalPos.m_122643_((ResourceKey)serverWorld.m_46472_(), (BlockPos)blockPos);
        if (brain.m_21952_(MemoryModuleType.f_26379_).isPresent()) {
            ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).add(globalpos);
        } else {
            brain.m_21879_(MemoryModuleType.f_26379_, (Object)Sets.newHashSet((Object[])new GlobalPos[]{globalpos}));
        }
    }
}

