/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class MaidCollectHoneyTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 100;
    private final float speed;
    private final int closeEnoughDist;

    public MaidCollectHoneyTask(float speed, int closeEnoughDist) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.speed = speed;
        this.closeEnoughDist = closeEnoughDist;
        this.setMaxCheckRate(100);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos beehivePos = this.findBeehive(worldIn, maid);
            if (beehivePos != null && maid.m_21444_(beehivePos)) {
                if (beehivePos.m_203193_((Position)maid.m_20182_()) < Math.pow(this.closeEnoughDist, 2.0)) {
                    maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(beehivePos));
                    return true;
                }
                BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)beehivePos, (float)this.speed, (int)1);
                this.setNextCheckTickCount(5);
            } else {
                maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(target -> {
            BlockPos hivePos = target.m_6675_();
            BlockState hiveBlockState = level.m_8055_(hivePos);
            if ((Integer)hiveBlockState.m_61143_((Property)BeehiveBlock.f_49564_) < 5) {
                return;
            }
            CombinedInvWrapper maidAvailableInv = maid.getAvailableInv(true);
            if (!this.collectHoneyComb(level, maid, maidAvailableInv, hiveBlockState, hivePos)) {
                this.collectHoneyBottle(level, maid, maidAvailableInv, hiveBlockState, hivePos);
            }
        });
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    private void collectHoneyBottle(ServerLevel level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        ItemStack bottle = ItemsUtil.getStack((IItemHandler)maidAvailableInv, stack -> stack.m_150930_(Items.f_42590_));
        if (!bottle.m_41619_()) {
            ItemStack honeyBottle = new ItemStack((ItemLike)Items.f_42787_);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)true);
            if (!result.m_41619_()) {
                return;
            }
            bottle.m_41774_(1);
            level.m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyBottle, (boolean)false);
            this.resetHoneyLevel((Level)level, hiveBlockState, hivePos);
            maid.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    private boolean collectHoneyComb(ServerLevel level, EntityMaid maid, CombinedInvWrapper maidAvailableInv, BlockState hiveBlockState, BlockPos hivePos) {
        boolean hasShears = maid.m_21205_().canPerformAction(ToolActions.SHEARS_HARVEST);
        if (hasShears) {
            ItemStack honeyComb = new ItemStack((ItemLike)Items.f_42784_, 3);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)true);
            if (!result.m_41619_()) {
                return false;
            }
            level.m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemHandlerHelper.insertItemStacked((IItemHandler)maidAvailableInv, (ItemStack)honeyComb, (boolean)false);
            this.resetHoneyLevel((Level)level, hiveBlockState, hivePos);
            maid.m_6674_(InteractionHand.MAIN_HAND);
            maid.m_21205_().m_41622_(1, (LivingEntity)maid, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findBeehive(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.getBrainSearchPos();
        PoiManager poiManager = world.m_8904_();
        int range = (int)maid.m_21535_();
        return poiManager.m_27181_(type -> type.m_203656_(PoiTypeTags.f_215877_), blockPos, range, PoiManager.Occupancy.ANY).map(PoiRecord::m_27257_).filter(pos -> this.canCollectHoney(world, (BlockPos)pos)).min(Comparator.comparingDouble(pos -> pos.m_123331_((Vec3i)maid.m_20183_()))).orElse(null);
    }

    private boolean canCollectHoney(ServerLevel world, BlockPos hivePos) {
        return (Integer)world.m_8055_(hivePos).m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
    }

    public void resetHoneyLevel(Level level, BlockState state, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
    }
}

