/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.jei.altar;

import com.github.tartaricacid.touhoulittlemaid.compat.jei.altar.AltarRecipeWrapper;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;

public final class AltarRecipeMaker {
    private final RecipeManager recipeManager;

    private AltarRecipeMaker() {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        this.recipeManager = world.m_7465_();
    }

    public static AltarRecipeMaker getInstance() {
        return new AltarRecipeMaker();
    }

    public List<AltarRecipeWrapper> getAltarRecipes() {
        List altarRecipesMap = this.recipeManager.m_44013_(InitRecipes.ALTAR_CRAFTING);
        ArrayList recipes = Lists.newArrayList();
        for (AltarRecipe recipe : altarRecipesMap) {
            String langKey;
            ResourceLocation recipeId = recipe.m_6423_();
            ItemStack output = recipe.m_8043_();
            if (!recipe.isItemCraft()) {
                output = ((Item)InitItems.ENTITY_PLACEHOLDER.get()).m_7968_();
                ItemEntityPlaceholder.setRecipeId(output, recipe.m_6423_());
            }
            String namespace = recipeId.m_135827_().toLowerCase(Locale.US);
            if (recipe.isItemCraft()) {
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, "item_craft");
            } else {
                Path path = Paths.get(recipeId.m_135815_().toLowerCase(Locale.US), new String[0]);
                langKey = String.format("jei.%s.altar_craft.%s.result", namespace, path.getFileName());
            }
            recipes.add(new AltarRecipeWrapper((List<Ingredient>)recipe.m_7527_(), output, recipe.getPowerCost(), langKey));
        }
        return recipes;
    }
}

