/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.tooltip;

import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.ItemMaidTooltip;
import com.github.tartaricacid.touhoulittlemaid.util.EntityCacheUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class ClientMaidTooltip
implements ClientTooltipComponent {
    @Nullable
    private final MaidModelInfo info;
    private final MutableComponent name;
    private final String customName;

    public ClientMaidTooltip(ItemMaidTooltip tooltip) {
        this.info = CustomPackLoader.MAID_MODELS.getInfo(tooltip.modelId()).orElse(null);
        this.name = this.info == null ? Component.m_237119_() : Component.m_237115_((String)ParseI18n.getI18nKey(this.info.getName()));
        this.customName = tooltip.customName();
    }

    public int m_142103_() {
        return 70;
    }

    public int m_142069_(Font font) {
        return Math.max(font.m_92852_((FormattedText)this.name), 50);
    }

    public void m_183452_(Font font, int pX, int pY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        EntityMaid maid;
        if (this.info == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)blitOffset);
        MutableComponent customNameComponent = null;
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            customNameComponent = Component.Serializer.m_130701_((String)this.customName);
            if (customNameComponent != null) {
                font.m_92889_(poseStack, (Component)customNameComponent.m_130940_(ChatFormatting.GRAY), (float)pX, (float)(pY + 2), 0xFFFFFF);
            }
        } else {
            font.m_92889_(poseStack, (Component)this.name.m_130940_(ChatFormatting.GRAY), (float)pX, (float)(pY + 2), 0xFFFFFF);
        }
        poseStack.m_85849_();
        int width = this.m_142069_(font);
        int posX = pX + width / 2;
        int posY = pY + 64;
        double rot = (double)System.currentTimeMillis() / 25.0 % 360.0;
        Quaternion pose = Vector3f.f_122227_.m_122270_((float)Math.PI);
        Quaternion rotation = Vector3f.f_122225_.m_122270_((float)Math.toRadians(rot));
        pose.m_80148_(rotation);
        try {
            maid = (EntityMaid)EntityCacheUtil.ENTITY_CACHE.get(EntityMaid.TYPE, () -> ClientMaidTooltip.lambda$renderImage$1((Level)world));
        }
        catch (ClassCastException | ExecutionException e) {
            e.printStackTrace();
            return;
        }
        EntityCacheUtil.clearMaidDataResidue(maid, false);
        if (StringUtils.isNotBlank((CharSequence)this.customName)) {
            maid.m_6593_((Component)customNameComponent);
        }
        if (this.info.getEasterEgg() != null) {
            maid.setModelId("touhou_little_maid:easter_egg_model");
        } else {
            maid.setModelId(this.info.getModelId().toString());
        }
        Window window = Minecraft.m_91087_().m_91268_();
        double windowGuiScale = window.m_85449_();
        int scissorX = (int)((double)pX * windowGuiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)posY * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)(50.0 * windowGuiScale);
        RenderSystem.m_69488_((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        RenderHelper.renderEntityInInventory(poseStack, posX, posY, blitOffset, (int)(25.0f * this.info.getRenderItemScale()), pose, null, (LivingEntity)maid);
        RenderSystem.m_69471_();
    }

    private static /* synthetic */ Entity lambda$renderImage$1(Level world) throws Exception {
        Entity e = EntityMaid.TYPE.m_20615_(world);
        return Objects.requireNonNullElseGet(e, () -> new EntityMaid(world));
    }
}

