/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.GomokuModel;
import com.github.tartaricacid.touhoulittlemaid.client.model.PieceModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class TileEntityGomokuRenderer
implements BlockEntityRenderer<TileEntityGomoku> {
    private static final ResourceLocation CHECKER_BOARD_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/gomoku.png");
    private static final ResourceLocation BLACK_PIECE_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/black_piece.png");
    private static final ResourceLocation WHITE_PIECE_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/white_piece.png");
    private static final int TIPS_RENDER_DISTANCE = 16;
    private static final int PIECE_RENDER_DISTANCE = 24;
    private final GomokuModel CHECKER_BOARD_MODEL;
    private final PieceModel PIECE_MODEL;
    private final Font font;
    private final BlockEntityRenderDispatcher dispatcher;

    public TileEntityGomokuRenderer(BlockEntityRendererProvider.Context context) {
        this.CHECKER_BOARD_MODEL = new GomokuModel(context.m_173582_(GomokuModel.LAYER));
        this.PIECE_MODEL = new PieceModel(context.m_173582_(PieceModel.LAYER));
        this.font = context.m_173586_();
        this.dispatcher = context.m_173581_();
    }

    public void render(TileEntityGomoku gomoku, float partialTick, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderChessboard(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderPiece(gomoku, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
        this.renderLatestChessTips(gomoku, poseStack, bufferIn, combinedLightIn);
        this.renderTipsText(gomoku, poseStack, bufferIn, combinedLightIn);
    }

    private void renderLatestChessTips(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!gomoku.getLatestChessPoint().equals(Point.NULL) && this.inRenderDistance(gomoku, 24)) {
            Camera camera = this.dispatcher.f_112249_;
            Point point = gomoku.getLatestChessPoint();
            poseStack.m_85836_();
            poseStack.m_85837_(-0.42, 0.25, -0.42);
            poseStack.m_85837_((double)point.x * 0.1316, 0.0, (double)point.y * 0.1316);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f + camera.m_90590_()));
            poseStack.m_85841_(0.015625f, -0.015625f, 0.015625f);
            float width = (float)(-this.font.m_92895_("\u25bc") / 2) + 0.5f;
            this.font.m_92811_("\u25bc", width, -1.5f, 0xFF0000, false, poseStack.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            poseStack.m_85849_();
        }
    }

    private void renderChessboard(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)gomoku.m_58900_().m_61143_((Property)BlockGomoku.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_((float)(facing.m_122416_() * 90)));
        if (facing == Direction.SOUTH || facing == Direction.NORTH) {
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
        }
        VertexConsumer checkerBoardBuff = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)CHECKER_BOARD_TEXTURE));
        this.CHECKER_BOARD_MODEL.m_7695_(poseStack, checkerBoardBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void renderPiece(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (this.inRenderDistance(gomoku, 24)) {
            int[][] chessData;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f));
            poseStack.m_85837_(0.92, -0.1, -1.055);
            for (int[] row : chessData = gomoku.getChessData()) {
                for (int j = 0; j < chessData[0].length; ++j) {
                    poseStack.m_85837_(0.0, 0.0, 0.1316);
                    if (row[j] == 1) {
                        VertexConsumer blackPieceBuff = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)BLACK_PIECE_TEXTURE));
                        this.PIECE_MODEL.m_7695_(poseStack, blackPieceBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    if (row[j] != 2) continue;
                    VertexConsumer whitePieceBuff = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)WHITE_PIECE_TEXTURE));
                    this.PIECE_MODEL.m_7695_(poseStack, whitePieceBuff, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                poseStack.m_85837_(-0.1316, 0.0, -1.974);
            }
            poseStack.m_85849_();
        }
    }

    private void renderTipsText(TileEntityGomoku gomoku, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn) {
        if (!gomoku.isInProgress() && this.inRenderDistance(gomoku, 16)) {
            Camera camera = this.dispatcher.f_112249_;
            MutableComponent resetTips = Component.m_237115_((String)"message.touhou_little_maid.gomoku.reset").m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.AQUA);
            MutableComponent roundText = Component.m_237110_((String)"message.touhou_little_maid.gomoku.round", (Object[])new Object[]{gomoku.getChessCounter()}).m_130940_(ChatFormatting.WHITE);
            MutableComponent preRoundIcon = Component.m_237113_((String)"\u23f9 ").m_130940_(ChatFormatting.GREEN);
            MutableComponent postRoundIcon = Component.m_237113_((String)" \u23f9").m_130940_(ChatFormatting.GREEN);
            MutableComponent roundTips = preRoundIcon.m_7220_((Component)roundText).m_7220_((Component)postRoundIcon);
            MutableComponent loseTips = gomoku.isPlayerTurn() ? Component.m_237115_((String)"message.touhou_little_maid.gomoku.win").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE) : Component.m_237115_((String)"message.touhou_little_maid.gomoku.lose").m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.DARK_PURPLE);
            float loseTipsWidth = -this.font.m_92852_((FormattedText)loseTips) / 2;
            float resetTipsWidth = -this.font.m_92852_((FormattedText)resetTips) / 2;
            float roundTipsWidth = -this.font.m_92852_((FormattedText)roundTips) / 2;
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.75, 0.5);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f + camera.m_90590_()));
            poseStack.m_85845_(Vector3f.f_122222_.m_122240_(camera.m_90589_()));
            poseStack.m_85841_(0.03f, -0.03f, 0.03f);
            this.font.m_92841_((Component)loseTips, loseTipsWidth, -10.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.font.m_92841_((Component)roundTips, roundTipsWidth, -30.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            this.font.m_92841_((Component)resetTips, resetTipsWidth, 0.0f, 0xFFFFFF, true, poseStack.m_85850_().m_85861_(), bufferIn, false, 0, combinedLightIn);
            poseStack.m_85849_();
        }
    }

    private boolean inRenderDistance(TileEntityGomoku gomoku, int distance) {
        BlockPos pos = gomoku.m_58899_();
        return this.dispatcher.f_112249_.m_90583_().m_82531_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < (double)(distance * distance);
    }

    public boolean shouldRenderOffScreen(TileEntityGomoku te) {
        return true;
    }
}

