/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.compat.carryon.RenderFixer;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.slashblade.SlashBladeRender;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class GeckoLayerMaidHeld<T extends LivingEntity>
extends GeoLayerRenderer<T> {
    private final ItemInHandRenderer itemInHandRenderer;

    public GeckoLayerMaidHeld(IGeoRenderer<T> entityRendererIn, ItemInHandRenderer itemInHandRenderer) {
        super(entityRendererIn);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.entityRenderer.getGeoModel() == null) {
            return;
        }
        ItemStack offhandItem = entityLivingBaseIn.m_21206_();
        ItemStack mainHandItem = entityLivingBaseIn.m_21205_();
        GeoModel geoModel = this.entityRenderer.getGeoModel();
        if (!offhandItem.m_41619_() || !mainHandItem.m_41619_()) {
            poseStack.m_85836_();
            if (!geoModel.rightHandBones.isEmpty() && !RenderFixer.isCarryOnRender(mainHandItem, bufferIn)) {
                if (SlashBladeCompat.isSlashBladeItem(mainHandItem)) {
                    SlashBladeRender.renderMaidMainhandSlashBlade(entityLivingBaseIn, geoModel, poseStack, bufferIn, packedLightIn, mainHandItem, partialTicks);
                } else {
                    this.renderArmWithItem((LivingEntity)entityLivingBaseIn, mainHandItem, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferIn, packedLightIn);
                }
            }
            if (!geoModel.leftHandBones.isEmpty() && !RenderFixer.isCarryOnRender(offhandItem, bufferIn)) {
                if (SlashBladeCompat.isSlashBladeItem(offhandItem)) {
                    SlashBladeRender.renderMaidOffhandSlashBlade(geoModel, poseStack, bufferIn, packedLightIn, offhandItem);
                } else {
                    this.renderArmWithItem((LivingEntity)entityLivingBaseIn, offhandItem, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferIn, packedLightIn);
                }
            }
            poseStack.m_85849_();
        }
    }

    protected void renderArmWithItem(LivingEntity livingEntity, ItemStack itemStack, ItemTransforms.TransformType displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!itemStack.m_41619_() && this.entityRenderer.getGeoModel() != null) {
            poseStack.m_85836_();
            this.translateToHand(arm, poseStack, this.entityRenderer.getGeoModel());
            poseStack.m_85837_(0.0, -0.0625, -0.1);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            boolean isLeftHand = arm == HumanoidArm.LEFT;
            this.itemInHandRenderer.m_109322_(livingEntity, itemStack, displayContext, isLeftHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
        }
    }

    protected void translateToHand(HumanoidArm arm, PoseStack poseStack, GeoModel geoModel) {
        if (arm == HumanoidArm.LEFT) {
            int size = geoModel.leftHandBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(poseStack, geoModel.leftHandBones.get(i));
            }
            GeoBone lastBone = geoModel.leftHandBones.get(size - 1);
            RenderUtils.translateMatrixToBone(poseStack, lastBone);
            RenderUtils.translateToPivotPoint(poseStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
            RenderUtils.scaleMatrixForBone(poseStack, lastBone);
        } else {
            int size = geoModel.rightHandBones.size();
            for (int i = 0; i < size - 1; ++i) {
                RenderUtils.prepMatrixForBone(poseStack, geoModel.rightHandBones.get(i));
            }
            GeoBone lastBone = geoModel.rightHandBones.get(size - 1);
            RenderUtils.translateMatrixToBone(poseStack, lastBone);
            RenderUtils.translateToPivotPoint(poseStack, lastBone);
            RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
            RenderUtils.scaleMatrixForBone(poseStack, lastBone);
        }
    }
}

