/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.geckolayer;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;

public class GeckoLayerMaidBipedHead<T extends Mob>
extends GeoLayerRenderer<T> {
    private static final String SKULL_OWNER_TAG = "SkullOwner";
    private final GeckoEntityMaidRenderer maidRenderer;
    private final Map<SkullBlock.Type, SkullModelBase> skullModels;

    public GeckoLayerMaidBipedHead(GeckoEntityMaidRenderer entityRendererIn, EntityModelSet modelSet) {
        super(entityRendererIn);
        this.maidRenderer = entityRendererIn;
        this.skullModels = SkullBlockRenderer.m_173661_((EntityModelSet)modelSet);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.maidRenderer.getGeoModel() != null) {
            Block block;
            IMaid maid;
            ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
            GeoModel geoModel = this.maidRenderer.getGeoModel();
            if (!head.m_41619_() && this.maidRenderer.getMainInfo().isShowCustomHead() && !geoModel.headBones.isEmpty()) {
                Item item = head.m_41720_();
                poseStack.m_85836_();
                this.translateToHead(poseStack, geoModel);
                if (item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
                    AbstractSkullBlock skullBlock = (AbstractSkullBlock)((BlockItem)item).m_40614_();
                    poseStack.m_85841_(-1.1875f, 1.1875f, -1.1875f);
                    GameProfile gameprofile = this.getSkullGameProfile(head);
                    poseStack.m_85837_(-0.5, 0.0, -0.5);
                    SkullBlock.Type type = skullBlock.m_48754_();
                    SkullModelBase modelBase = this.skullModels.get(type);
                    RenderType rendertype = SkullBlockRenderer.m_112523_((SkullBlock.Type)type, (GameProfile)gameprofile);
                    SkullBlockRenderer.m_173663_(null, (float)180.0f, (float)0.0f, (PoseStack)poseStack, (MultiBufferSource)bufferIn, (int)packedLightIn, (SkullModelBase)modelBase, (RenderType)rendertype);
                }
                poseStack.m_85849_();
            }
            if ((maid = IMaid.convert(entity)) == null) {
                return;
            }
            ItemStack stack = maid.getBackpackShowItem();
            if (stack.m_41720_() instanceof BlockItem && this.maidRenderer.getMainInfo().isShowCustomHead() && !geoModel.headBones.isEmpty() && (block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof IPlantable && !(block instanceof DoublePlantBlock)) {
                BlockState plant = ((IPlantable)block).getPlant((BlockGetter)((Mob)entity).f_19853_, entity.m_20183_());
                poseStack.m_85836_();
                this.translateToHead(poseStack, geoModel);
                poseStack.m_85841_(-0.8f, 0.8f, -0.8f);
                poseStack.m_85837_(-0.5, 0.625, -0.5);
                Minecraft.m_91087_().m_91289_().m_110912_(plant, poseStack, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                poseStack.m_85849_();
            }
        }
    }

    @Nullable
    private GameProfile getSkullGameProfile(ItemStack head) {
        CompoundTag nbt;
        if (head.m_41782_() && (nbt = head.m_41783_()) != null && nbt.m_128425_(SKULL_OWNER_TAG, 10)) {
            return NbtUtils.m_129228_((CompoundTag)nbt.m_128469_(SKULL_OWNER_TAG));
        }
        return null;
    }

    protected void translateToHead(PoseStack poseStack, GeoModel geoModel) {
        int size = geoModel.headBones.size();
        for (int i = 0; i < size - 1; ++i) {
            RenderUtils.prepMatrixForBone(poseStack, geoModel.headBones.get(i));
        }
        GeoBone lastBone = geoModel.headBones.get(size - 1);
        RenderUtils.translateMatrixToBone(poseStack, lastBone);
        RenderUtils.translateToPivotPoint(poseStack, lastBone);
        RenderUtils.rotateMatrixAroundBone(poseStack, lastBone);
        RenderUtils.scaleMatrixForBone(poseStack, lastBone);
    }
}

