/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.AnimationRegister;
import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoMaidEntity;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.IAnimatable;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class GeckoMaidModel
extends AnimatedGeoModel {
    private static final ResourceLocation GECKO_DEFAULT_ID = new ResourceLocation("touhou_little_maid", "fox_miko");
    private static final ResourceLocation GECKO_DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");

    @Override
    public ResourceLocation getModelLocation(Object object) {
        if (object instanceof GeckoMaidEntity) {
            GeckoMaidEntity geckoMaid = (GeckoMaidEntity)object;
            return geckoMaid.getModel();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    public ResourceLocation getTextureLocation(Object object) {
        if (object instanceof GeckoMaidEntity) {
            GeckoMaidEntity geckoMaid = (GeckoMaidEntity)object;
            return geckoMaid.getTexture();
        }
        return GECKO_DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getAnimationFileLocation(Object object) {
        if (object instanceof GeckoMaidEntity) {
            GeckoMaidEntity geckoMaid = (GeckoMaidEntity)object;
            return geckoMaid.getAnimation();
        }
        return GECKO_DEFAULT_ID;
    }

    @Override
    public void setMolangQueries(IAnimatable animatable, double seekTime) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCustomAnimations(IAnimatable animatable, int instanceId, AnimationEvent animationEvent) {
        Object object;
        List<Object> extraData = animationEvent.getExtraData();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        if (!Minecraft.m_91087_().m_91104_() && extraData.size() == 1 && (object = extraData.get(0)) instanceof EntityModelData) {
            GeckoMaidEntity geckoMaidEntity;
            EntityModelData data = (EntityModelData)object;
            if (animatable instanceof GeckoMaidEntity && (geckoMaidEntity = (GeckoMaidEntity)animatable).getMaid() != null) {
                EntityMaid maid = geckoMaidEntity.getMaid();
                AnimationRegister.setParserValue(animationEvent, parser, data, maid);
                super.setCustomAnimations(animatable, instanceId, animationEvent);
                GeoBone head = this.getCurrentModel().head;
                if (head == null) return;
                head.setRotationX(head.getRotationX() + (float)Math.toRadians(data.headPitch));
                head.setRotationY(head.getRotationY() + (float)Math.toRadians(data.netHeadYaw));
                return;
            }
        }
        super.setCustomAnimations(animatable, instanceId, animationEvent);
    }
}

