/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.schedule.Activity;

public class ScheduleButton<T extends AbstractMaidContainer>
extends Button {
    private static final ResourceLocation BUTTON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private final EntityMaid maid;
    private MaidSchedule mode;

    public ScheduleButton(int x, int y, AbstractMaidContainerGui<T> gui) {
        super(x, y, 61, 13, (Component)Component.m_237119_(), b -> {});
        this.maid = gui.getMaid();
        this.mode = this.maid.getSchedule();
    }

    public void m_5691_() {
        int index = this.mode.ordinal() + 1;
        int length = MaidSchedule.values().length;
        this.mode = MaidSchedule.values()[index % length];
        NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(this.maid.m_19879_(), this.maid.isHomeModeEnable(), this.maid.isPickup(), this.maid.isRideable(), this.mode));
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BUTTON);
        RenderSystem.m_69482_();
        ScheduleButton.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)82.0f, (float)(43 + 14 * this.mode.ordinal()), (int)this.f_93618_, (int)this.f_93619_, (int)256, (int)256);
    }

    public List<Component> getTooltips() {
        int time = (int)(this.maid.f_19853_.m_46468_() % 24000L);
        int hour = (time / 1000 + 6) % 24;
        int minute = time % 1000 * 60 / 1000;
        Activity activity = this.maid.getScheduleDetail();
        ArrayList out = Lists.newArrayList();
        out.add(Component.m_237113_((String)String.format("\u00a7n%s\u00a77 %s:%s", this.getScheduleTransText(), DECIMAL_FORMAT.format(hour), DECIMAL_FORMAT.format(minute))));
        switch (this.mode) {
            case ALL: {
                out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 00:00-24:00 %s", this.getActivityTransText(Activity.f_37980_))));
                break;
            }
            case NIGHT: {
                if (activity == Activity.f_37980_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.f_37980_))));
                } else {
                    out.add(Component.m_237113_((String)String.format("\u00a78\u2588 18:00-06:00 %s", this.getActivityTransText(Activity.f_37980_))));
                }
                if (activity == Activity.f_37982_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.f_37982_))));
                } else {
                    out.add(Component.m_237113_((String)String.format("\u00a78\u2588 06:00-14:00 %s", this.getActivityTransText(Activity.f_37982_))));
                }
                if (activity == Activity.f_37979_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.f_37979_))));
                    break;
                }
                out.add(Component.m_237113_((String)String.format("\u00a78\u2588 14:00-18:00 %s", this.getActivityTransText(Activity.f_37979_))));
                break;
            }
            default: {
                if (activity == Activity.f_37980_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.f_37980_))));
                } else {
                    out.add(Component.m_237113_((String)String.format("\u00a78\u2588 06:00-18:00 %s", this.getActivityTransText(Activity.f_37980_))));
                }
                if (activity == Activity.f_37979_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.f_37979_))));
                } else {
                    out.add(Component.m_237113_((String)String.format("\u00a78\u2588 18:00-22:00 %s", this.getActivityTransText(Activity.f_37979_))));
                }
                if (activity == Activity.f_37982_) {
                    out.add(Component.m_237113_((String)String.format("\u00a7a\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.f_37982_))));
                    break;
                }
                out.add(Component.m_237113_((String)String.format("\u00a78\u2588 22:00-06:00 %s", this.getActivityTransText(Activity.f_37982_))));
            }
        }
        out.add(Component.m_237115_((String)"tooltips.touhou_little_maid.schedule.desc"));
        return out;
    }

    public String getScheduleTransText() {
        return I18n.m_118938_((String)("gui.touhou_little_maid.schedule." + this.mode.name().toLowerCase(Locale.US)), (Object[])new Object[0]);
    }

    public String getActivityTransText(Activity activity) {
        return I18n.m_118938_((String)("gui.touhou_little_maid.activity." + activity.m_37998_()), (Object[])new Object[0]);
    }
}

