/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetScrollData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class FoxScrollScreen
extends Screen {
    private static final int PER_PAGE_COUNT = 5;
    private final Map<String, List<FoxScrollMessage.FoxScrollData>> data;
    private int leftPos;
    private int topPos;
    private String selectDim;
    private int page = 0;

    public FoxScrollScreen(Map<String, List<FoxScrollMessage.FoxScrollData>> data) {
        super((Component)Component.m_237113_((String)"Red Fox Scroll"));
        this.data = data;
        if (!this.data.isEmpty()) {
            this.selectDim = (String)this.data.keySet().stream().findFirst().get();
        }
    }

    protected void m_7856_() {
        this.m_169413_();
        this.leftPos = (this.f_96543_ - 400) / 2;
        this.topPos = (this.f_96544_ - 208) / 2;
        this.addDimensionButtons();
        this.addPointButtons();
    }

    private void addPointButtons() {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            if (scrollData.size() > 5) {
                this.m_142416_((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 20, this.topPos, 20, 20, (Component)Component.m_237113_((String)"\u2191"), b -> {
                    if (this.page > 0) {
                        --this.page;
                        this.m_7856_();
                    }
                }));
                this.m_142416_((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 20, this.topPos + 208 - 20, 20, 20, (Component)Component.m_237113_((String)"\u2193"), b -> {
                    if (this.page < (scrollData.size() - 1) / 5) {
                        ++this.page;
                        this.m_7856_();
                    }
                }));
            }
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                if (i >= scrollData.size()) continue;
                FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                this.m_142416_((GuiEventListener)new FlatColorButton(this.leftPos + 400 - 90, offsetIn + 11, 60, 20, (Component)Component.m_237115_((String)"gui.touhou_little_maid.fox_scroll.track"), b -> NetworkHandler.CHANNEL.sendToServer((Object)new SetScrollData(this.selectDim, info.getPos()))));
                offsetIn += 42;
            }
        }
    }

    private void addDimensionButtons() {
        int offset = this.topPos;
        for (String dim : this.data.keySet()) {
            MutableComponent name = Component.m_237113_((String)dim);
            FlatColorButton dimButton = new FlatColorButton(this.leftPos, offset, 150, 19, (Component)name, b -> {
                this.selectDim = dim;
                this.page = 0;
                this.m_7856_();
            });
            if (dim.equals(this.selectDim)) {
                dimButton.setSelect(true);
            }
            this.m_142416_((GuiEventListener)dimButton);
            offset += 21;
        }
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(poseStack);
        if (this.data.isEmpty()) {
            int x = this.f_96543_ / 2;
            int y = this.f_96544_ / 2 - 5;
            FoxScrollScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"gui.touhou_little_maid.fox_scroll.empty"), (int)x, (int)y, (int)0xFF0000);
            return;
        }
        this.renderMain(poseStack);
        super.m_6305_(poseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderMain(PoseStack poseStack) {
        if (StringUtils.isNotBlank((CharSequence)this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            boolean inSameDim = this.selectDim.equals(this.getPlayerDimension());
            BlockPos playerPos = this.getPlayerPos();
            int offsetIn = this.topPos;
            for (int i = this.page * 5; i < this.page * 5 + 5; ++i) {
                MutableComponent distanceText;
                if (i >= scrollData.size()) continue;
                FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                BlockPos pos = info.getPos();
                if (inSameDim) {
                    int distance = (int)Math.sqrt(playerPos.m_123331_((Vec3i)pos));
                    distanceText = Component.m_237110_((String)"gui.touhou_little_maid.fox_scroll.distance.same_dimension", (Object[])new Object[]{distance});
                } else {
                    distanceText = Component.m_237115_((String)"gui.touhou_little_maid.fox_scroll.distance.different_dimension");
                }
                MutableComponent posText = Component.m_237110_((String)"gui.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{pos.m_123344_()});
                FoxScrollScreen.m_93172_((PoseStack)poseStack, (int)(this.leftPos + 152), (int)offsetIn, (int)(this.leftPos + 400 - 22), (int)(offsetIn + 40), (int)-279420309);
                FoxScrollScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)info.getName(), (int)(this.leftPos + 160), (int)(offsetIn + 4), (int)ChatFormatting.GOLD.m_126665_());
                this.f_96547_.m_92889_(poseStack, (Component)posText, (float)(this.leftPos + 160), (float)(offsetIn + 16), ChatFormatting.GRAY.m_126665_().intValue());
                this.f_96547_.m_92889_(poseStack, (Component)distanceText, (float)(this.leftPos + 160), (float)(offsetIn + 28), ChatFormatting.GRAY.m_126665_().intValue());
                offsetIn += 42;
            }
            if (scrollData.size() > 5) {
                String pageText = String.format("%d/%d", this.page + 1, (scrollData.size() - 1) / 5 + 1);
                FoxScrollScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)pageText, (int)(this.leftPos + 400 - 8), (int)(this.topPos + 104 - 5), (int)ChatFormatting.GRAY.m_126665_());
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private BlockPos getPlayerPos() {
        if (this.getMinecraft().f_91074_ != null) {
            return this.getMinecraft().f_91074_.m_20183_();
        }
        return BlockPos.f_121853_;
    }

    @Nullable
    private String getPlayerDimension() {
        if (this.getMinecraft().f_91074_ != null) {
            return this.getMinecraft().f_91074_.f_19853_.m_46472_().m_135782_().toString();
        }
        return null;
    }
}

