/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.MaidTabs;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model.MaidModelGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.sound.MaidSoundPackGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidTabButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ScheduleButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TaskButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.compat.ipn.SortButtonScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidConfigMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidTaskMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.RequestEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectMessage;
import com.github.tartaricacid.touhoulittlemaid.util.GuiTools;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fml.ModList;

public abstract class AbstractMaidContainerGui<T extends AbstractMaidContainer>
extends AbstractContainerScreen<T> {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_main.png");
    private static final ResourceLocation SIDE = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_side.png");
    private static final ResourceLocation BUTTON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_button.png");
    private static final ResourceLocation TASK = new ResourceLocation("touhou_little_maid", "textures/gui/maid_gui_task.png");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final int TASK_COUNT_PER_PAGE = 12;
    private static int TASK_PAGE = 0;
    @Nullable
    private final EntityMaid maid;
    private StateSwitchingButton home;
    private StateSwitchingButton pick;
    private StateSwitchingButton ride;
    private ImageButton info;
    private ImageButton skin;
    private ImageButton sound;
    private ImageButton pageDown;
    private ImageButton pageUp;
    private ImageButton pageClose;
    private ImageButton taskSwitch;
    private MaidDownloadButton modelDownload;
    private ScheduleButton<T> scheduleButton;
    private boolean taskListOpen;
    private int counterTime = 0;

    public AbstractMaidContainerGui(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97727_ = 256;
        this.f_97726_ = 256;
        this.maid = ((AbstractMaidContainer)this.f_97732_).getMaid();
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.maid == null) {
            return;
        }
        this.m_169413_();
        this.addHomeButton();
        this.addPickButton();
        this.addRideButton();
        this.addDownloadButton();
        this.addStateButton();
        this.addTaskSwitchButton();
        this.addTaskControlButton();
        this.addTaskListButton();
        this.addScheduleButton();
        this.addTabsButton();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.maid == null) {
            return;
        }
        this.drawModInfo(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.drawEffectInfo(poseStack);
        this.drawCurrentTaskText(poseStack);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    private void drawModInfo(PoseStack poseStack) {
        String minecraftVersion = SharedConstants.m_183709_().getName();
        String modVersion = ModList.get().getModFileById("touhou_little_maid").versionString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        AbstractMaidContainerGui.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)debugInfo, (int)(this.f_97735_ + 40), (int)(this.f_97736_ - 4), (int)0xFFFFFF);
    }

    private void drawEffectInfo(PoseStack poseStack) {
        if (this.taskListOpen) {
            return;
        }
        List<SendEffectMessage.EffectData> effects = this.maid.getEffects();
        if (!effects.isEmpty()) {
            int yOffset = 5;
            for (SendEffectMessage.EffectData effect : effects) {
                MutableComponent text = Component.m_237115_((String)effect.descriptionId);
                if (effect.amplifier >= 1 && effect.amplifier <= 9) {
                    MutableComponent levelText = Component.m_237115_((String)("enchantment.level." + (effect.amplifier + 1)));
                    text = text.m_130946_(" ").m_7220_((Component)levelText);
                }
                String duration = effect.duration == -1 ? I18n.m_118938_((String)"effect.duration.infinite", (Object[])new Object[0]) : StringUtil.m_14404_((int)effect.duration);
                text = text.m_130946_(" ").m_130946_(duration);
                AbstractMaidContainerGui.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)text, (int)(this.f_97735_ - this.f_96547_.m_92852_((FormattedText)text) - 3), (int)(this.f_97736_ + yOffset + 5), (int)this.getPotionColor(effect.category));
                yOffset += 10;
            }
        }
    }

    private int getPotionColor(int category) {
        switch (category) {
            case 0: {
                return ChatFormatting.GREEN.m_126665_();
            }
            case 1: {
                return ChatFormatting.RED.m_126665_();
            }
        }
        return ChatFormatting.BLUE.m_126665_();
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        poseStack.m_85837_(0.0, 0.0, -100.0);
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BG);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        SortButtonScreen.renderBackground(poseStack, this.f_97735_ + 249, this.f_97736_ + 166);
        this.drawMaidCharacter(x, y);
        this.drawBaseInfoGui(poseStack);
        this.drawTaskListBg(poseStack);
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        super.m_7025_(poseStack, x, y);
        this.renderTransTooltip(this.home, poseStack, x, y, "gui.touhou_little_maid.button.home");
        this.renderTransTooltip(this.pick, poseStack, x, y, "gui.touhou_little_maid.button.pickup");
        this.renderTransTooltip(this.ride, poseStack, x, y, "gui.touhou_little_maid.button.maid_riding_set");
        this.renderTransTooltip(this.modelDownload, poseStack, x, y, "gui.touhou_little_maid.button.model_download");
        this.renderTransTooltip(this.skin, poseStack, x, y, "gui.touhou_little_maid.button.skin");
        this.renderTransTooltip(this.sound, poseStack, x, y, "gui.touhou_little_maid.button.sound");
        this.renderTransTooltip(this.pageUp, poseStack, x, y, "gui.touhou_little_maid.task.next_page");
        this.renderTransTooltip(this.pageDown, poseStack, x, y, "gui.touhou_little_maid.task.previous_page");
        this.renderTransTooltip(this.pageClose, poseStack, x, y, "gui.touhou_little_maid.task.close");
        this.renderTransTooltip(this.taskSwitch, poseStack, x, y, "gui.touhou_little_maid.task.switch");
        this.renderMaidInfo(poseStack, x, y);
        this.renderScheduleInfo(poseStack, x, y);
        this.renderTaskButtonInfo(poseStack, x, y);
        this.modelDownload.renderExtraTips(poseStack);
    }

    protected void m_7027_(PoseStack poseStack, int x, int y) {
        this.drawTaskPageCount(poseStack);
    }

    private void addStateButton() {
        this.skin = new ImageButton(this.f_97735_ + 62, this.f_97736_ + 14, 9, 9, 72, 43, 10, BUTTON, b -> this.getMinecraft().m_91152_((Screen)new MaidModelGui(this.maid)));
        this.sound = new ImageButton(this.f_97735_ + 52, this.f_97736_ + 14, 9, 9, 144, 43, 10, BUTTON, b -> this.getMinecraft().m_91152_((Screen)new MaidSoundPackGui(this.maid)));
        this.info = new ImageButton(this.f_97735_ + 8, this.f_97736_ + 14, 9, 9, 72, 65, 10, BUTTON, GuiTools.NO_ACTION);
        this.m_142416_((GuiEventListener)this.skin);
        this.m_142416_((GuiEventListener)this.sound);
        this.m_142416_((GuiEventListener)this.info);
    }

    private void addTaskControlButton() {
        this.pageDown = new ImageButton(this.f_97735_ - 72, this.f_97736_ + 9, 16, 13, 93, 0, 14, TASK, b -> {
            List<IMaidTask> tasks = TaskManager.getTaskIndex();
            if (TASK_PAGE * 12 + 12 < tasks.size()) {
                ++TASK_PAGE;
                this.m_7856_();
            }
        });
        this.pageUp = new ImageButton(this.f_97735_ - 89, this.f_97736_ + 9, 16, 13, 110, 0, 14, TASK, b -> {
            if (TASK_PAGE > 0) {
                --TASK_PAGE;
                this.m_7856_();
            }
        });
        this.pageClose = new ImageButton(this.f_97735_ - 19, this.f_97736_ + 9, 13, 13, 127, 0, 14, TASK, b -> {
            this.taskListOpen = false;
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.pageUp);
        this.m_142416_((GuiEventListener)this.pageDown);
        this.m_142416_((GuiEventListener)this.pageClose);
        this.pageUp.f_93624_ = this.taskListOpen;
        this.pageDown.f_93624_ = this.taskListOpen;
        this.pageClose.f_93624_ = this.taskListOpen;
    }

    private void addTaskListButton() {
        List<IMaidTask> tasks = TaskManager.getTaskIndex();
        if (TASK_PAGE * 12 >= tasks.size()) {
            TASK_PAGE = 0;
        }
        for (int count = 0; count < 12; ++count) {
            int index = TASK_PAGE * 12 + count;
            if (index >= tasks.size()) continue;
            this.drawPerTaskButton(tasks, count, index);
        }
    }

    private void drawPerTaskButton(List<IMaidTask> tasks, int count, int index) {
        IMaidTask maidTask = tasks.get(index);
        TaskButton button = new TaskButton(maidTask, this.f_97735_ - 89, this.f_97736_ + 23 + 19 * count, 83, 19, 93, 28, 20, TASK, 256, 256, b -> NetworkHandler.CHANNEL.sendToServer((Object)new MaidTaskMessage(this.maid.m_19879_(), maidTask.getUid())), (b, m, x, y) -> this.m_96597_(m, this.getTaskTooltips(maidTask), x, y), (Component)Component.m_237119_());
        this.m_142416_((GuiEventListener)button);
        button.f_93624_ = this.taskListOpen;
    }

    private List<Component> getTaskTooltips(IMaidTask maidTask) {
        List<Pair<String, Predicate<EntityMaid>>> conditions;
        List<Component> desc = ParseI18n.keysToTrans(maidTask.getDescription(this.maid), ChatFormatting.GRAY);
        if (!desc.isEmpty()) {
            desc.add(0, (Component)Component.m_237115_((String)"task.touhou_little_maid.desc.title").m_130940_(ChatFormatting.GOLD));
        }
        if (!(conditions = maidTask.getConditionDescription(this.maid)).isEmpty()) {
            desc.add((Component)Component.m_237113_((String)" "));
            desc.add((Component)Component.m_237115_((String)"task.touhou_little_maid.desc.condition").m_130940_(ChatFormatting.GOLD));
        }
        for (Pair<String, Predicate<EntityMaid>> line : conditions) {
            MutableComponent prefix = Component.m_237113_((String)"- ");
            String key = String.format("task.%s.%s.condition.%s", maidTask.getUid().m_135827_(), maidTask.getUid().m_135815_(), line.getFirst());
            MutableComponent condition = Component.m_237115_((String)key);
            if (((Predicate)line.getSecond()).test(this.maid)) {
                condition.m_130940_(ChatFormatting.GREEN);
            } else {
                condition.m_130940_(ChatFormatting.RED);
            }
            desc.add((Component)prefix.m_7220_((Component)condition));
        }
        if (this.getMinecraft().f_91066_.f_92125_) {
            desc.add((Component)Component.m_237119_());
            desc.add((Component)Component.m_237110_((String)"task.touhou_little_maid.advanced.id", (Object[])new Object[]{maidTask.getUid().m_135815_()}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return desc;
    }

    private void addScheduleButton() {
        this.scheduleButton = new ScheduleButton(this.f_97735_ + 9, this.f_97736_ + 187, this);
        this.m_142416_((GuiEventListener)this.scheduleButton);
    }

    private void addTabsButton() {
        MaidTabButton[] tabs;
        MaidTabs maidTabs = new MaidTabs(this.maid.m_19879_(), this.f_97735_, this.f_97736_);
        for (MaidTabButton button : tabs = maidTabs.getTabs(this)) {
            this.m_142416_((GuiEventListener)button);
        }
    }

    private void addTaskSwitchButton() {
        this.taskSwitch = new ImageButton(this.f_97735_ + 4, this.f_97736_ + 159, 71, 21, 0, 42, 22, BUTTON, b -> {
            this.taskListOpen = !this.taskListOpen;
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.taskSwitch);
    }

    private void addRideButton() {
        this.ride = new StateSwitchingButton(this.f_97735_ + 51, this.f_97736_ + 206, 20, 20, this.maid.isRideable()){

            public void m_5716_(double mouseX, double mouseY) {
                this.f_94609_ = !this.f_94609_;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.m_19879_(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), AbstractMaidContainerGui.this.maid.isPickup(), this.f_94609_, AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.ride.m_94624_(84, 0, 21, 21, BUTTON);
        this.m_142416_((GuiEventListener)this.ride);
    }

    private void addPickButton() {
        this.pick = new StateSwitchingButton(this.f_97735_ + 30, this.f_97736_ + 206, 20, 20, this.maid.isPickup()){

            public void m_5716_(double mouseX, double mouseY) {
                this.f_94609_ = !this.f_94609_;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.m_19879_(), AbstractMaidContainerGui.this.maid.isHomeModeEnable(), this.f_94609_, AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.pick.m_94624_(42, 0, 21, 21, BUTTON);
        this.m_142416_((GuiEventListener)this.pick);
    }

    private void addHomeButton() {
        this.home = new StateSwitchingButton(this.f_97735_ + 9, this.f_97736_ + 206, 20, 20, this.maid.isHomeModeEnable()){

            public void m_5716_(double mouseX, double mouseY) {
                this.f_94609_ = !this.f_94609_;
                NetworkHandler.CHANNEL.sendToServer((Object)new MaidConfigMessage(AbstractMaidContainerGui.this.maid.m_19879_(), this.f_94609_, AbstractMaidContainerGui.this.maid.isPickup(), AbstractMaidContainerGui.this.maid.isRideable(), AbstractMaidContainerGui.this.maid.getSchedule()));
            }
        };
        this.home.m_94624_(0, 0, 21, 21, BUTTON);
        this.m_142416_((GuiEventListener)this.home);
    }

    private void addDownloadButton() {
        this.modelDownload = new MaidDownloadButton(this.f_97735_ + 20, this.f_97736_ + 230, BUTTON);
        this.m_142416_((GuiEventListener)this.modelDownload);
    }

    private void drawTaskPageCount(PoseStack poseStack) {
        if (this.taskListOpen) {
            String text = String.format("%d/%d", TASK_PAGE + 1, TaskManager.getTaskIndex().size() / 12 + 1);
            this.f_96547_.m_92883_(poseStack, text, -48.0f, 12.0f, 0x333333);
        }
    }

    private void drawCurrentTaskText(PoseStack poseStack) {
        IMaidTask task = this.maid.getTask();
        this.f_96542_.m_115123_(task.getIcon(), this.f_97735_ + 6, this.f_97736_ + 161);
        List splitTexts = this.f_96547_.m_92923_((FormattedText)task.getName(), 42);
        if (!splitTexts.isEmpty()) {
            this.f_96547_.m_92877_(poseStack, (FormattedCharSequence)splitTexts.get(0), (float)(this.f_97735_ + 28), (float)(this.f_97736_ + 165), 0x333333);
        }
    }

    private void renderMaidInfo(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.info.m_198029_()) {
            ArrayList list = Lists.newArrayList();
            String prefix = "\u00a7a\u2588 ";
            MutableComponent title = Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.info.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE})).m_7220_((Component)Component.m_237113_((String)"\u00a7r "));
            if (this.maid.isStruckByLightning()) {
                title.m_7220_((Component)Component.m_237113_((String)"\u2740").m_130940_(ChatFormatting.DARK_RED));
            }
            if (this.maid.m_20147_()) {
                title.m_7220_((Component)Component.m_237113_((String)"\u271f").m_130940_(ChatFormatting.BLUE));
            }
            list.add(title);
            if (this.maid.m_21826_() != null) {
                list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.info.owner").m_130946_(": ").m_130940_(ChatFormatting.AQUA)).m_7220_(this.maid.m_21826_().m_5446_()));
            }
            CustomPackLoader.MAID_MODELS.getInfo(this.maid.getModelId()).ifPresent(info -> list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.info.model_name").m_130946_(": ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)ParseI18n.parse(info.getName()))));
            list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.info.experience").m_130946_(": ").m_130940_(ChatFormatting.AQUA)).m_130946_(String.valueOf(this.maid.getExperience())));
            list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltips.touhou_little_maid.info.favorability").m_130946_(": ").m_130940_(ChatFormatting.AQUA)).m_130946_(String.valueOf(this.maid.getFavorability())));
            list.add(Component.m_237113_((String)prefix).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"block.touhou_little_maid.gomoku").m_130946_(": ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237110_((String)"tooltips.touhou_little_maid.info.game_skill.gomoku", (Object[])new Object[]{MaidGomokuAI.getMaidCount(this.maid), MaidGomokuAI.getRank(this.maid)})));
            this.m_96597_(poseStack, list, mouseX, mouseY);
        }
    }

    private void renderTaskButtonInfo(PoseStack poseStack, int x, int y) {
        this.f_169369_.stream().filter(b -> b instanceof TaskButton).forEach(b -> {
            if (((TaskButton)((Object)b)).m_198029_()) {
                ((TaskButton)((Object)b)).m_7428_(poseStack, x, y);
            }
        });
    }

    private void renderScheduleInfo(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.scheduleButton.m_198029_()) {
            this.m_96597_(poseStack, this.scheduleButton.getTooltips(), mouseX, mouseY);
        }
    }

    private void drawMaidCharacter(int x, int y) {
        double scale = this.getMinecraft().m_91268_().m_85449_();
        RenderSystem.m_69488_((int)((int)((double)(this.f_97735_ + 6) * scale)), (int)((int)((double)(this.f_97736_ + 107 + 42) * scale)), (int)((int)(67.0 * scale)), (int)((int)(95.0 * scale)));
        InventoryScreen.m_98850_((int)(this.f_97735_ + 40), (int)(this.f_97736_ + 100), (int)40, (float)(this.f_97735_ + 40 - x), (float)(this.f_97736_ + 70 - 20 - y), (LivingEntity)this.maid);
        RenderSystem.m_69471_();
    }

    private void drawTaskListBg(PoseStack poseStack) {
        if (this.taskListOpen) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TASK);
            this.m_93228_(poseStack, this.f_97735_ - 93, this.f_97736_ + 5, 0, 0, 92, 251);
        }
    }

    private void drawBaseInfoGui(PoseStack poseStack) {
        poseStack.m_85837_(0.0, 0.0, 200.0);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, this.f_97735_ + 53, this.f_97736_ + 113, 0, 0, 9, 9);
        this.m_93228_(poseStack, this.f_97735_ + 5, this.f_97736_ + 113, 0, 9, 47, 9);
        double hp = this.maid.m_21223_() / this.maid.m_21233_();
        this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 115, 2, 18, (int)(43.0 * hp), 5);
        this.drawNumberScale(poseStack, this.maid.m_21223_(), this.f_97735_ + 63, this.f_97736_ + 114);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, this.f_97735_ + 53, this.f_97736_ + 124, 9, 0, 9, 9);
        this.m_93228_(poseStack, this.f_97735_ + 5, this.f_97736_ + 124, 0, 9, 47, 9);
        double armor = this.maid.m_21133_(Attributes.f_22284_) / 20.0;
        this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 126, 2, 23, (int)(43.0 * armor), 5);
        this.drawNumberScale(poseStack, this.maid.m_21230_(), this.f_97735_ + 63, this.f_97736_ + 125);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, this.f_97735_ + 53, this.f_97736_ + 135, 18, 0, 9, 9);
        this.m_93228_(poseStack, this.f_97735_ + 5, this.f_97736_ + 135, 0, 9, 47, 9);
        int exp = this.maid.getExperience();
        int count = exp / 120;
        double percent = (double)(exp % 120) / 120.0;
        this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 137, 2, 28, (int)(43.0 * percent), 5);
        this.drawNumberScale(poseStack, count, this.f_97735_ + 63, this.f_97736_ + 136);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, this.f_97735_ + 53, this.f_97736_ + 146, 27, 0, 9, 9);
        this.m_93228_(poseStack, this.f_97735_ + 5, this.f_97736_ + 146, 0, 9, 47, 9);
        FavorabilityManager manager = this.maid.getFavorabilityManager();
        double percent2 = manager.getLevelPercent();
        this.m_93228_(poseStack, this.f_97735_ + 7, this.f_97736_ + 148, 2, 33, (int)(43.0 * percent2), 5);
        this.drawNumberScale(poseStack, manager.getLevel(), this.f_97735_ + 63, this.f_97736_ + 147);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SIDE);
        this.m_93228_(poseStack, this.f_97735_ + 94, this.f_97736_ + 7, 107, 0, 149, 21);
        this.m_93228_(poseStack, this.f_97735_ + 6, this.f_97736_ + 178, 0, 47, 67, 25);
    }

    private void drawNumberScale(PoseStack poseStack, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        Font font = this.getMinecraft().f_91062_;
        float f = posX * 2;
        Objects.requireNonNull(this.f_96547_);
        font.m_92883_(poseStack, text, f, (float)(posY * 2 + 9 / 2), ChatFormatting.DARK_GRAY.m_126665_().intValue());
        poseStack.m_85849_();
    }

    protected void m_181908_() {
        ++this.counterTime;
        if (this.counterTime % 20 == 0 && this.maid != null) {
            NetworkHandler.CHANNEL.sendToServer((Object)new RequestEffectMessage(this.maid.m_19879_()));
        }
    }

    public int getGuiLeft() {
        if (this.taskListOpen) {
            return this.f_97735_ - 93;
        }
        return this.f_97735_;
    }

    public int getXSize() {
        if (this.taskListOpen) {
            return this.f_97726_ + 93;
        }
        return this.f_97726_;
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    private void renderTransTooltip(ImageButton button, PoseStack poseStack, int x, int y, String key) {
        if (button.m_198029_()) {
            this.m_96597_(poseStack, Collections.singletonList(Component.m_237115_((String)key)), x, y);
        }
    }

    private void renderTransTooltip(StateSwitchingButton button, PoseStack poseStack, int x, int y, String key) {
        if (button.m_198029_()) {
            this.m_96597_(poseStack, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)(key + "." + button.m_94620_())), Component.m_237115_((String)(key + ".desc"))}), x, y);
        }
    }
}

