/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.SchedulePos;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="touhou_little_maid", value={Dist.CLIENT})
public class MaidAreaRenderEvent {
    private static final Cache<Integer, SchedulePos> CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null || mc.f_91073_ == null) {
                return;
            }
            Vec3 camera = event.getCamera().m_90583_().m_82548_();
            PoseStack poseStack = event.getPoseStack();
            Iterator iterator = CACHE.asMap().keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                SchedulePos pos = (SchedulePos)CACHE.getIfPresent((Object)id);
                if (pos == null) continue;
                Entity entity = mc.f_91073_.m_6815_(id);
                if (!(entity instanceof EntityMaid)) {
                    return;
                }
                EntityMaid maid = (EntityMaid)entity;
                ResourceLocation dimension = pos.getDimension();
                if (!mc.f_91074_.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) continue;
                MaidAreaRenderEvent.renderPos(pos.getWorkPos(), pos.getIdlePos(), pos.getSleepPos(), camera, poseStack, mc, maid, (Player)mc.f_91074_);
            }
        }
    }

    private static void renderPos(@Nullable BlockPos workPos, @Nullable BlockPos idlePos, @Nullable BlockPos resetPos, Vec3 camera, PoseStack poseStack, Minecraft mc, EntityMaid maid, Player player) {
        Vec3 prePos;
        String text;
        Vec3 textPos;
        VertexConsumer buffer;
        double radius;
        Vec3 centerPos;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.0, 0.0);
        BlockPos restrictCenter = maid.m_21534_();
        Vec3 restrictPos = camera.m_82520_((double)restrictCenter.m_123341_() + 0.5, (double)restrictCenter.m_123342_() + 0.5, (double)restrictCenter.m_123343_() + 0.5);
        if (!maid.isHomeModeEnable()) {
            restrictPos = camera.m_82549_(player.m_20182_());
        }
        Vec3 maidPos = camera.m_82549_(maid.m_20182_());
        RenderHelper.renderLine(poseStack, mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_), restrictPos, maidPos, 1.0f, 0.2f, 0.2f);
        AABB aabb = maid.m_20191_().m_82386_(0.0, -1.0, 0.0).m_82383_(camera);
        RenderHelper.addChainedFilledBoxVertices(poseStack, aabb, 0.8f, 0.8f, 0.2f, 0.75f);
        if (workPos != null) {
            centerPos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_WORK_RANGE.get()).intValue() + 0.1;
            buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 1.0f, 0.0f, 0.0f);
            textPos = new Vec3((double)workPos.m_123341_() + 0.5, (double)(workPos.m_123342_() + 2), (double)workPos.m_123343_() + 0.5);
            text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.work_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0xFF1111, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0xFF1111, 0.15f, true, 5.0f, false);
        }
        if (idlePos != null) {
            centerPos = camera.m_82520_((double)idlePos.m_123341_() + 0.5, (double)idlePos.m_123342_() + 0.5, (double)idlePos.m_123343_() + 0.5);
            radius = ((Integer)MaidConfig.MAID_IDLE_RANGE.get()).intValue();
            buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 1.0f, 0.0f);
            textPos = new Vec3((double)idlePos.m_123341_() + 0.5, (double)(idlePos.m_123342_() + 2), (double)idlePos.m_123343_() + 0.5);
            if (idlePos.equals((Object)workPos)) {
                textPos = textPos.m_82520_(0.0, 1.0, 0.0);
            } else if (workPos != null) {
                prePos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.idle_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x11FF11, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x11FF11, 0.15f, true, 5.0f, false);
        }
        if (resetPos != null) {
            centerPos = camera.m_82520_((double)resetPos.m_123341_() + 0.5, (double)resetPos.m_123342_() + 0.5, (double)resetPos.m_123343_() + 0.5);
            radius = (double)((Integer)MaidConfig.MAID_SLEEP_RANGE.get()).intValue() - 0.1;
            buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_);
            RenderHelper.renderCylinder(poseStack, buffer, centerPos, radius, 16, 0.0f, 0.0f, 1.0f);
            textPos = new Vec3((double)resetPos.m_123341_() + 0.5, (double)(resetPos.m_123342_() + 2), (double)resetPos.m_123343_() + 0.5);
            if (resetPos.equals((Object)idlePos)) {
                textPos = textPos.m_82520_(0.0, 2.0, 0.0);
            } else if (idlePos != null && workPos != null) {
                prePos = camera.m_82520_((double)idlePos.m_123341_() + 0.5, (double)idlePos.m_123342_() + 0.5, (double)idlePos.m_123343_() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
                prePos = camera.m_82520_((double)workPos.m_123341_() + 0.5, (double)workPos.m_123342_() + 0.5, (double)workPos.m_123343_() + 0.5);
                RenderHelper.renderLine(poseStack, buffer, centerPos, prePos, 1.0f, 1.0f, 1.0f);
            }
            text = I18n.m_118938_((String)"message.touhou_little_maid.kappa_compass.sleep_area", (Object[])new Object[0]);
            RenderHelper.renderFloatingText(poseStack, text, textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x1111FF, 0.15f, true, -5.0f, false);
            RenderHelper.renderFloatingText(poseStack, "\u25bc", textPos.f_82479_, textPos.f_82480_, textPos.f_82481_, 0x1111FF, 0.15f, true, 5.0f, false);
        }
        poseStack.m_85849_();
    }

    public static void addSchedulePos(int id, SchedulePos pos) {
        CACHE.put((Object)id, (Object)pos);
    }
}

