/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.inner;

import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.IAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.inner.InnerAnimation;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.ModelRendererWrapper;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public final class EntityBaseAnimation {
    public static void init() {
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/dimension/default.js"), EntityBaseAnimation.getBaseDimDefault());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/float/default.js"), EntityBaseAnimation.getBaseFloatDefault());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/time/day_night_hidden.js"), EntityBaseAnimation.getBaseTimeDayNight());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/time/game_rotation.js"), EntityBaseAnimation.getBaseTimeGameRotation());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/time/system_rotation.js"), EntityBaseAnimation.getBaseTimeSysRotation());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/reciprocate.js"), EntityBaseAnimation.getBaseRotationReciprocate());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/x_high_speed.js"), EntityBaseAnimation.getBaseRotationXH());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/x_normal_speed.js"), EntityBaseAnimation.getBaseRotationXN());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/x_low_speed.js"), EntityBaseAnimation.getBaseRotationXL());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/y_high_speed.js"), EntityBaseAnimation.getBaseRotationYH());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/y_normal_speed.js"), EntityBaseAnimation.getBaseRotationYN());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/y_low_speed.js"), EntityBaseAnimation.getBaseRotationYL());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/z_high_speed.js"), EntityBaseAnimation.getBaseRotationZH());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/z_normal_speed.js"), EntityBaseAnimation.getBaseRotationZN());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/rotation/z_low_speed.js"), EntityBaseAnimation.getBaseRotationZL());
        InnerAnimation.INNER_ANIMATION.put(new ResourceLocation("touhou_little_maid:animation/base/random/select.js"), EntityBaseAnimation.getRandomSelect());
    }

    public static IAnimation<LivingEntity> getBaseDimDefault() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ResourceKey dim = entity.f_19853_.m_46472_();
                ModelRendererWrapper overWorldHidden = modelMap.get("overWorldHidden");
                ModelRendererWrapper overWorldShow = modelMap.get("overWorldShow");
                ModelRendererWrapper netherWorldHidden = modelMap.get("netherWorldHidden");
                ModelRendererWrapper netherWorldShow = modelMap.get("netherWorldShow");
                ModelRendererWrapper endWorldHidden = modelMap.get("endWorldHidden");
                ModelRendererWrapper endWorldShow = modelMap.get("endWorldShow");
                if (overWorldHidden != null) {
                    overWorldHidden.setHidden(dim.equals((Object)Level.f_46428_));
                }
                if (overWorldShow != null) {
                    overWorldShow.setHidden(!dim.equals((Object)Level.f_46428_));
                }
                if (netherWorldHidden != null) {
                    netherWorldHidden.setHidden(dim.equals((Object)Level.f_46429_));
                }
                if (netherWorldShow != null) {
                    netherWorldShow.setHidden(!dim.equals((Object)Level.f_46428_));
                }
                if (endWorldHidden != null) {
                    endWorldHidden.setHidden(dim.equals((Object)Level.f_46430_));
                }
                if (endWorldShow != null) {
                    endWorldShow.setHidden(!dim.equals((Object)Level.f_46430_));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseFloatDefault() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper sinFloat = modelMap.get("sinFloat");
                ModelRendererWrapper cosFloat = modelMap.get("cosFloat");
                ModelRendererWrapper negativeSinFloat = modelMap.get("_sinFloat");
                ModelRendererWrapper negativeCosFloat = modelMap.get("_cosFloat");
                if (sinFloat != null) {
                    sinFloat.setOffsetY((float)(Math.sin((double)ageInTicks * 0.1) * 0.05));
                }
                if (cosFloat != null) {
                    cosFloat.setOffsetY((float)(Math.cos((double)ageInTicks * 0.1) * 0.05));
                }
                if (negativeSinFloat != null) {
                    negativeSinFloat.setOffsetY((float)(-Math.sin((double)ageInTicks * 0.1) * 0.05));
                }
                if (negativeCosFloat != null) {
                    negativeCosFloat.setOffsetY((float)(-Math.cos((double)ageInTicks * 0.1) * 0.05));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseTimeDayNight() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                Level world = entity.f_19853_;
                ModelRendererWrapper dayShow = modelMap.get("dayShow");
                ModelRendererWrapper nightShow = modelMap.get("nightShow");
                if (dayShow != null) {
                    dayShow.setHidden(world.m_46468_() >= 13000L);
                }
                if (nightShow != null) {
                    nightShow.setHidden(world.m_46468_() < 13000L);
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseTimeGameRotation() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                long time = entity.f_19853_.m_46468_();
                float hourDeg = (float)(Math.PI + (double)(time / 1000L % 12L) * 0.5235987755982988);
                float minDeg = (float)((double)(time % 1000L / 16L) * 0.10471975511965977);
                ModelRendererWrapper gameHourRotationX = modelMap.get("gameHourRotationX");
                ModelRendererWrapper gameMinuteRotationX = modelMap.get("gameMinuteRotationX");
                ModelRendererWrapper gameHourRotationY = modelMap.get("gameHourRotationY");
                ModelRendererWrapper gameMinuteRotationY = modelMap.get("gameMinuteRotationY");
                ModelRendererWrapper gameHourRotationZ = modelMap.get("gameHourRotationZ");
                ModelRendererWrapper gameMinuteRotationZ = modelMap.get("gameMinuteRotationZ");
                if (gameHourRotationX != null) {
                    gameHourRotationX.setRotateAngleX(hourDeg);
                }
                if (gameMinuteRotationX != null) {
                    gameMinuteRotationX.setRotateAngleX(minDeg);
                }
                if (gameHourRotationY != null) {
                    gameHourRotationY.setRotateAngleY(hourDeg);
                }
                if (gameMinuteRotationY != null) {
                    gameMinuteRotationY.setRotateAngleY(minDeg);
                }
                if (gameHourRotationZ != null) {
                    gameHourRotationZ.setRotateAngleZ(hourDeg);
                }
                if (gameMinuteRotationZ != null) {
                    gameMinuteRotationZ.setRotateAngleZ(minDeg);
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseTimeSysRotation() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                Date date = new Date();
                float hourDeg = (float)((double)((date.getHours() + date.getMinutes() / 60) % 12) * 0.5235987755982988);
                float minDeg = (float)((double)(date.getMinutes() + date.getSeconds() / 60) * 0.10471975511965977);
                float secDeg = (float)((double)date.getSeconds() * 0.10471975511965977);
                ModelRendererWrapper systemHourRotationX = modelMap.get("systemHourRotationX");
                ModelRendererWrapper systemMinuteRotationX = modelMap.get("systemMinuteRotationX");
                ModelRendererWrapper systemSecondRotationX = modelMap.get("systemSecondRotationX");
                ModelRendererWrapper systemHourRotationY = modelMap.get("systemHourRotationY");
                ModelRendererWrapper systemMinuteRotationY = modelMap.get("systemMinuteRotationY");
                ModelRendererWrapper systemSecondRotationY = modelMap.get("systemSecondRotationY");
                ModelRendererWrapper systemHourRotationZ = modelMap.get("systemHourRotationZ");
                ModelRendererWrapper systemMinuteRotationZ = modelMap.get("systemMinuteRotationZ");
                ModelRendererWrapper systemSecondRotationZ = modelMap.get("systemSecondRotationZ");
                if (systemHourRotationX != null) {
                    systemHourRotationX.setRotateAngleX(hourDeg);
                }
                if (systemMinuteRotationX != null) {
                    systemMinuteRotationX.setRotateAngleX(minDeg);
                }
                if (systemSecondRotationX != null) {
                    systemSecondRotationX.setRotateAngleX(secDeg);
                }
                if (systemHourRotationY != null) {
                    systemHourRotationY.setRotateAngleY(hourDeg);
                }
                if (systemMinuteRotationY != null) {
                    systemMinuteRotationY.setRotateAngleY(minDeg);
                }
                if (systemSecondRotationY != null) {
                    systemSecondRotationY.setRotateAngleY(secDeg);
                }
                if (systemHourRotationZ != null) {
                    systemHourRotationZ.setRotateAngleZ(hourDeg);
                }
                if (systemMinuteRotationZ != null) {
                    systemMinuteRotationZ.setRotateAngleZ(minDeg);
                }
                if (systemSecondRotationZ != null) {
                    systemSecondRotationZ.setRotateAngleZ(secDeg);
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationReciprocate() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper xReciprocate = modelMap.get("xReciprocate");
                ModelRendererWrapper yReciprocate = modelMap.get("yReciprocate");
                ModelRendererWrapper zReciprocate = modelMap.get("zReciprocate");
                if (xReciprocate != null) {
                    xReciprocate.setRotateAngleX((float)(Math.cos((double)ageInTicks * 0.3) * 0.2));
                }
                if (yReciprocate != null) {
                    yReciprocate.setRotateAngleY((float)(Math.cos((double)ageInTicks * 0.3) * 0.2));
                }
                if (zReciprocate != null) {
                    zReciprocate.setRotateAngleZ((float)(Math.cos((double)ageInTicks * 0.3) * 0.2));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationXH() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper xRotationHighE;
                ModelRendererWrapper xRotationHighD;
                ModelRendererWrapper xRotationHighC;
                ModelRendererWrapper xRotationHighB;
                ModelRendererWrapper xRotationHighA = modelMap.get("xRotationHighA");
                if (xRotationHighA != null) {
                    xRotationHighA.setRotateAngleX((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationHighB = modelMap.get("xRotationHighB")) != null) {
                    xRotationHighB.setRotateAngleX((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationHighC = modelMap.get("xRotationHighC")) != null) {
                    xRotationHighC.setRotateAngleX((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationHighD = modelMap.get("xRotationHighD")) != null) {
                    xRotationHighD.setRotateAngleX((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationHighE = modelMap.get("xRotationHighE")) != null) {
                    xRotationHighE.setRotateAngleX((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationXN() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netNeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper xRotationNormalE;
                ModelRendererWrapper xRotationNormalD;
                ModelRendererWrapper xRotationNormalC;
                ModelRendererWrapper xRotationNormalB;
                ModelRendererWrapper xRotationNormalA = modelMap.get("xRotationNormalA");
                if (xRotationNormalA != null) {
                    xRotationNormalA.setRotateAngleX((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((xRotationNormalB = modelMap.get("xRotationNormalB")) != null) {
                    xRotationNormalB.setRotateAngleX((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((xRotationNormalC = modelMap.get("xRotationNormalC")) != null) {
                    xRotationNormalC.setRotateAngleX((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((xRotationNormalD = modelMap.get("xRotationNormalD")) != null) {
                    xRotationNormalD.setRotateAngleX((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((xRotationNormalE = modelMap.get("xRotationNormalE")) != null) {
                    xRotationNormalE.setRotateAngleX((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationXL() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper xRotationLowE;
                ModelRendererWrapper xRotationLowD;
                ModelRendererWrapper xRotationLowC;
                ModelRendererWrapper xRotationLowB;
                ModelRendererWrapper xRotationLowA = modelMap.get("xRotationLowA");
                if (xRotationLowA != null) {
                    xRotationLowA.setRotateAngleX((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationLowB = modelMap.get("xRotationLowB")) != null) {
                    xRotationLowB.setRotateAngleX((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationLowC = modelMap.get("xRotationLowC")) != null) {
                    xRotationLowC.setRotateAngleX((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationLowD = modelMap.get("xRotationLowD")) != null) {
                    xRotationLowD.setRotateAngleX((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((xRotationLowE = modelMap.get("xRotationLowE")) != null) {
                    xRotationLowE.setRotateAngleX((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationYH() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper yRotationHighE;
                ModelRendererWrapper yRotationHighD;
                ModelRendererWrapper yRotationHighC;
                ModelRendererWrapper yRotationHighB;
                ModelRendererWrapper yRotationHighA = modelMap.get("yRotationHighA");
                if (yRotationHighA != null) {
                    yRotationHighA.setRotateAngleY((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationHighB = modelMap.get("yRotationHighB")) != null) {
                    yRotationHighB.setRotateAngleY((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationHighC = modelMap.get("yRotationHighC")) != null) {
                    yRotationHighC.setRotateAngleY((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationHighD = modelMap.get("yRotationHighD")) != null) {
                    yRotationHighD.setRotateAngleY((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationHighE = modelMap.get("yRotationHighE")) != null) {
                    yRotationHighE.setRotateAngleY((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationYN() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netNeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper yRotationNormalE;
                ModelRendererWrapper yRotationNormalD;
                ModelRendererWrapper yRotationNormalC;
                ModelRendererWrapper yRotationNormalB;
                ModelRendererWrapper yRotationNormalA = modelMap.get("yRotationNormalA");
                if (yRotationNormalA != null) {
                    yRotationNormalA.setRotateAngleY((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((yRotationNormalB = modelMap.get("yRotationNormalB")) != null) {
                    yRotationNormalB.setRotateAngleY((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((yRotationNormalC = modelMap.get("yRotationNormalC")) != null) {
                    yRotationNormalC.setRotateAngleY((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((yRotationNormalD = modelMap.get("yRotationNormalD")) != null) {
                    yRotationNormalD.setRotateAngleY((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((yRotationNormalE = modelMap.get("yRotationNormalE")) != null) {
                    yRotationNormalE.setRotateAngleY((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationYL() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper yRotationLowE;
                ModelRendererWrapper yRotationLowD;
                ModelRendererWrapper yRotationLowC;
                ModelRendererWrapper yRotationLowB;
                ModelRendererWrapper yRotationLowA = modelMap.get("yRotationLowA");
                if (yRotationLowA != null) {
                    yRotationLowA.setRotateAngleY((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationLowB = modelMap.get("yRotationLowB")) != null) {
                    yRotationLowB.setRotateAngleY((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationLowC = modelMap.get("yRotationLowC")) != null) {
                    yRotationLowC.setRotateAngleY((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationLowD = modelMap.get("yRotationLowD")) != null) {
                    yRotationLowD.setRotateAngleY((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((yRotationLowE = modelMap.get("yRotationLowE")) != null) {
                    yRotationLowE.setRotateAngleY((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationZH() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper zRotationHighE;
                ModelRendererWrapper zRotationHighD;
                ModelRendererWrapper zRotationHighC;
                ModelRendererWrapper zRotationHighB;
                ModelRendererWrapper zRotationHighA = modelMap.get("zRotationHighA");
                if (zRotationHighA != null) {
                    zRotationHighA.setRotateAngleZ((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationHighB = modelMap.get("zRotationHighB")) != null) {
                    zRotationHighB.setRotateAngleZ((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationHighC = modelMap.get("zRotationHighC")) != null) {
                    zRotationHighC.setRotateAngleZ((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationHighD = modelMap.get("zRotationHighD")) != null) {
                    zRotationHighD.setRotateAngleZ((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationHighE = modelMap.get("zRotationHighE")) != null) {
                    zRotationHighE.setRotateAngleZ((float)((double)(ageInTicks * 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationZN() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netNeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper zRotationNormalE;
                ModelRendererWrapper zRotationNormalD;
                ModelRendererWrapper zRotationNormalC;
                ModelRendererWrapper zRotationNormalB;
                ModelRendererWrapper zRotationNormalA = modelMap.get("zRotationNormalA");
                if (zRotationNormalA != null) {
                    zRotationNormalA.setRotateAngleZ((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((zRotationNormalB = modelMap.get("zRotationNormalB")) != null) {
                    zRotationNormalB.setRotateAngleZ((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((zRotationNormalC = modelMap.get("zRotationNormalC")) != null) {
                    zRotationNormalC.setRotateAngleZ((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((zRotationNormalD = modelMap.get("zRotationNormalD")) != null) {
                    zRotationNormalD.setRotateAngleZ((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
                if ((zRotationNormalE = modelMap.get("zRotationNormalE")) != null) {
                    zRotationNormalE.setRotateAngleZ((float)((double)(ageInTicks % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getBaseRotationZL() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper zRotationLowE;
                ModelRendererWrapper zRotationLowD;
                ModelRendererWrapper zRotationLowC;
                ModelRendererWrapper zRotationLowB;
                ModelRendererWrapper zRotationLowA = modelMap.get("zRotationLowA");
                if (zRotationLowA != null) {
                    zRotationLowA.setRotateAngleZ((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationLowB = modelMap.get("zRotationLowB")) != null) {
                    zRotationLowB.setRotateAngleZ((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationLowC = modelMap.get("zRotationLowC")) != null) {
                    zRotationLowC.setRotateAngleZ((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationLowD = modelMap.get("zRotationLowD")) != null) {
                    zRotationLowD.setRotateAngleZ((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
                if ((zRotationLowE = modelMap.get("zRotationLowE")) != null) {
                    zRotationLowE.setRotateAngleZ((float)((double)(ageInTicks / 4.0f % 360.0f) * 0.017453292));
                }
            }
        };
    }

    public static IAnimation<LivingEntity> getRandomSelect() {
        return new IAnimation<LivingEntity>(){

            @Override
            public void setRotationAngles(float limbSwing, float limbSwingAmount, float ageInTicks, float netLeadYaw, float headPitch, float scaleFactor, LivingEntity entity, HashMap<String, ModelRendererWrapper> modelMap) {
                ModelRendererWrapper[] randomSelectUncheck = new ModelRendererWrapper[]{modelMap.get("randomSelect1"), modelMap.get("randomSelect2"), modelMap.get("randomSelect3"), modelMap.get("randomSelect4"), modelMap.get("randomSelect5")};
                ModelRendererWrapper[] randomSelect = (ModelRendererWrapper[])Arrays.stream(randomSelectUncheck).filter(Objects::nonNull).toArray(ModelRendererWrapper[]::new);
                long index = Math.abs(entity.m_20148_().getLeastSignificantBits()) % (long)randomSelect.length;
                for (int i = 0; i < randomSelect.length; ++i) {
                    randomSelect[i].setHidden((long)i != index);
                }
            }
        };
    }
}

