/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.InnerClassify;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.StringUtils;

public class ConditionalUse {
    private static final String EMPTY = "";
    private final int preSize;
    private final String idPre;
    private final String tagPre;
    private final String extraPre;
    private final List<ResourceLocation> idTest = Lists.newArrayList();
    private final List<TagKey<Item>> tagTest = Lists.newArrayList();
    private final List<UseAnim> extraTest = Lists.newArrayList();
    private final List<String> innerTest = Lists.newArrayList();

    public ConditionalUse(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.idPre = "use_mainhand$";
            this.tagPre = "use_mainhand#";
            this.extraPre = "use_mainhand:";
            this.preSize = 13;
        } else {
            this.idPre = "use_offhand$";
            this.tagPre = "use_offhand#";
            this.extraPre = "use_offhand:";
            this.preSize = 12;
        }
    }

    public void addTest(String name) {
        if (name.length() <= this.preSize) {
            return;
        }
        String substring = name.substring(this.preSize);
        if (name.startsWith(this.idPre) && ResourceLocation.m_135830_((String)substring)) {
            this.idTest.add(new ResourceLocation(substring));
        }
        if (name.startsWith(this.tagPre) && ResourceLocation.m_135830_((String)substring)) {
            ITagManager tags = ForgeRegistries.ITEMS.tags();
            if (tags == null) {
                return;
            }
            TagKey tagKey = tags.createTagKey(new ResourceLocation(substring));
            this.tagTest.add((TagKey<Item>)tagKey);
        }
        if (name.startsWith(this.extraPre)) {
            if (substring.equals(UseAnim.NONE.name().toLowerCase(Locale.US))) {
                return;
            }
            Arrays.stream(UseAnim.values()).filter(a -> a.name().toLowerCase(Locale.US).equals(substring)).findFirst().ifPresent(this.extraTest::add);
            this.innerTest.add(name);
        }
    }

    public String doTest(EntityMaid maid, InteractionHand hand) {
        if (maid.m_21120_(hand).m_41619_()) {
            return EMPTY;
        }
        String result = this.doIdTest(maid, hand);
        if (result.isEmpty()) {
            result = this.doTagTest(maid, hand);
            if (result.isEmpty()) {
                return this.doExtraTest(maid, hand);
            }
            return result;
        }
        return result;
    }

    private String doIdTest(EntityMaid maid, InteractionHand hand) {
        if (this.idTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.m_21120_(hand);
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemInHand.m_41720_());
        if (registryName == null) {
            return EMPTY;
        }
        if (this.idTest.contains(registryName)) {
            return this.idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(EntityMaid maid, InteractionHand hand) {
        if (this.tagTest.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemInHand = maid.m_21120_(hand);
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        if (tags == null) {
            return EMPTY;
        }
        return this.tagTest.stream().filter(arg_0 -> ((ItemStack)itemInHand).m_204117_(arg_0)).findFirst().map(itemTagKey -> this.tagPre + itemTagKey.f_203868_()).orElse(EMPTY);
    }

    private String doExtraTest(EntityMaid maid, InteractionHand hand) {
        if (this.extraTest.isEmpty() && this.innerTest.isEmpty()) {
            return EMPTY;
        }
        String innerName = InnerClassify.doClassifyTest(this.extraPre, maid, hand);
        if (StringUtils.isNotBlank((CharSequence)innerName) && this.innerTest.contains(innerName)) {
            return innerName;
        }
        UseAnim anim = maid.m_21120_(hand).m_41780_();
        if (this.extraTest.contains(anim)) {
            return this.extraPre + anim.name().toLowerCase(Locale.US);
        }
        return EMPTY;
    }
}

