/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGarageKit;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;

public class BlockStatue
extends Block
implements EntityBlock {
    public static final BooleanProperty IS_TINY = BooleanProperty.m_61465_((String)"is_tiny");

    public BlockStatue() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60913_(1.0f, 2.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_TINY, (Comparable)Boolean.valueOf(false)));
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.f_46443_) {
            this.getStatue((BlockGetter)worldIn, pos).ifPresent(statue -> {
                this.restoreClayBlock(worldIn, pos, (TileEntityStatue)((Object)statue));
                if (!player.m_7500_()) {
                    Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.f_50129_));
                }
            });
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (!world.f_46443_) {
            this.getStatue((BlockGetter)world, pos).ifPresent(statue -> this.restoreClayBlock(world, pos, (TileEntityStatue)((Object)statue)));
        }
        super.onBlockExploded(state, world, pos, explosion);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_TINY});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityStatue(pos, state);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState state, Level world, HitResult target, ParticleEngine manager) {
                if (target instanceof BlockHitResult && world instanceof ClientLevel) {
                    BlockHitResult blockTarget = (BlockHitResult)target;
                    BlockPos pos = blockTarget.m_82425_();
                    ClientLevel clientWorld = (ClientLevel)world;
                    this.crack(clientWorld, pos, Blocks.f_50129_.m_49966_(), blockTarget.m_82434_());
                }
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                Minecraft.m_91087_().f_91061_.m_107355_(pos, Blocks.f_50129_.m_49966_());
                return true;
            }

            @OnlyIn(value=Dist.CLIENT)
            private void crack(ClientLevel world, BlockPos pos, BlockState state, Direction side) {
                if (state.m_60799_() != RenderShape.INVISIBLE) {
                    int posX = pos.m_123341_();
                    int posY = pos.m_123342_();
                    int posZ = pos.m_123343_();
                    AABB aabb = state.m_60808_((BlockGetter)world, pos).m_83215_();
                    double x = (double)posX + world.f_46441_.m_188500_() * (aabb.f_82291_ - aabb.f_82288_ - 0.2) + 0.1 + aabb.f_82288_;
                    double y = (double)posY + world.f_46441_.m_188500_() * (aabb.f_82292_ - aabb.f_82289_ - 0.2) + 0.1 + aabb.f_82289_;
                    double z = (double)posZ + world.f_46441_.m_188500_() * (aabb.f_82293_ - aabb.f_82290_ - 0.2) + 0.1 + aabb.f_82290_;
                    if (side == Direction.DOWN) {
                        y = (double)posY + aabb.f_82289_ - 0.1;
                    }
                    if (side == Direction.UP) {
                        y = (double)posY + aabb.f_82292_ + 0.1;
                    }
                    if (side == Direction.NORTH) {
                        z = (double)posZ + aabb.f_82290_ - 0.1;
                    }
                    if (side == Direction.SOUTH) {
                        z = (double)posZ + aabb.f_82293_ + 0.1;
                    }
                    if (side == Direction.WEST) {
                        x = (double)posX + aabb.f_82288_ - 0.1;
                    }
                    if (side == Direction.EAST) {
                        x = (double)posX + aabb.f_82291_ + 0.1;
                    }
                    TerrainParticle diggingParticle = new TerrainParticle(world, x, y, z, 0.0, 0.0, 0.0, state);
                    Minecraft.m_91087_().f_91061_.m_107344_(diggingParticle.updateSprite(state, pos).m_107268_(0.2f).m_6569_(0.6f));
                }
            }
        });
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    private Optional<TileEntityStatue> getStatue(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof TileEntityStatue) {
            return Optional.of((TileEntityStatue)te);
        }
        return Optional.empty();
    }

    private void restoreClayBlock(@Nonnull Level worldIn, @Nonnull BlockPos pos, TileEntityStatue statue) {
        List<BlockPos> posList = statue.getAllBlocks();
        for (BlockPos storagePos : posList) {
            if (storagePos.equals((Object)pos)) continue;
            this.getStatue((BlockGetter)worldIn, storagePos).ifPresent(s -> worldIn.m_7731_(storagePos, Blocks.f_50129_.m_49966_(), 3));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)IS_TINY);
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (worldIn.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50083_)) {
            this.getStatue((BlockGetter)worldIn, pos).ifPresent(statue -> {
                worldIn.m_46597_(pos, ((Block)InitBlocks.GARAGE_KIT.get()).m_49966_());
                worldIn.m_46796_(1009, pos, 0);
                BlockEntity te = worldIn.m_7702_(pos);
                if (te instanceof TileEntityGarageKit && statue.getExtraMaidData() != null) {
                    ((TileEntityGarageKit)te).setData(statue.getFacing(), statue.getExtraMaidData());
                }
            });
        }
    }
}

