/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.eatinganimation.mixin;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin
implements ResourceManagerReloadListener {
    @Final
    @Shadow
    private ItemModelShaper f_115095_;
    @Shadow
    public float f_115093_;

    @Shadow
    protected abstract void m_115127_(ItemStack var1, int var2, int var3, BakedModel var4);

    private BakedModel transformEatingModel(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        ClientLevel cl;
        BakedModel initialModel = this.f_115095_.m_109406_(stack);
        ClientLevel clientLevel = level instanceof ClientLevel ? (cl = (ClientLevel)level) : null;
        BakedModel initialOverridenModel = initialModel.m_7343_().m_173464_(initialModel, stack, clientLevel, entity, seed);
        BakedModel transformedModel = ItemRendererMixin.checkOverrideContains(initialModel.m_7343_(), new ResourceLocation("eatinganimation", "eat")) ? this.f_115095_.m_109406_(stack) : initialOverridenModel;
        return transformedModel == null ? this.f_115095_.m_109393_().m_119409_() : transformedModel;
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/renderer/entity/ItemRenderer;tryRenderGuiItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;III)V"}, cancellable=true)
    private void eatinganimation$tryRenderGuiItem(@Nullable LivingEntity entity, ItemStack stack, int x, int y, int seed, CallbackInfo ci) {
        if (stack.m_41619_() || !stack.m_41614_() || entity == null) {
            return;
        }
        if (entity.m_21211_() != stack) {
            return;
        }
        BakedModel model = this.transformEatingModel(stack, null, entity, seed);
        this.f_115093_ = model.m_7539_() ? this.f_115093_ + 50.0f + (float)seed : this.f_115093_ + 50.0f;
        try {
            this.m_115127_(stack, x, y, model);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
            crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
            crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashreport);
        }
        this.f_115093_ = model.m_7539_() ? this.f_115093_ - 50.0f - (float)seed : this.f_115093_ - 50.0f;
        ci.cancel();
    }

    private static boolean checkOverrideContains(ItemOverrides overrides, ResourceLocation predicate) {
        return Arrays.asList(overrides.f_173461_).contains(predicate);
    }
}

