/*
 * Decompiled with CFR 0.152.
 */
package com.anar4732.opf;

import com.anar4732.opf.OPFEntity;
import com.anar4732.opf.OPFMod;
import com.anar4732.opf.Utils;
import com.anar4732.opf.client.OPFModClient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import team.creative.creativecore.common.util.math.box.AlignedBox;

public class OPFBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    public static final BooleanProperty VISIBLE = BooleanProperty.m_61465_((String)"visible");
    private final boolean dummy;
    private final boolean floor;

    public OPFBlock(boolean dummy, Boolean floor) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(5.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60910_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.EAST)).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.dummy = dummy;
        this.floor = floor;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        OPFEntity te;
        if (!this.dummy && (te = (OPFEntity)world.m_7702_(pos)) != null) {
            if (placer.m_6144_()) {
                te.onFloor = true;
                world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)VISIBLE, (Comparable)Boolean.valueOf(false)), 2);
            }
            te.updateBlocks();
        }
    }

    public OPFEntity findMainTE(Level world, BlockPos pos) {
        if (!this.dummy) {
            return (OPFEntity)world.m_7702_(pos);
        }
        if (this.floor) {
            Direction direction = ((Direction)world.m_8055_(pos).m_61143_((Property)FACING)).m_122424_();
            for (int y = 0; y < 32; ++y) {
                BlockPos pos2 = pos.m_5484_(direction, y);
                if (world.m_8055_(pos2).m_60734_() == OPFMod.BLOCK_OPF_DUMMY_FLOOR.get()) {
                    if (world.m_8055_(pos.m_5484_(direction, y + 1)).m_60734_() == OPFMod.BLOCK_OPF_DUMMY_FLOOR.get()) continue;
                    for (int x = 0; x < 32; ++x) {
                        BlockPos pos3 = pos2.m_5484_(direction.m_122427_(), x);
                        if (world.m_8055_(pos3).m_60734_() != OPFMod.BLOCK_OPF.get()) continue;
                        return (OPFEntity)world.m_7702_(pos3);
                    }
                    continue;
                }
                if (world.m_8055_(pos2).m_60734_() != OPFMod.BLOCK_OPF.get()) continue;
                return (OPFEntity)world.m_7702_(pos2);
            }
        } else {
            Direction direction = ((Direction)world.m_8055_(pos).m_61143_((Property)FACING)).m_122427_().m_122424_();
            for (int y = 0; y < 32; ++y) {
                BlockPos pos2 = pos.m_6625_(y);
                if (world.m_8055_(pos2).m_60734_() == OPFMod.BLOCK_OPF_DUMMY.get()) {
                    if (world.m_8055_(pos2.m_7495_()).m_60734_() == OPFMod.BLOCK_OPF_DUMMY.get()) continue;
                    for (int x = 0; x < 32; ++x) {
                        BlockPos pos3 = pos2.m_5484_(direction, x);
                        if (world.m_8055_(pos3).m_60734_() != OPFMod.BLOCK_OPF.get()) continue;
                        return (OPFEntity)world.m_7702_(pos3);
                    }
                    continue;
                }
                if (world.m_8055_(pos2).m_60734_() != OPFMod.BLOCK_OPF.get()) continue;
                return (OPFEntity)world.m_7702_(pos2);
            }
        }
        return null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        OPFEntity te = this.findMainTE(world, pos);
        if (te != null) {
            te.removeBlocks();
            world.m_46961_(te.m_58899_(), true);
        }
        super.m_5707_(world, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList list = Lists.newArrayList();
        if (!this.dummy) {
            list.add(new ItemStack((ItemLike)OPFMod.ITEM_OPF.get()));
        }
        return list;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        OPFEntity te = this.findMainTE(world, pos);
        if (te != null && player.m_150110_().f_35938_) {
            if (world.f_46443_) {
                DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> new OPFModClient.OpenGUI(te));
            }
            te.m_6596_();
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (this.dummy) {
            return null;
        }
        return new OPFEntity(pos, state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (te instanceof OPFEntity) {
            OPFEntity teopf = (OPFEntity)te;
            return Utils.toVoxelShape(new AlignedBox(OPFEntity.getBoundingBox(teopf)));
        }
        if (this.floor) {
            return Utils.toVoxelShape(new AlignedBox(0.0f, 0.0f, 0.0f, 1.0f, 0.05f, 1.0f));
        }
        AlignedBox cube = new AlignedBox(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            direction = direction.m_122424_();
        }
        return Utils.toVoxelShape(Utils.rotateCube(cube, direction));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ATTACHED, VISIBLE});
    }
}

