/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config;

import com.teamresourceful.resourcefulconfig.common.config.ConfigLoader;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.forge.ConfiguratorImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;

public class Configurator {
    private final Map<String, ResourcefulConfig> configs = new HashMap<String, ResourcefulConfig>();
    private final Map<Class<?>, String> configClasses = new HashMap();
    private final ConfigLoader creator;

    public Configurator() {
        this(false);
    }

    public Configurator(boolean forceLoad) {
        this.creator = Configurator.getCreator(forceLoad);
    }

    public void registerConfig(Class<?> configClass) {
        ResourcefulConfig config = this.creator.registerConfig(configClass);
        if (config != null) {
            this.configs.put(config.getFileName(), config);
            this.configClasses.put(configClass, config.getFileName());
            Configurations.INSTANCE.addConfig(config);
        }
    }

    public boolean saveConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.saveConfig(this.configClasses.get(config));
        }
        return false;
    }

    public boolean saveConfig(String fileName) {
        ResourcefulConfig config = this.getConfig(fileName);
        if (config != null) {
            config.save();
            return true;
        }
        return false;
    }

    public boolean loadConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.loadConfig(this.configClasses.get(config));
        }
        return false;
    }

    public boolean loadConfig(String fileName) {
        ResourcefulConfig config = this.getConfig(fileName);
        if (config != null) {
            config.load();
            return true;
        }
        return false;
    }

    public ResourcefulConfig getConfig(String fileName) {
        return this.configs.get(fileName);
    }

    public ResourcefulConfig getConfig(Class<?> config) {
        if (this.configClasses.containsKey(config)) {
            return this.getConfig(this.configClasses.get(config));
        }
        return null;
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ConfigLoader getCreator(boolean forceLoad) {
        return ConfiguratorImpl.getCreator(forceLoad);
    }
}

