/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.world.feature.config.BigFungyssFeatureConfig;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.common.Tags;

public class BigFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public BigFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(RandomSource random, int variant) {
        if (variant == 0) {
            return random.m_188503_(3) + 4;
        }
        return random.m_188503_(2) + 6;
    }

    private boolean canGenerate(LevelAccessor world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.MutableBlockPos mutable) {
        if (pos.m_123342_() < 1 || pos.m_123342_() + height + 1 >= generator.m_6331_()) {
            return false;
        }
        if (!world.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.STONE)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, 0, i, 0));
            if (state.m_60795_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_142674_(@Nonnull FeaturePlaceContext<BigFungyssFeatureConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        RandomSource random = context.m_225041_();
        int height = this.getRandomHeight(random, ((BigFungyssFeatureConfig)context.m_159778_()).variant);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!this.canGenerate((LevelAccessor)level, context.m_159775_(), pos, height, mutable)) {
            return false;
        }
        this.placeCap((LevelAccessor)level, random, pos, height, mutable, (BigFungyssFeatureConfig)context.m_159778_());
        this.placeStem((LevelAccessor)level, random, pos, height, mutable, (BigFungyssFeatureConfig)context.m_159778_());
        return true;
    }

    private void placeStem(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            mutable.m_122190_((Vec3i)pos).m_122175_(Direction.UP, i);
            if (world.m_8055_((BlockPos)mutable).m_60804_((BlockGetter)world, (BlockPos)mutable)) continue;
            this.m_5974_((LevelWriter)world, (BlockPos)mutable, config.stemProvider.m_213972_(random, pos));
        }
    }

    private void placeCap(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        if (config.variant == 0) {
            int distanceToStem = 1;
            for (int i = height - 2; i <= height; ++i) {
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if ((i >= height || xOffset == 0 && zOffset == 0) && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.m_122154_((Vec3i)pos, xOffset, i, zOffset);
                        this.m_5974_((LevelWriter)world, (BlockPos)mutable, config.capProvider.m_213972_(random, pos));
                    }
                }
            }
            this.m_5974_((LevelWriter)world, pos.m_6630_(height), config.capProvider.m_213972_(random, pos));
        } else {
            for (int i = height - 2; i <= height; ++i) {
                int distanceToStem = i < height ? 2 : 1;
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if (i < height && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.m_122154_((Vec3i)pos, xOffset, i, zOffset);
                        this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.m_213972_(random, pos).m_61124_((Property)HugeMushroomBlock.f_54131_, (Comparable)Boolean.valueOf(i >= height - 1))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(xOffset < 0))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(xOffset > 0))).m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(zOffset < 0))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(zOffset > 0)));
                    }
                }
            }
            for (Direction direction : Direction.values()) {
                if (direction.m_122434_() == Direction.Axis.Y) continue;
                mutable.m_122154_((Vec3i)pos, 0, height - 4, 0);
                mutable.m_122173_(direction);
                this.m_5974_((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.m_213972_(random, pos).m_61124_((Property)PipeBlock.f_55154_.get(direction.m_122424_()), (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

