/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticKey;
import net.valhelsia.valhelsia_core.client.cosmetics.source.CosmeticsSource;

public class FACosmeticsSource
extends CosmeticsSource {
    private static final String URL = "https://raw.githubusercontent.com/stal111/Mandala-Supporters/main/supporters.json";
    private static final Map<UUID, PatreonLevel> PATREON_LEVEL_MAP = new HashMap<UUID, PatreonLevel>();

    public FACosmeticsSource(String name) {
        super(name);
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(URL).openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            InputStream stream = connection.getInputStream();
            if (connection.getResponseCode() != 200) {
                stream.close();
                if (connection.getErrorStream() != null) {
                    connection.getErrorStream().close();
                }
            } else {
                JsonObject jsonObject = GsonHelper.m_13859_((Reader)new InputStreamReader(stream));
                for (String key : jsonObject.keySet()) {
                    PatreonLevel level = PatreonLevel.valueOf(key.toUpperCase(Locale.ROOT));
                    jsonObject.getAsJsonArray(key).forEach(jsonElement -> PATREON_LEVEL_MAP.put(UUID.fromString(jsonElement.getAsString().replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5")), level));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<CosmeticKey> loadCosmeticsFor(UUID uuid) {
        if (!PATREON_LEVEL_MAP.containsKey(uuid)) {
            return List.of();
        }
        return PATREON_LEVEL_MAP.get(uuid).getCosmetics().stream().map(s -> new CosmeticKey((CosmeticsSource)this, s)).toList();
    }

    public void loadTextures(CosmeticKey key) {
        this.registerMainTexture(key, new ResourceLocation("forbidden_arcanus", "textures/cosmetic/" + key.name() + ".png"));
    }

    private static enum PatreonLevel implements StringRepresentable
    {
        SILVER_BLACKSMITH("silver_blacksmith", new String[0]),
        GOLDEN_FIGHTER("golden_fighter", "draco_aurum_head"),
        ARCANE_SORCERER("arcane_sorcerer", "draco_aurum_head", "draco_aurum_wings"),
        NEBULA_CLUB("nebula_club", "draco_aurum_head", "draco_aurum_wings");

        private static final String DRACO_AURUM_HEAD = "draco_aurum_head";
        private static final String DRACO_AURUM_WINGS = "draco_aurum_wings";
        private final String name;
        private final List<String> cosmetics;

        private PatreonLevel(String name, String ... cosmetics) {
            this.name = name;
            this.cosmetics = List.of(cosmetics);
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public List<String> getCosmetics() {
            return this.cosmetics;
        }
    }
}

