/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.component;

import com.mojang.logging.LogUtils;
import gg.moonflower.pinwheel.api.particle.component.ParticleExpireNotInBlocksComponent;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleTickComponent;
import gg.moonflower.pollen.impl.render.particle.component.BedrockParticleComponentImpl;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ParticleExpireNotInBlocksComponentImpl
extends BedrockParticleComponentImpl
implements BedrockParticleTickComponent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Block[] blocks;

    public ParticleExpireNotInBlocksComponentImpl(BedrockParticle particle, ParticleExpireNotInBlocksComponent data) {
        super(particle);
        this.blocks = (Block[])Arrays.stream(data.blocks()).map(name -> {
            ResourceLocation id = ResourceLocation.m_135820_((String)name);
            if (id == null) {
                LOGGER.error("Invalid block id: " + name);
                return null;
            }
            if (!Registry.f_122824_.m_7804_(id)) {
                LOGGER.error("Unknown block: " + name);
                return null;
            }
            return (Block)Registry.f_122824_.m_7745_(id);
        }).filter(Objects::nonNull).toArray(Block[]::new);
    }

    @Override
    public void tick() {
        Level level = this.particle.getLevel();
        Block block = level.m_8055_(this.particle.blockPosition()).m_60734_();
        for (Block test : this.blocks) {
            if (block == test) continue;
            this.particle.expire();
            break;
        }
    }
}

