/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.particle.component;

import com.mojang.math.Vector3f;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.pinwheel.api.particle.ParticleInstance;
import gg.moonflower.pinwheel.api.particle.component.ParticleAppearanceBillboardComponent;
import gg.moonflower.pinwheel.api.particle.render.ParticleRenderProperties;
import gg.moonflower.pinwheel.api.particle.render.SingleQuadRenderProperties;
import gg.moonflower.pollen.api.joml.v1.JomlBridge;
import gg.moonflower.pollen.api.render.particle.v1.BedrockParticle;
import gg.moonflower.pollen.api.render.particle.v1.MinecraftSingleQuadRenderProperties;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticlePhysics;
import gg.moonflower.pollen.api.render.particle.v1.component.BedrockParticleRenderComponent;
import gg.moonflower.pollen.api.render.particle.v1.listener.BedrockParticleListener;
import gg.moonflower.pollen.impl.render.particle.MinecraftSingleQuadRenderPropertiesImpl;
import gg.moonflower.pollen.impl.render.particle.component.BedrockParticleComponentImpl;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionf;
import org.joml.Vector3dc;

@ApiStatus.Internal
public class ParticleAppearanceBillboardComponentImpl
extends BedrockParticleComponentImpl
implements BedrockParticleListener,
BedrockParticleRenderComponent {
    private final ParticleAppearanceBillboardComponent data;

    public ParticleAppearanceBillboardComponentImpl(BedrockParticle particle, ParticleAppearanceBillboardComponent data) {
        super(particle);
        this.data = data;
    }

    private static SingleQuadRenderProperties getRenderProperties(BedrockParticle particle) {
        ParticleRenderProperties particleRenderProperties = particle.getRenderProperties();
        if (particleRenderProperties instanceof MinecraftSingleQuadRenderProperties) {
            MinecraftSingleQuadRenderProperties properties = (MinecraftSingleQuadRenderProperties)particleRenderProperties;
            return properties;
        }
        MinecraftSingleQuadRenderPropertiesImpl properties = new MinecraftSingleQuadRenderPropertiesImpl();
        particle.setRenderProperties(properties);
        return properties;
    }

    @Override
    public void render(Camera camera, float partialTicks) {
        MolangEnvironment environment = this.particle.getEnvironment();
        SingleQuadRenderProperties renderProperties = ParticleAppearanceBillboardComponentImpl.getRenderProperties(this.particle);
        renderProperties.setWidth(environment.safeResolve(this.data.size()[0]));
        renderProperties.setHeight(environment.safeResolve(this.data.size()[1]));
        this.data.textureSetter().setUV((ParticleInstance)this.particle, environment, renderProperties);
        switch (this.data.cameraMode()) {
            case ROTATE_XYZ: {
                JomlBridge.set(renderProperties.getRotation(), camera.m_90591_());
                break;
            }
            case ROTATE_Y: {
                renderProperties.getRotation().setAngleAxis((float)(-((double)camera.m_90590_() * Math.PI / 180.0)), 0.0f, 1.0f, 0.0f);
                break;
            }
            case LOOK_AT_XYZ: {
                Vector3dc pos = this.particle.position(partialTicks);
                double dx = camera.m_90583_().m_7096_() - pos.x();
                double dy = camera.m_90583_().m_7098_() - pos.y();
                double dz = camera.m_90583_().m_7094_() - pos.z();
                float yRot = (float)Mth.m_14136_((double)dz, (double)dx);
                float xRot = (float)Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz));
                Quaternionf rotation = renderProperties.getRotation().identity();
                rotation.rotateZYX(0.0f, -(1.5707964f + yRot), xRot);
                break;
            }
            case LOOK_AT_Y: {
                Vector3dc pos = this.particle.position(partialTicks);
                double dx = camera.m_90583_().m_7096_() - pos.x();
                double dz = camera.m_90583_().m_7094_() - pos.z();
                float yRot = (float)Mth.m_14136_((double)dz, (double)dx);
                Quaternionf rotation = renderProperties.getRotation().identity();
                rotation.rotateY(-(1.5707964f + yRot));
                break;
            }
            case DIRECTION_X: {
                double dz;
                double dy;
                double dx;
                BedrockParticlePhysics physics = this.particle.getPhysics();
                if (physics == null) {
                    return;
                }
                MolangExpression[] customDirection = this.data.customDirection();
                if (customDirection != null) {
                    dx = environment.safeResolve(customDirection[0]);
                    dy = environment.safeResolve(customDirection[1]);
                    dz = environment.safeResolve(customDirection[2]);
                } else {
                    Vector3dc direction = physics.getDirection();
                    boolean factor = physics.getSpeed() > this.data.minSpeedThreshold();
                    dx = (double)factor * direction.x();
                    dy = (double)factor * direction.y();
                    dz = (double)factor * direction.z();
                }
                float yRot = (float)Mth.m_14136_((double)dz, (double)dx);
                float xRot = (float)Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz));
                Quaternionf rotation = renderProperties.getRotation().identity();
                rotation.rotateZYX(0.0f, -yRot, xRot);
                break;
            }
            case DIRECTION_Y: {
                double dz;
                double dy;
                double dx;
                BedrockParticlePhysics physics = this.particle.getPhysics();
                if (physics == null) {
                    return;
                }
                MolangExpression[] customDirection = this.data.customDirection();
                if (customDirection != null) {
                    dx = environment.safeResolve(customDirection[0]);
                    dy = environment.safeResolve(customDirection[1]);
                    dz = environment.safeResolve(customDirection[2]);
                } else {
                    Vector3dc direction = physics.getDirection();
                    boolean factor = physics.getSpeed() > this.data.minSpeedThreshold();
                    dx = (double)factor * direction.x();
                    dy = (double)factor * direction.y();
                    dz = (double)factor * direction.z();
                }
                float yRot = (float)Mth.m_14136_((double)dz, (double)dx);
                float xRot = (float)Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz));
                Quaternionf rotation = renderProperties.getRotation().identity();
                rotation.rotateZYX(0.0f, -(yRot - 1.5707964f), -(xRot - 1.5707964f));
                break;
            }
            case DIRECTION_Z: {
                double dz;
                double dy;
                double dx;
                BedrockParticlePhysics physics = this.particle.getPhysics();
                if (physics == null) {
                    return;
                }
                MolangExpression[] customDirection = this.data.customDirection();
                if (customDirection != null) {
                    dx = environment.safeResolve(customDirection[0]);
                    dy = environment.safeResolve(customDirection[1]);
                    dz = environment.safeResolve(customDirection[2]);
                } else {
                    Vector3dc direction = physics.getDirection();
                    boolean factor = physics.getSpeed() > this.data.minSpeedThreshold();
                    dx = (double)factor * direction.x();
                    dy = (double)factor * direction.y();
                    dz = (double)factor * direction.z();
                }
                float yRot = (float)Mth.m_14136_((double)dz, (double)dx);
                float xRot = (float)Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz));
                Quaternionf rotation = renderProperties.getRotation().identity();
                rotation.rotateZYX(0.0f, -(1.5707964f + yRot), xRot);
            }
        }
    }

    @Override
    public void onCreate(BedrockParticle particle) {
        SingleQuadRenderProperties renderProperties = ParticleAppearanceBillboardComponentImpl.getRenderProperties(particle);
        switch (this.data.cameraMode()) {
            case EMITTER_TRANSFORM_XZ: {
                JomlBridge.set(renderProperties.getRotation(), Vector3f.f_122223_.m_122240_(90.0f));
                break;
            }
            case EMITTER_TRANSFORM_YZ: {
                JomlBridge.set(renderProperties.getRotation(), Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
    }
}

