/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.impl.render.geometry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import gg.moonflower.pinwheel.api.transform.MatrixStack;
import gg.moonflower.pollen.api.joml.v1.JomlBridge;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@ApiStatus.Internal
public class PoseStackWrapper
implements MatrixStack {
    private final PoseStack poseStack;
    private final Vector3f axis;

    public PoseStackWrapper(PoseStack poseStack) {
        this.poseStack = poseStack;
        this.axis = new Vector3f();
    }

    public void reset() {
        while (!this.poseStack.m_85851_()) {
            this.poseStack.m_85849_();
        }
        this.poseStack.m_166856_();
    }

    public void translate(float x, float y, float z) {
        this.poseStack.m_85837_((double)x, (double)y, (double)z);
    }

    public void rotate(Quaternionfc rotation) {
        this.poseStack.m_85845_(new Quaternion(rotation.x(), rotation.y(), rotation.z(), rotation.w()));
    }

    public void rotate(float amount, float x, float y, float z) {
        this.axis.m_122245_(x, y, z);
        this.poseStack.m_85845_(new Quaternion(this.axis, amount, false));
    }

    public void rotateXYZ(float x, float y, float z) {
        this.poseStack.m_85845_(Vector3f.f_122223_.m_122270_(x));
        this.poseStack.m_85845_(Vector3f.f_122225_.m_122270_(y));
        this.poseStack.m_85845_(Vector3f.f_122227_.m_122270_(z));
    }

    public void rotateZYX(float z, float y, float x) {
        this.poseStack.m_85845_(Vector3f.f_122227_.m_122270_(z));
        this.poseStack.m_85845_(Vector3f.f_122225_.m_122270_(y));
        this.poseStack.m_85845_(Vector3f.f_122223_.m_122270_(x));
    }

    public void scale(float x, float y, float z) {
        this.poseStack.m_85841_(x, y, z);
    }

    public void pushMatrix() {
        this.poseStack.m_85836_();
    }

    public void popMatrix() {
        this.poseStack.m_85849_();
    }

    public Matrix4f position() {
        return JomlBridge.set(new Matrix4f(), this.poseStack.m_85850_().m_85861_());
    }

    public Matrix3f normal() {
        return JomlBridge.set(new Matrix3f(), this.poseStack.m_85850_().m_85864_());
    }
}

