/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.compat.jei;

import com.google.common.collect.ImmutableSet;
import gg.moonflower.pollen.api.crafting.v1.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenGrindstoneRecipe;
import gg.moonflower.pollen.api.crafting.v1.PollenRecipeTypes;
import gg.moonflower.pollen.core.compat.jei.PollenGrindstoneCategory;
import gg.moonflower.pollen.core.compat.jei.PollenRecipeMaker;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
@ApiStatus.Internal
public class PollenJeiPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_ID = new ResourceLocation("pollen", "vanilla");
    public static final RecipeType<PollenGrindstoneRecipe> GRINDSTONE_RECIPE_TYPE = RecipeType.create((String)"pollen", (String)"grindstone", PollenGrindstoneRecipe.class);
    @Nullable
    private PollenGrindstoneCategory grindstoneCategory;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.grindstoneCategory = new PollenGrindstoneCategory(guiHelper);
        iRecipeCategoryArray[0] = this.grindstoneCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Validate.notNull((Object)this.grindstoneCategory, (String)"grindstoneCategory", (Object[])new Object[0]);
        ImmutableSet potions = ImmutableSet.of((Object)Items.f_42589_, (Object)Items.f_42736_, (Object)Items.f_42739_);
        List<PollenBrewingRecipe> recipes = PollenRecipeMaker.getRecipes(null, PollenRecipeTypes.BREWING_TYPE.get());
        for (PollenBrewingRecipe recipe : recipes) {
            List<ItemStack> ingredients = Arrays.asList(recipe.getIngredient().m_43908_());
            registration.addRecipes(RecipeTypes.BREWING, potions.stream().map(item -> {
                ItemStack input = new ItemStack((ItemLike)item);
                ItemStack result = new ItemStack((ItemLike)item);
                PotionUtils.m_43549_((ItemStack)input, (Potion)recipe.getFrom());
                PotionUtils.m_43549_((ItemStack)result, (Potion)recipe.getResult());
                return registration.getVanillaRecipeFactory().createBrewingRecipe(ingredients, input, result);
            }).collect(Collectors.toList()));
        }
        registration.addRecipes(GRINDSTONE_RECIPE_TYPE, PollenRecipeMaker.getGrindstoneRecipes(this.grindstoneCategory, registration.getIngredientManager()));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(GrindstoneScreen.class, 95, 34, 22, 15, new RecipeType[]{GRINDSTONE_RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(GrindstoneMenu.class, MenuType.f_39971_, GRINDSTONE_RECIPE_TYPE, 0, 2, 3, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50623_), new RecipeType[]{GRINDSTONE_RECIPE_TYPE});
    }

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }
}

