/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.render.particle.v1;

import com.mojang.datafixers.util.Pair;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.bridge.MolangVariable;
import gg.moonflower.molangcompiler.api.bridge.MolangVariableProvider;
import gg.moonflower.pinwheel.api.particle.ParticleData;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;

public record BedrockParticleCurves(Map<String, Pair<ParticleData.Curve, MolangVariable>> variables) implements MolangVariableProvider
{
    public BedrockParticleCurves(ParticleData data) {
        this(data.curves().entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> {
            String[] parts = ((String)entry.getKey()).split("\\.", 2);
            return parts.length > 1 ? parts[1] : parts[0];
        }, entry -> Pair.of((Object)((ParticleData.Curve)entry.getValue()), (Object)MolangVariable.create()))));
    }

    public void evaluate(MolangEnvironment environment, ProfilerFiller profiler) {
        if (this.variables.isEmpty()) {
            return;
        }
        profiler.m_6180_("evaluateCurves");
        this.variables.forEach((variable, pair) -> ((MolangVariable)pair.getSecond()).setValue(BedrockParticleCurves.evaluateCurve(environment, (ParticleData.Curve)pair.getFirst())));
        profiler.m_7238_();
    }

    public void addMolangVariables(MolangVariableProvider.Context context) {
        this.variables.forEach((name, pair) -> context.addVariable(name, (MolangVariable)pair.getSecond()));
    }

    private static float evaluateCurve(MolangEnvironment environment, ParticleData.Curve curve) {
        float horizontalRange = environment.safeResolve(curve.horizontalRange());
        if (horizontalRange == 0.0f) {
            return 1.0f;
        }
        float input = environment.safeResolve(curve.input()) / horizontalRange;
        ParticleData.CurveNode[] nodes = curve.nodes();
        int index = BedrockParticleCurves.getIndex(curve, input);
        switch (curve.type()) {
            case LINEAR: {
                ParticleData.CurveNode current = nodes[index];
                ParticleData.CurveNode next = index + 1 >= nodes.length ? current : nodes[index + 1];
                float a = environment.safeResolve(current.getValue());
                float b = environment.safeResolve(next.getValue());
                float progress = (input - current.getTime()) / (next.getTime() - current.getTime());
                return Mth.m_14179_((float)progress, (float)a, (float)b);
            }
            case BEZIER: {
                float a = environment.safeResolve(nodes[0].getValue());
                float b = environment.safeResolve(nodes[1].getValue());
                float c = environment.safeResolve(nodes[2].getValue());
                float d = environment.safeResolve(nodes[3].getValue());
                return BedrockParticleCurves.bezier(a, b, c, d, input);
            }
            case BEZIER_CHAIN: {
                ParticleData.BezierChainCurveNode current = (ParticleData.BezierChainCurveNode)nodes[index];
                if (index + 1 >= nodes.length) {
                    return environment.safeResolve(current.getRightValue());
                }
                ParticleData.BezierChainCurveNode next = (ParticleData.BezierChainCurveNode)nodes[index + 1];
                float step = input - current.getTime() + next.getTime() / 3.0f;
                float a = environment.safeResolve(current.getRightValue());
                float b = a + step * environment.safeResolve(current.getRightSlope());
                float d = environment.safeResolve(next.getLeftValue());
                float c = d - step * environment.safeResolve(next.getLeftSlope());
                float progress = (input - current.getTime()) / (next.getTime() - current.getTime());
                return BedrockParticleCurves.bezier(a, b, c, d, progress);
            }
            case CATMULL_ROM: {
                try {
                    ParticleData.CurveNode last = nodes[index - 1];
                    ParticleData.CurveNode from = nodes[index];
                    ParticleData.CurveNode to = nodes[index + 1];
                    ParticleData.CurveNode after = nodes[index + 2];
                    float a = environment.safeResolve(last.getValue());
                    float b = environment.safeResolve(from.getValue());
                    float c = environment.safeResolve(to.getValue());
                    float d = environment.safeResolve(after.getValue());
                    float nextTime = to.getTime();
                    float progress = (input - from.getTime()) / (nextTime - from.getTime());
                    return BedrockParticleCurves.catmullRom(a, b, c, d, Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return input;
    }

    private static int getIndex(ParticleData.Curve curve, float input) {
        ParticleData.CurveNode node;
        int offset;
        int best = 0;
        ParticleData.CurveNode[] nodes = curve.nodes();
        int i = offset = curve.type() == ParticleData.CurveType.CATMULL_ROM ? 1 : 0;
        while (i < nodes.length - offset * 2 && !((node = nodes[i]).getTime() > input)) {
            best = i++;
        }
        return best;
    }

    private static float bezier(float p0, float p1, float p2, float p3, float t) {
        return (1.0f - t) * (1.0f - t) * (1.0f - t) * p0 + 3.0f * (1.0f - t) * (1.0f - t) * t * p1 + 3.0f * (1.0f - t) * t * t * p2 + t * t * t * p3;
    }

    private static float catmullRom(float p0, float p1, float p2, float p3, float t) {
        return 0.5f * (2.0f * p1 + (-p0 + p2) * t + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * t * t + (-p0 + 3.0f * p1 - 3.0f * p2 + p3) * t * t * t);
    }
}

