/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.bookstate.EntryState;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SaveEntryStateMessage
implements Message {
    public BookEntry entry;
    public int openPagesIndex;

    public SaveEntryStateMessage(BookEntry entry, int openPagesIndex) {
        this.entry = entry;
        this.openPagesIndex = openPagesIndex;
    }

    public SaveEntryStateMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.entry.getBook().getId());
        buf.m_130085_(this.entry.getId());
        buf.m_130130_(this.openPagesIndex);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entry = BookDataManager.get().getBook(buf.m_130281_()).getEntry(buf.m_130281_());
        this.openPagesIndex = buf.m_130242_();
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        EntryState currentState = BookStateCapability.getEntryStateFor((Player)player, this.entry);
        currentState.openPagesIndex = this.openPagesIndex;
        BookStateCapability.setEntryStateFor((Player)player, this.entry, currentState);
        BookStateCapability.syncFor(player);
    }
}

