/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCategoryBackgroundParallaxLayer;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.context.BookConditionEntryContext;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import com.klikli_dev.modonomicon.capability.bookstate.CategoryState;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookContentScreen;
import com.klikli_dev.modonomicon.client.gui.book.BookOverviewScreen;
import com.klikli_dev.modonomicon.client.gui.book.EntryConnectionRenderer;
import com.klikli_dev.modonomicon.client.gui.book.EntryDisplayState;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.network.messages.BookEntryReadMessage;
import com.klikli_dev.modonomicon.network.messages.SaveCategoryStateMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class BookCategoryScreen {
    public static final int ENTRY_GRID_SCALE = 30;
    public static final int ENTRY_GAP = 2;
    public static final int MAX_SCROLL = 512;
    public static final int ENTRY_HEIGHT = 26;
    public static final int ENTRY_WIDTH = 26;
    private final BookOverviewScreen bookOverviewScreen;
    private final BookCategory category;
    private final EntryConnectionRenderer connectionRenderer;
    private float scrollX = 0.0f;
    private float scrollY = 0.0f;
    private boolean isScrolling;
    private float targetZoom;
    private float currentZoom;
    private ResourceLocation openEntry;

    public BookCategoryScreen(BookOverviewScreen bookOverviewScreen, BookCategory category) {
        this.bookOverviewScreen = bookOverviewScreen;
        this.category = category;
        this.connectionRenderer = this.bookOverviewScreen.getConnectionRenderer();
        this.currentZoom = this.targetZoom = 0.7f;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public float getXOffset() {
        return (float)this.bookOverviewScreen.getInnerWidth() / 2.0f * (1.0f / this.currentZoom) - this.scrollX / 2.0f;
    }

    public float getYOffset() {
        return (float)this.bookOverviewScreen.getInnerHeight() / 2.0f * (1.0f / this.currentZoom) - this.scrollY / 2.0f;
    }

    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (((Boolean)ClientConfig.get().qolCategory.enableSmoothZoom.get()).booleanValue()) {
            float diff = this.targetZoom - this.currentZoom;
            this.currentZoom += Math.min(pPartialTick * 0.6666667f, 1.0f) * diff;
        } else {
            this.currentZoom = this.targetZoom;
        }
        int scale = (int)this.bookOverviewScreen.getMinecraft().m_91268_().m_85449_();
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth() - 1;
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        RenderSystem.m_69488_((int)(innerX * scale), (int)(innerY * scale), (int)(innerWidth * scale), (int)(innerHeight * scale));
        this.renderEntries(pPoseStack, pMouseX, pMouseY);
        RenderSystem.m_69471_();
        this.renderEntryTooltips(pPoseStack, pMouseX, pMouseY);
    }

    public void zoom(double delta) {
        float step = 1.2f;
        if (delta < 0.0 && (double)this.targetZoom > 0.5 || delta > 0.0 && this.targetZoom < 1.0f) {
            this.targetZoom *= delta > 0.0 ? step : 1.0f / step;
        }
        if (this.targetZoom > 1.0f) {
            this.targetZoom = 1.0f;
        }
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (pButton != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else {
            this.scroll(pDragX * 1.5, pDragY * 1.5);
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayStyle = this.getEntryDisplayState(entry);
            if (displayStyle != EntryDisplayState.UNLOCKED || !this.isEntryHovered(entry, xOffset, yOffset, (int)pMouseX, (int)pMouseY)) continue;
            this.openEntry(entry);
            return true;
        }
        return false;
    }

    public BookContentScreen openEntry(BookEntry entry) {
        if (!BookUnlockCapability.isReadFor((Player)Minecraft.m_91087_().f_91074_, entry)) {
            Networking.sendToServer(new BookEntryReadMessage(entry.getBook().getId(), entry.getId()));
        }
        if (entry.getCategoryToOpen() != null) {
            this.bookOverviewScreen.changeCategory(entry.getCategoryToOpen());
            return null;
        }
        this.openEntry = entry.getId();
        BookContentScreen bookContentScreen = new BookContentScreen(this.bookOverviewScreen, entry);
        Minecraft.m_91087_().pushGuiLayer((Screen)bookContentScreen);
        return bookContentScreen;
    }

    public void renderBackground(PoseStack poseStack) {
        float yScale;
        float scale;
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth();
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        float xScale = 1024.0f / (512.0f + (float)this.bookOverviewScreen.getFrameThicknessW() - (float)this.bookOverviewScreen.getFrameWidth());
        float xOffset = xScale == (scale = Math.max(xScale, yScale = 1024.0f / (512.0f + (float)this.bookOverviewScreen.getFrameThicknessH() - (float)this.bookOverviewScreen.getFrameHeight()))) ? 0.0f : (512.0f - ((float)innerWidth + 1024.0f / scale)) / 2.0f;
        float yOffset = yScale == scale ? 0.0f : (512.0f - ((float)innerHeight + 1024.0f / scale)) / 2.0f;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        if (!this.category.getBackgroundParallaxLayers().isEmpty()) {
            this.category.getBackgroundParallaxLayers().forEach(layer -> this.renderBackgroundParallaxLayer((BookCategoryBackgroundParallaxLayer)layer, poseStack, innerX, innerY, innerWidth, innerHeight, this.scrollX, this.scrollY, scale, xOffset, yOffset, this.currentZoom));
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.getBackground());
            GuiComponent.m_93143_((PoseStack)poseStack, (int)innerX, (int)innerY, (int)this.bookOverviewScreen.m_93252_(), (float)((this.scrollX + 512.0f) / scale + xOffset), (float)((this.scrollY + 512.0f) / scale + yOffset), (int)innerWidth, (int)innerHeight, (int)this.category.getBackgroundHeight(), (int)this.category.getBackgroundWidth());
        }
    }

    public void renderBackgroundParallaxLayer(BookCategoryBackgroundParallaxLayer layer, PoseStack poseStack, int x, int y, int width, int height, float scrollX, float scrollY, float parallax, float xOffset, float yOffset, float zoom) {
        float parallax1 = parallax / layer.getSpeed();
        RenderSystem.m_157456_((int)0, (ResourceLocation)layer.getBackground());
        if (layer.getVanishZoom() == -1.0f || layer.getVanishZoom() > zoom) {
            GuiComponent.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)this.bookOverviewScreen.m_93252_(), (float)((scrollX + 512.0f) / parallax1 + xOffset), (float)((scrollY + 512.0f) / parallax1 + yOffset), (int)width, (int)height, (int)this.category.getBackgroundHeight(), (int)this.category.getBackgroundWidth());
        }
    }

    private EntryDisplayState getEntryDisplayState(BookEntry entry) {
        LocalPlayer player = this.bookOverviewScreen.getMinecraft().f_91074_;
        boolean isEntryUnlocked = BookUnlockCapability.isUnlockedFor((Player)player, entry);
        boolean allParentsUnlocked = true;
        for (BookEntryParent parent : entry.getParents()) {
            if (BookUnlockCapability.isUnlockedFor((Player)player, parent.getEntry())) continue;
            allParentsUnlocked = false;
            break;
        }
        if (!allParentsUnlocked) {
            return EntryDisplayState.HIDDEN;
        }
        if (!isEntryUnlocked) {
            return entry.hideWhileLocked() ? EntryDisplayState.HIDDEN : EntryDisplayState.LOCKED;
        }
        return EntryDisplayState.UNLOCKED;
    }

    private void renderEntries(PoseStack stack, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        stack.m_85836_();
        stack.m_85841_(this.currentZoom, this.currentZoom, 1.0f);
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = this.getEntryDisplayState(entry);
            boolean isHovered = this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY);
            if (displayState == EntryDisplayState.HIDDEN) continue;
            if (displayState == EntryDisplayState.LOCKED) {
                RenderSystem.m_157429_((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
            } else if (isHovered) {
                RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            }
            int texX = entry.getEntryBackgroundVIndex() * 26;
            int texY = entry.getEntryBackgroundUIndex() * 26;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.getEntryTextures());
            stack.m_85836_();
            stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
            stack.m_85837_(0.0, 0.0, -350.0);
            this.bookOverviewScreen.m_93228_(stack, entry.getX() * 30 + 2, entry.getY() * 30 + 2, texX, texY, 26, 26);
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, 10.0);
            entry.getIcon().render(stack, entry.getX() * 30 + 2 + 5, entry.getY() * 30 + 2 + 5);
            stack.m_85849_();
            if (displayState == EntryDisplayState.UNLOCKED && !BookUnlockCapability.isReadFor((Player)this.bookOverviewScreen.getMinecraft().f_91074_, entry)) {
                int U = 350;
                int V = 19;
                int width = 11;
                int height = 11;
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_69478_();
                RenderSystem.m_69453_();
                RenderSystem.m_69482_();
                stack.m_85836_();
                stack.m_85837_(0.0, 0.0, 11.0);
                BookContentScreen.drawFromTexture(stack, this.bookOverviewScreen.getBook(), entry.getX() * 30 + 2 + 16 + 2, entry.getY() * 30 + 2 - 2, 350 + (isHovered ? 11 : 0), 19, 11, 11);
                stack.m_85849_();
            }
            stack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.renderConnections(stack, entry, xOffset, yOffset);
        }
        stack.m_85849_();
    }

    private void renderEntryTooltips(PoseStack stack, int mouseX, int mouseY) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        float xOffset = this.getXOffset();
        float yOffset = this.getYOffset();
        for (BookEntry entry : this.category.getEntries().values()) {
            EntryDisplayState displayState = this.getEntryDisplayState(entry);
            if (displayState == EntryDisplayState.HIDDEN) continue;
            this.renderTooltip(stack, entry, displayState, xOffset, yOffset, mouseX, mouseY);
        }
    }

    private boolean isEntryHovered(BookEntry entry, float xOffset, float yOffset, int mouseX, int mouseY) {
        int x = (int)(((float)(entry.getX() * 30) + xOffset + 2.0f) * this.currentZoom);
        int y = (int)(((float)(entry.getY() * 30) + yOffset + 2.0f) * this.currentZoom);
        int innerX = this.bookOverviewScreen.getInnerX();
        int innerY = this.bookOverviewScreen.getInnerY();
        int innerWidth = this.bookOverviewScreen.getInnerWidth();
        int innerHeight = this.bookOverviewScreen.getInnerHeight();
        return mouseX >= x && (float)mouseX <= (float)x + 26.0f * this.currentZoom && mouseY >= y && (float)mouseY <= (float)y + 26.0f * this.currentZoom && mouseX >= innerX && mouseX <= innerX + innerWidth && mouseY >= innerY && mouseY <= innerY + innerHeight;
    }

    private void renderTooltip(PoseStack stack, BookEntry entry, EntryDisplayState displayState, float xOffset, float yOffset, int mouseX, int mouseY) {
        if (this.isEntryHovered(entry, xOffset, yOffset, mouseX, mouseY)) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (displayState == EntryDisplayState.LOCKED) {
                tooltip.addAll(entry.getCondition().getTooltip(BookConditionEntryContext.of(this.bookOverviewScreen.getBook(), entry)));
            } else if (displayState == EntryDisplayState.UNLOCKED) {
                tooltip.add(Component.m_237115_((String)entry.getName()).m_130940_(ChatFormatting.BOLD));
                if (!entry.getDescription().isEmpty()) {
                    tooltip.add(Component.m_237115_((String)entry.getDescription()));
                }
            }
            this.bookOverviewScreen.m_169388_(stack, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private void renderConnections(PoseStack stack, BookEntry entry, float xOffset, float yOffset) {
        RenderSystem.m_69478_();
        for (BookEntryParent parent : entry.getParents()) {
            this.bookOverviewScreen.getConnectionRenderer().setBlitOffset(this.bookOverviewScreen.m_93252_());
            stack.m_85836_();
            stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.category.getEntryTextures());
            this.connectionRenderer.render(stack, entry, parent);
            stack.m_85849_();
        }
        RenderSystem.m_69461_();
    }

    private void scroll(double pDragX, double pDragY) {
        this.scrollX = (float)Mth.m_14008_((double)((double)this.scrollX - pDragX), (double)-512.0, (double)512.0);
        this.scrollY = (float)Mth.m_14008_((double)((double)this.scrollY - pDragY), (double)-512.0, (double)512.0);
    }

    private void loadCategoryState() {
        CategoryState state = BookStateCapability.getCategoryStateFor((Player)this.bookOverviewScreen.getMinecraft().f_91074_, this.category);
        BookGuiManager.get().currentCategory = this.category;
        BookGuiManager.get().currentCategoryScreen = this;
        if (state != null) {
            BookEntry openEntry;
            this.scrollX = state.scrollX;
            this.scrollY = state.scrollY;
            this.targetZoom = state.targetZoom;
            this.currentZoom = state.targetZoom;
            if (state.openEntry != null && (openEntry = this.category.getEntry(state.openEntry)) != null) {
                this.openEntry(openEntry);
            }
        }
    }

    public void onDisplay() {
        this.loadCategoryState();
    }

    public void onClose() {
        Networking.sendToServer(new SaveCategoryStateMessage(this.category, this.scrollX, this.scrollY, this.currentZoom, this.openEntry));
    }

    public void onCloseEntry(BookContentScreen screen) {
        this.openEntry = null;
    }
}

