/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class PacketConsumerForge<T extends MinimapMessage<T>>
implements BiConsumer<T, Supplier<NetworkEvent.Context>> {
    private final ServerMessageConsumer<T> serverHandler;
    private final ClientMessageConsumer<T> clientHandler;

    public PacketConsumerForge(ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(T msg, Supplier<NetworkEvent.Context> contextSupplier) {
        if (msg == null) {
            contextSupplier.get().setPacketHandled(true);
            return;
        }
        NetworkDirection networkDirection = contextSupplier.get().getDirection();
        if (this.clientHandler != null && networkDirection == NetworkDirection.PLAY_TO_CLIENT) {
            contextSupplier.get().enqueueWork(() -> this.clientHandler.handle((MinimapMessage)msg));
        } else if (this.serverHandler != null && networkDirection == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = contextSupplier.get().getSender();
            contextSupplier.get().enqueueWork(() -> this.serverHandler.handle(sender.m_20194_(), sender, (MinimapMessage)msg));
        }
        contextSupplier.get().setPacketHandled(true);
    }
}

